/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.ui.swt.serialport.internal;

import com.schott.let2.hw.serialport.ASerialPortConfiguration;
import com.schott.let2.hw.serialport.ISerialPortConfiguration;
import com.schott.let2.ui.swt.controls.dialog.ADialog;
import com.schott.let2.ui.swt.controls.value.Header;
import com.schott.let2.ui.swt.controls.viewer.CMultiTableViewer;
import com.schott.let2.ui.swt.serialport.internal.ConnectionSettingsObject;
import com.schott.let2.ui.swt.serialport.internal.PortConfigurationDialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConnectionSettingsDialog
extends ADialog {
    public static final int SEL_OK = 0;
    public static final int SEL_CANCEL = 1;
    private int selection = 1;
    protected ConnectionSettingsObject settings;
    private Composite compConfigs;
    private Header lblHeaderConfigs;
    private CMultiTableViewer viewer;
    private TableViewerColumn columnName;
    private TableViewerColumn columnBaudrate;
    private TableViewerColumn columnDataBits;
    private TableViewerColumn columnStopBits;
    private TableViewerColumn columnParity;
    private Composite compHWSettings;
    private Header lblHeaderHWSettings;
    private Label lblLoopBack;
    private Button btnLoopBack;
    private Label lblCorrectTiming;
    private Button btnCorrectTiming;
    private Composite compDebugSettings;
    private Header lblHeaderDebugSettings;
    private Label lblFrameOutput;
    private Button btnFrameOutput;
    private Button btnOK;
    private Button btnCancel;
    private IMenuListener configMenuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            if (ConnectionSettingsDialog.this.viewer != null && !ConnectionSettingsDialog.this.viewer.getTable().isDisposed()) {
                int[] index = ConnectionSettingsDialog.this.viewer.getTable().getSelectionIndices();
                if (index.length != 0) {
                    Action actionAdd = new Action(){

                        public void run() {
                            super.run();
                            ConnectionSettingsDialog.this.actionConfigAdd();
                        }
                    };
                    actionAdd.setText("Add");
                    Action actionEdit = new Action(){

                        public void run() {
                            super.run();
                            ConnectionSettingsDialog.this.actionConfigEdit();
                        }
                    };
                    actionEdit.setText("Edit");
                    Action actionDelete = new Action(){

                        public void run() {
                            super.run();
                            ConnectionSettingsDialog.this.actionConfigDelete();
                        }
                    };
                    actionDelete.setText("Delete");
                    manager.add((IAction)actionAdd);
                    manager.add((IAction)actionEdit);
                    manager.add((IAction)actionDelete);
                } else {
                    Action actionAdd = new Action(){

                        public void run() {
                            super.run();
                            ConnectionSettingsDialog.this.actionConfigAdd();
                        }
                    };
                    actionAdd.setText("Add");
                    manager.add((IAction)actionAdd);
                }
            }
        }
    };

    public ConnectionSettingsDialog(Shell parent, ConnectionSettingsObject settings) {
        super(parent, "Communication Settings", true, false);
        this.activateScrollSupport();
        this.setMaxSize(800, 600);
        this.settings = settings;
    }

    private boolean isAccessFor(int accessType) {
        return (this.settings.getAccessMode() & accessType) == accessType;
    }

    protected void createScrollGUIChildren(Composite main) {
        main.setLayout((Layout)new GridLayout(1, false));
        if (this.isAccessFor(32)) {
            this.compConfigs = new Composite(main, 0);
            this.compConfigs.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.compConfigs.setLayout((Layout)new GridLayout(1, false));
            this.lblHeaderConfigs = new Header(this.compConfigs, 0, "Port Configurations");
            this.lblHeaderConfigs.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
            this.lblHeaderConfigs.setSize(300);
            this.viewer = new CMultiTableViewer(this.compConfigs);
            this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            ((GridData)this.viewer.getTable().getLayoutData()).heightHint = 150;
            this.columnName = new TableViewerColumn((TableViewer)this.viewer, 0);
            this.columnName.getColumn().setText("Configuration Name");
            this.columnName.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell.getElement() instanceof ISerialPortConfiguration) {
                        cell.setText(((ISerialPortConfiguration)cell.getElement()).getConfigName());
                    }
                }
            });
            this.columnBaudrate = new TableViewerColumn((TableViewer)this.viewer, 0);
            this.columnBaudrate.getColumn().setText("Baudrate");
            this.columnBaudrate.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell.getElement() instanceof ISerialPortConfiguration) {
                        cell.setText(String.valueOf(Integer.toString(((ISerialPortConfiguration)cell.getElement()).getBaudRate())) + " Bit/s");
                    }
                }
            });
            this.columnDataBits = new TableViewerColumn((TableViewer)this.viewer, 0);
            this.columnDataBits.getColumn().setText("Data Bits");
            this.columnDataBits.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell.getElement() instanceof ISerialPortConfiguration) {
                        cell.setText(Integer.toString(((ISerialPortConfiguration)cell.getElement()).getDataBits()));
                    }
                }
            });
            this.columnStopBits = new TableViewerColumn((TableViewer)this.viewer, 0);
            this.columnStopBits.getColumn().setText("Stop Bits");
            this.columnStopBits.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell.getElement() instanceof ISerialPortConfiguration) {
                        cell.setText(Float.toString(((ISerialPortConfiguration)cell.getElement()).getStopBits()));
                    }
                }
            });
            this.columnParity = new TableViewerColumn((TableViewer)this.viewer, 0);
            this.columnParity.getColumn().setText("Parity");
            this.columnParity.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell.getElement() instanceof ISerialPortConfiguration) {
                        cell.setText(ASerialPortConfiguration.parityToName((int)((ISerialPortConfiguration)cell.getElement()).getParity()));
                    }
                }
            });
            this.viewer.getTable().addPropertyChangeListener("MouseDoubleClick", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ConnectionSettingsDialog.this.actionConfigEdit();
                }
            });
            this.viewer.getTable().addPropertyChangeListener("Enter", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ConnectionSettingsDialog.this.actionConfigEdit();
                }
            });
            this.viewer.getTable().addPropertyChangeListener("Delete", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ConnectionSettingsDialog.this.actionConfigDelete();
                }
            });
            this.viewer.getTable().createMenu(this.configMenuListener);
            this.viewer.setInput(this.settings.getConfigurationList());
            this.resizeConfigColumns();
            this.viewer.createColumnSortSupport(this.columnName.getColumn());
        }
        if (this.isAccessFor(256)) {
            this.compHWSettings = new Composite(main, 0);
            this.compHWSettings.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.compHWSettings.setLayout((Layout)new GridLayout(2, false));
            this.lblHeaderHWSettings = new Header(this.compHWSettings, 0, "Hardware Settings");
            this.lblHeaderHWSettings.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
            this.lblHeaderHWSettings.setSize(300);
            this.lblLoopBack = new Label(this.compHWSettings, 0);
            this.lblLoopBack.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this.lblLoopBack.setText("Hardware Loopback:");
            this.btnLoopBack = new Button(this.compHWSettings, 32);
            this.btnLoopBack.setLayoutData((Object)new GridData(0, 128, false, false, 1, 1));
            this.btnLoopBack.setSelection(this.settings.isLoopBack());
            this.btnLoopBack.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionSettingsDialog.this.settings.setLoopBack(ConnectionSettingsDialog.this.btnLoopBack.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.lblCorrectTiming = new Label(this.compHWSettings, 0);
            this.lblCorrectTiming.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this.lblCorrectTiming.setText("Transmission Time Correction:");
            this.btnCorrectTiming = new Button(this.compHWSettings, 32);
            this.btnCorrectTiming.setLayoutData((Object)new GridData(0, 128, false, false, 1, 1));
            this.btnCorrectTiming.setSelection(this.settings.isTransmitTimeCorrection());
            this.btnCorrectTiming.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionSettingsDialog.this.settings.setTransmitTimeCorrection(ConnectionSettingsDialog.this.btnCorrectTiming.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.isAccessFor(512)) {
            this.compDebugSettings = new Composite(main, 0);
            this.compDebugSettings.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.compDebugSettings.setLayout((Layout)new GridLayout(2, false));
            this.lblHeaderDebugSettings = new Header(this.compDebugSettings, 0, "Debug Settings");
            this.lblHeaderDebugSettings.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
            this.lblHeaderDebugSettings.setSize(300);
            this.lblFrameOutput = new Label(this.compDebugSettings, 0);
            this.lblFrameOutput.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this.lblFrameOutput.setText("Frame Output:");
            this.btnFrameOutput = new Button(this.compDebugSettings, 32);
            this.btnFrameOutput.setLayoutData((Object)new GridData(0, 128, false, false, 1, 1));
            this.btnFrameOutput.setSelection(this.settings.isFrameOutput());
            this.btnFrameOutput.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionSettingsDialog.this.settings.setFrameOutput(ConnectionSettingsDialog.this.btnFrameOutput.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void resizeConfigColumns() {
        if (this.isAccessFor(32)) {
            this.columnName.getColumn().pack();
            this.columnBaudrate.getColumn().pack();
            this.columnDataBits.getColumn().pack();
            this.columnStopBits.getColumn().pack();
            this.columnParity.getColumn().pack();
        }
    }

    public ISerialPortConfiguration getCurrentSelection() {
        int index;
        if (this.viewer != null && !this.viewer.getTable().isDisposed() && (index = this.viewer.getTable().getSelectionIndex()) >= 0 && index < this.settings.getConfigurationList().size()) {
            ISerialPortConfiguration item = (ISerialPortConfiguration)this.viewer.getTable().getItem(index).getData();
            return item;
        }
        return null;
    }

    public List<ISerialPortConfiguration> getCurrentSelections() {
        if (this.viewer != null && !this.viewer.getTable().isDisposed()) {
            int[] index = this.viewer.getTable().getSelectionIndices();
            ArrayList<ISerialPortConfiguration> curSelections = new ArrayList<ISerialPortConfiguration>(index.length);
            int[] nArray = index;
            int n = index.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (i >= 0 && i < this.settings.getConfigurationList().size()) {
                    curSelections.add((ISerialPortConfiguration)this.viewer.getTable().getItem(i).getData());
                }
                ++n2;
            }
            return curSelections;
        }
        return null;
    }

    private void actionConfigAdd() {
        boolean isChange = false;
        ISerialPortConfiguration newConfig = this.openPortConfigurationDialog(null);
        if (newConfig != null && !this.isConfigurationAlreadyRegistered(newConfig)) {
            isChange = true;
            this.settings.getConfigurationList().add(newConfig);
        }
        if (isChange) {
            this.viewer.refresh();
            this.resizeConfigColumns();
        }
    }

    private void actionConfigDelete() {
        boolean isChange = false;
        List<ISerialPortConfiguration> selectionList = this.getCurrentSelections();
        for (ISerialPortConfiguration selection : selectionList) {
            isChange = true;
            this.settings.getConfigurationList().remove(selection);
        }
        if (isChange) {
            this.viewer.refresh();
            this.resizeConfigColumns();
        }
    }

    private void actionConfigEdit() {
        ISerialPortConfiguration newConfig;
        boolean isChange = false;
        ISerialPortConfiguration selection = this.getCurrentSelection();
        if (selection != null && (newConfig = this.openPortConfigurationDialog(selection)) != null) {
            isChange = true;
            this.settings.getConfigurationList().remove(selection);
            if (!this.isConfigurationAlreadyRegistered(newConfig)) {
                this.settings.getConfigurationList().add(newConfig);
            }
        }
        if (isChange) {
            this.viewer.refresh();
            this.resizeConfigColumns();
        }
    }

    private boolean isConfigurationAlreadyRegistered(ISerialPortConfiguration newConfig) {
        for (ISerialPortConfiguration config : this.settings.getConfigurationList()) {
            if (!ASerialPortConfiguration.isSettingEqual((ISerialPortConfiguration)config, (ISerialPortConfiguration)newConfig)) continue;
            return true;
        }
        return false;
    }

    private ISerialPortConfiguration openPortConfigurationDialog(ISerialPortConfiguration selection) {
        PortConfigurationDialog settingsDialog = new PortConfigurationDialog(this.getShell(), selection);
        settingsDialog.open();
        if (settingsDialog.getSelection() == 0) {
            return settingsDialog.getActiveConfiguration();
        }
        return null;
    }

    protected int createGUIChildren(Composite main) {
        this.btnOK = new Button(main, 8);
        this.btnOK.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnOK.setText("Apply");
        this.btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionSettingsDialog.this.selection = 0;
                ConnectionSettingsDialog.this.closeHandler();
            }
        });
        this.btnCancel = new Button(main, 8);
        this.btnCancel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionSettingsDialog.this.closeHandler();
            }
        });
        this.btnOK.setFocus();
        return 2;
    }

    protected void onEnter() {
        this.selection = 0;
        this.closeHandler();
    }

    private void closeHandler() {
        this.close();
    }

    public int getSelection() {
        return this.selection;
    }
}

