/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.ui.swt.serialport;

import com.schott.let2.hw.serialport.ASerialPortConfiguration;
import com.schott.let2.hw.serialport.ISerialPort;
import com.schott.let2.hw.serialport.ISerialPortConfiguration;
import com.schott.let2.hw.serialport.portmanager.IExtendedPortManager;
import com.schott.let2.ui.swt.controls.basic.PropertyComp;
import com.schott.let2.ui.swt.serialport.internal.ConnectionSettingsDialog;
import com.schott.let2.ui.swt.serialport.internal.ConnectionSettingsObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ConnectionSelectorGUI
extends PropertyComp {
    public static final String PROP_PORT_STATE = "ISerialPortStateUpdate";
    public static final int STATE_UNDEFINED = 0;
    public static final int STATE_OPEN = 100;
    public static final int ACCESS_PORTS = 0;
    public static final int ACCESS_CONFIGS = 16;
    public static final int ACCESS_CONFIG_SETTINGS = 32;
    public static final int ACCESS_HW_SETTINGS = 256;
    public static final int ACCESS_DEBUG_SETTINGS = 512;
    public static final int ACCESS_FULL = 816;
    private static final String BTN_CONNECT_INACTIVE = "Connect";
    private static final String BTN_CONNECT_ACTIVE = "Disconnect";
    private Combo comConfig = null;
    private Combo comPort = null;
    private Button btnConnect = null;
    private Button btnScan = null;
    private Button btnConfig = null;
    private IExtendedPortManager portManager;
    private ISerialPort curSerialPort;
    private Object owner;
    private int curPortState;
    private int accessMode;
    private ArrayList<ISerialPortConfiguration> configurationList = new ArrayList();
    private ISerialPortConfiguration curConfiguration;
    private boolean isLoopBack = false;
    private boolean isFrameOutput = false;
    private boolean isTransmitTimeCorrection = false;
    private SelectionListener listenerComConfig = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ISerialPortConfiguration newConfig;
            if (ConnectionSelectorGUI.this.isPortConfigActive() && ConnectionSelectorGUI.this.comConfig.getSelectionIndex() != -1 && (newConfig = (ISerialPortConfiguration)ConnectionSelectorGUI.this.configurationList.get(ConnectionSelectorGUI.this.comConfig.getSelectionIndex())) != ConnectionSelectorGUI.this.curConfiguration) {
                ConnectionSelectorGUI.this.curConfiguration = newConfig;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private SelectionListener listenerComPort = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ISerialPort newPort;
            if (ConnectionSelectorGUI.this.comPort.getSelectionIndex() != -1 && ConnectionSelectorGUI.this.portManager != null && (newPort = ConnectionSelectorGUI.this.portManager.getPort(ConnectionSelectorGUI.this.comPort.getItem(ConnectionSelectorGUI.this.comPort.getSelectionIndex()))) != null && newPort != ConnectionSelectorGUI.this.curSerialPort) {
                ConnectionSelectorGUI.this.curSerialPort = newPort;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private SelectionListener listenerBtnConnect = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            int nextState;
            boolean isConnect = ConnectionSelectorGUI.this.btnConnect.getSelection();
            if (isConnect) {
                if (ConnectionSelectorGUI.this.connectPort(true)) {
                    nextState = 100;
                    ConnectionSelectorGUI.this.btnConnect.setText(ConnectionSelectorGUI.BTN_CONNECT_ACTIVE);
                    ConnectionSelectorGUI.this.btnConnect.setSelection(true);
                } else {
                    nextState = 0;
                    ConnectionSelectorGUI.this.btnConnect.setText(ConnectionSelectorGUI.BTN_CONNECT_INACTIVE);
                    ConnectionSelectorGUI.this.btnConnect.setSelection(false);
                }
            } else if (ConnectionSelectorGUI.this.connectPort(false)) {
                nextState = 0;
                ConnectionSelectorGUI.this.btnConnect.setText(ConnectionSelectorGUI.BTN_CONNECT_INACTIVE);
                ConnectionSelectorGUI.this.btnConnect.setSelection(false);
            } else {
                nextState = 100;
                ConnectionSelectorGUI.this.btnConnect.setText(ConnectionSelectorGUI.BTN_CONNECT_ACTIVE);
                ConnectionSelectorGUI.this.btnConnect.setSelection(true);
            }
            if (ConnectionSelectorGUI.this.curPortState != nextState) {
                ConnectionSelectorGUI.this.curPortState = nextState;
                ConnectionSelectorGUI.this.updateGUI(nextState);
                ConnectionSelectorGUI.this.firePropertyChange(ConnectionSelectorGUI.PROP_PORT_STATE, null, nextState);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private SelectionListener listenerBtnScan = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ConnectionSelectorGUI.this.rescan();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private SelectionListener listenerBtnConfig = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ConnectionSelectorGUI.this.openConnectionSettings();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private static final String CONFIG_SEP = "!";
    private static final String PREF_CONFIGS = "ConfigList";
    private static final String PREF_CONFIG = "LastConfig";
    private static final String PREF_PORT = "LastPort";
    private static final String PREF_LOOPBACK = "isLoopBack";
    private static final String PREF_FRAMEOUTPUT = "isFrameOutput";
    private static final String PREF_TXTIMECORRECTION = "isTransmitTimeCorrection";

    public ConnectionSelectorGUI(Object owner, Composite parent, int style) {
        super(parent, style);
        this.accessMode = 0;
        this.owner = owner;
        this.curPortState = 0;
        this.createGUI();
    }

    public ConnectionSelectorGUI(Object owner, Composite parent, int style, int accessMode) {
        super(parent, style);
        this.accessMode = accessMode;
        this.owner = owner;
        this.curPortState = 0;
        this.createGUI();
    }

    private boolean isAccessFor(int accessType) {
        return (this.accessMode & accessType) == accessType;
    }

    private boolean isPortConfigActive() {
        return this.isAccessFor(16);
    }

    private boolean isConfigButtonActive() {
        return this.isAccessFor(32) || this.isAccessFor(256) || this.isAccessFor(512);
    }

    private void createGUI() {
        int columns = 3;
        if (this.isPortConfigActive()) {
            ++columns;
        }
        if (this.isConfigButtonActive()) {
            ++columns;
        }
        this.setLayout((Layout)new GridLayout(columns, false));
        if (this.isPortConfigActive()) {
            this.comConfig = new Combo((Composite)this, 8);
            this.comConfig.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            ((GridData)this.comConfig.getLayoutData()).minimumWidth = 50;
            ((GridData)this.comConfig.getLayoutData()).widthHint = 200;
            this.comConfig.addSelectionListener(this.listenerComConfig);
        }
        this.comPort = new Combo((Composite)this, 8);
        this.comPort.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ((GridData)this.comPort.getLayoutData()).minimumWidth = 50;
        ((GridData)this.comPort.getLayoutData()).widthHint = 200;
        this.comPort.addSelectionListener(this.listenerComPort);
        this.btnConnect = new Button((Composite)this, 2);
        this.btnConnect.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnConnect.addSelectionListener(this.listenerBtnConnect);
        this.btnConnect.setText(BTN_CONNECT_ACTIVE);
        this.btnConnect.pack();
        ((GridData)this.btnConnect.getLayoutData()).minimumWidth = this.btnConnect.getSize().x;
        ((GridData)this.btnConnect.getLayoutData()).widthHint = this.btnConnect.getSize().x;
        this.btnConnect.setText(BTN_CONNECT_INACTIVE);
        this.btnScan = new Button((Composite)this, 8);
        this.btnScan.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnScan.setText("Rescan");
        this.btnScan.addSelectionListener(this.listenerBtnScan);
        if (this.isConfigButtonActive()) {
            this.btnConfig = new Button((Composite)this, 8);
            this.btnConfig.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            this.btnConfig.setText("Settings");
            this.btnConfig.addSelectionListener(this.listenerBtnConfig);
        }
    }

    public void dispose() {
        if (this.curPortState == 100) {
            this.connectPort(false);
        }
        this.curSerialPort = null;
        this.removeOwnListeners();
        super.dispose();
    }

    private void removeOwnListeners() {
        if (this.isPortConfigActive()) {
            this.comConfig.removeSelectionListener(this.listenerComConfig);
        }
        this.comPort.removeSelectionListener(this.listenerComPort);
        this.btnConnect.removeSelectionListener(this.listenerBtnConnect);
        this.btnScan.removeSelectionListener(this.listenerBtnScan);
        if (this.isConfigButtonActive()) {
            this.btnConfig.removeSelectionListener(this.listenerBtnConfig);
        }
    }

    public void resetToDisconnect() {
        int nextState = 0;
        this.btnConnect.setText(BTN_CONNECT_INACTIVE);
        this.btnConnect.setSelection(false);
        if (this.curPortState != nextState) {
            this.curPortState = nextState;
            this.updateGUI(nextState);
            this.firePropertyChange(PROP_PORT_STATE, null, nextState);
        }
    }

    public void openConnectionSettings() {
        ArrayList<ISerialPortConfiguration> configList = new ArrayList<ISerialPortConfiguration>(this.configurationList);
        ConnectionSettingsObject settings = new ConnectionSettingsObject(this.accessMode, configList, this.isLoopBack, this.isFrameOutput, this.isTransmitTimeCorrection);
        ConnectionSettingsDialog settingsDialog = new ConnectionSettingsDialog(this.getShell(), settings);
        settingsDialog.open();
        if (settingsDialog.getSelection() == 0) {
            this.isLoopBack = settings.isLoopBack();
            this.isFrameOutput = settings.isFrameOutput();
            this.isTransmitTimeCorrection = settings.isTransmitTimeCorrection();
            this.configurationList.clear();
            for (ISerialPortConfiguration config : configList) {
                this.configurationList.add(config);
            }
            this.refreshConfigurationList();
        }
    }

    public void initialize(IExtendedPortManager portManager) {
        this.portManager = portManager;
        this.refreshPortList();
    }

    private void rescan() {
        if (this.portManager == null) {
            return;
        }
        this.portManager.rescan();
        this.refreshPortList();
    }

    private void refreshPortList() {
        if (this.curPortState == 100) {
            return;
        }
        String lastPort = null;
        if (this.curSerialPort != null) {
            lastPort = this.curSerialPort.getAbsoluteDescriptiveName();
            this.curSerialPort = null;
        }
        this.comPort.removeAll();
        this.comPort.select(-1);
        if (this.portManager == null) {
            return;
        }
        List portNameList = this.portManager.getDescriptivePortNames();
        int idx = -1;
        int i = 0;
        while (i < portNameList.size()) {
            this.comPort.add((String)portNameList.get(i), i);
            if (lastPort != null && lastPort.equals(portNameList.get(i))) {
                idx = i;
            }
            ++i;
        }
        if (idx != -1) {
            this.comPort.select(idx);
        } else if (this.comPort.getItemCount() > 0) {
            this.comPort.select(0);
        }
        if (this.comPort.getSelectionIndex() != -1) {
            this.curSerialPort = this.portManager.getPort(this.comPort.getItem(this.comPort.getSelectionIndex()));
            this.btnConnect.setEnabled(true);
        } else {
            this.btnConnect.setEnabled(false);
        }
    }

    public ISerialPort getPort() {
        return this.curSerialPort;
    }

    public String getPortName() {
        return this.curSerialPort != null ? this.curSerialPort.getAbsoluteDescriptiveName() : "";
    }

    public boolean setPort(ISerialPort port) {
        if (port == null) {
            return false;
        }
        return this.setPort(port.getAbsoluteDescriptiveName());
    }

    public boolean setPort(String portName) {
        if (portName == null) {
            return false;
        }
        if (this.portManager == null) {
            return false;
        }
        ISerialPort port = this.portManager.getPort(portName);
        if (port == null) {
            return false;
        }
        if (this.curPortState == 100) {
            return false;
        }
        int idx = -1;
        int i = 0;
        while (i < this.comPort.getItemCount()) {
            if (this.comPort.getItem(i).equals(port.getAbsoluteDescriptiveName())) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx != -1) {
            this.curSerialPort = port;
            this.comPort.select(idx);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectPort(boolean isConnect) {
        boolean isOK = false;
        if (this.curSerialPort == null) {
            return isOK;
        }
        if (this.curConfiguration == null) {
            return isOK;
        }
        if (isConnect) {
            ISerialPort iSerialPort = this.curSerialPort;
            synchronized (iSerialPort) {
                if (this.curSerialPort.lock(this.owner)) {
                    if (this.curSerialPort.open(this.owner)) {
                        this.curSerialPort.setFrameOutput(this.isFrameOutput);
                        this.curSerialPort.setLoopBack(this.isLoopBack);
                        this.curSerialPort.setTransmitTimeCorrection(this.isTransmitTimeCorrection);
                        if (this.curSerialPort.applyConfiguration(this.owner, this.curConfiguration) && this.curSerialPort.reset(this.owner)) {
                            isOK = true;
                        }
                    }
                    if (this.curSerialPort.isLocked()) {
                        this.curSerialPort.unlock(this.owner);
                    }
                }
            }
        }
        ISerialPort iSerialPort = this.curSerialPort;
        synchronized (iSerialPort) {
            if (this.curSerialPort.lock(this.owner)) {
                if (this.curSerialPort.close(this.owner)) {
                    isOK = true;
                }
                if (this.curSerialPort.isLocked()) {
                    this.curSerialPort.unlock(this.owner);
                }
            }
        }
        return isOK;
    }

    private void updateGUI(int state) {
        switch (state) {
            case 100: {
                if (this.isPortConfigActive()) {
                    this.comConfig.setEnabled(false);
                }
                this.comPort.setEnabled(false);
                this.btnScan.setEnabled(false);
                if (!this.isConfigButtonActive()) break;
                this.btnConfig.setEnabled(false);
                break;
            }
            default: {
                if (this.isPortConfigActive()) {
                    this.comConfig.setEnabled(true);
                }
                this.comPort.setEnabled(true);
                this.btnScan.setEnabled(true);
                if (!this.isConfigButtonActive()) break;
                this.btnConfig.setEnabled(true);
            }
        }
    }

    private void refreshConfigurationList() {
        if (this.curPortState == 100) {
            return;
        }
        if (!this.isPortConfigActive()) {
            return;
        }
        String lastConfig = null;
        if (this.curConfiguration != null) {
            lastConfig = this.curConfiguration.getConfigName();
            this.curConfiguration = null;
        }
        this.comConfig.removeAll();
        this.comConfig.select(-1);
        Collections.sort(this.configurationList, ASerialPortConfiguration.SORTBY_BAUDRATE);
        int idx = -1;
        int i = 0;
        while (i < this.configurationList.size()) {
            ISerialPortConfiguration config = this.configurationList.get(i);
            this.comConfig.add(config.getConfigName(), i);
            if (lastConfig != null && lastConfig.equals(config.getConfigName())) {
                idx = i;
            }
            ++i;
        }
        if (idx != -1) {
            this.comConfig.select(idx);
        } else if (this.comConfig.getItemCount() > 0) {
            this.comConfig.select(0);
        }
        if (this.comConfig.getSelectionIndex() != -1) {
            this.curConfiguration = this.configurationList.get(this.comConfig.getSelectionIndex());
        }
        this.refreshPortList();
    }

    public ISerialPortConfiguration getPortConfiguration() {
        return this.curConfiguration;
    }

    public String getPortConfigurationName() {
        return this.curConfiguration != null ? this.curConfiguration.getConfigName() : "";
    }

    public boolean setPortConfiguration(ISerialPortConfiguration config) {
        if (config == null) {
            return false;
        }
        return this.setPortConfiguration(config.getConfigName());
    }

    public boolean setPortConfiguration(String portConfigName) {
        if (portConfigName == null) {
            return false;
        }
        if (this.curPortState == 100) {
            return false;
        }
        int idx = this.findInConfigurationList(portConfigName);
        if (idx >= 0) {
            this.curConfiguration = this.configurationList.get(idx);
            if (this.isPortConfigActive()) {
                this.comConfig.select(idx);
            }
        } else if (this.addConfiguration(portConfigName)) {
            this.setPortConfiguration(portConfigName);
        }
        return true;
    }

    private int findInConfigurationList(String configName) {
        int i = 0;
        while (i < this.configurationList.size()) {
            if (this.configurationList.get(i).getConfigName().equals(configName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean addConfiguration(ISerialPortConfiguration config) {
        if (config == null) {
            return false;
        }
        return this.addConfiguration(config.getConfigName());
    }

    public boolean addConfiguration(String configName) {
        if (configName == null) {
            return false;
        }
        int idx = this.findInConfigurationList(configName);
        if (idx == -1) {
            ISerialPortConfiguration config = ASerialPortConfiguration.createConfigurationFromName((String)configName);
            if (config == null) {
                return false;
            }
            this.configurationList.add(config);
            this.refreshConfigurationList();
        }
        return true;
    }

    public boolean deleteConfiguration(ISerialPortConfiguration config) {
        if (config == null) {
            return false;
        }
        return this.deleteConfiguration(config.getConfigName());
    }

    public boolean deleteConfiguration(String configName) {
        if (configName == null) {
            return false;
        }
        int idx = this.findInConfigurationList(configName);
        if (idx != -1) {
            this.configurationList.remove(idx);
            this.refreshConfigurationList();
        }
        return true;
    }

    public boolean loadSettings(IEclipsePreferences instancePrefNode, String idPrefix) {
        String configName;
        boolean isLoadSuccess = true;
        String configList = instancePrefNode.get(String.valueOf(idPrefix) + "-" + PREF_CONFIGS, null);
        this.configurationList.clear();
        if (configList != null) {
            String[] split;
            String[] stringArray = split = configList.split(CONFIG_SEP);
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.isEmpty()) {
                    boolean isOK = this.addConfiguration(s);
                    isLoadSuccess = isLoadSuccess ? isOK : isLoadSuccess;
                }
                ++n2;
            }
        }
        if ((configName = instancePrefNode.get(String.valueOf(idPrefix) + "-" + PREF_CONFIG, null)) != null && !configName.isEmpty()) {
            boolean isOK = this.setPortConfiguration(configName);
            isLoadSuccess = isLoadSuccess ? isOK : isLoadSuccess;
        } else {
            configName = "";
            isLoadSuccess = false;
        }
        String portName = instancePrefNode.get(String.valueOf(idPrefix) + "-" + PREF_PORT, null);
        if (portName != null && !portName.isEmpty()) {
            boolean isOK = this.setPort(portName);
            isLoadSuccess = isLoadSuccess ? isOK : isLoadSuccess;
        } else {
            isLoadSuccess = false;
        }
        this.isLoopBack = instancePrefNode.getBoolean(String.valueOf(idPrefix) + "-" + PREF_LOOPBACK, false);
        this.isFrameOutput = instancePrefNode.getBoolean(String.valueOf(idPrefix) + "-" + PREF_FRAMEOUTPUT, false);
        this.isTransmitTimeCorrection = instancePrefNode.getBoolean(String.valueOf(idPrefix) + "-" + PREF_TXTIMECORRECTION, false);
        return isLoadSuccess;
    }

    public void saveSettings(IEclipsePreferences instancePrefNode, String idPrefix) throws Exception {
        String configList = "";
        if (!this.configurationList.isEmpty()) {
            int i = 0;
            while (i < this.configurationList.size()) {
                configList = i < this.configurationList.size() - 1 ? String.valueOf(configList) + this.configurationList.get(i).getConfigName() + CONFIG_SEP : String.valueOf(configList) + this.configurationList.get(i).getConfigName();
                ++i;
            }
        }
        instancePrefNode.put(String.valueOf(idPrefix) + "-" + PREF_CONFIGS, configList);
        instancePrefNode.put(String.valueOf(idPrefix) + "-" + PREF_CONFIG, this.getPortConfiguration() != null ? this.getPortConfiguration().getConfigName() : "");
        instancePrefNode.put(String.valueOf(idPrefix) + "-" + PREF_PORT, this.getPort() != null ? this.getPort().getAbsoluteDescriptiveName() : "");
        instancePrefNode.putBoolean(String.valueOf(idPrefix) + "-" + PREF_LOOPBACK, this.isLoopBack);
        instancePrefNode.putBoolean(String.valueOf(idPrefix) + "-" + PREF_FRAMEOUTPUT, this.isFrameOutput);
        instancePrefNode.putBoolean(String.valueOf(idPrefix) + "-" + PREF_TXTIMECORRECTION, this.isTransmitTimeCorrection);
    }
}

