/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.hw.serialport.portmanager.standard;

import com.schott.let2.hw.serialport.ISerialPort;
import com.schott.let2.hw.serialport.ISerialPortProvider;
import com.schott.let2.hw.serialport.portmanager.IExtendedPortManager;
import com.schott.let2.util.debug.DebugSupport;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.ComponentContext;

public class PortManagerStandard
extends DebugSupport
implements IExtendedPortManager {
    public static final String DEBUG_IDENTIFIER = "Port Manager";
    private List<ISerialPortProvider> portProviderDictionary = new ArrayList<ISerialPortProvider>();

    protected void start(ComponentContext context) {
        PortManagerStandard.printDebugConsole((String)DEBUG_IDENTIFIER, (String)"Started!");
    }

    protected void stop(ComponentContext context) {
        PortManagerStandard.printDebugConsole((String)DEBUG_IDENTIFIER, (String)"Stopped!");
    }

    public void bindPortProvider(ISerialPortProvider serialPortProvider) {
        this.portProviderDictionary.add(serialPortProvider);
        PortManagerStandard.printDebugConsole((String)DEBUG_IDENTIFIER, (String)(String.valueOf(serialPortProvider.getDebuggingName()) + " registered!"));
    }

    public void unbindPortProvider(ISerialPortProvider serialPortProvider) {
        this.portProviderDictionary.remove(serialPortProvider);
        PortManagerStandard.printDebugConsole((String)DEBUG_IDENTIFIER, (String)(String.valueOf(serialPortProvider.getDebuggingName()) + " unregistered!"));
    }

    public List<ISerialPortProvider> getAvailablePortProviders() {
        return this.portProviderDictionary;
    }

    public List<String> getPortNames() {
        ArrayList<String> names = new ArrayList<String>(this.portProviderDictionary.size());
        for (ISerialPortProvider provider : this.portProviderDictionary) {
            for (ISerialPort serialPort : provider.getAvailablePorts()) {
                names.add(serialPort.getAbsoluteSymbolicName());
            }
        }
        return names;
    }

    public List<String> getDescriptivePortNames() {
        ArrayList<String> names = new ArrayList<String>(this.portProviderDictionary.size());
        for (ISerialPortProvider provider : this.portProviderDictionary) {
            for (ISerialPort serialPort : provider.getAvailablePorts()) {
                names.add(serialPort.getAbsoluteDescriptiveName());
            }
        }
        return names;
    }

    public ISerialPort getPort(String text) {
        if (text == null) {
            return null;
        }
        for (ISerialPortProvider provider : this.portProviderDictionary) {
            String provName = String.valueOf(provider.getSymbolicName()) + ":";
            if (!text.startsWith(provName)) continue;
            String portName = text.substring(provName.length());
            for (ISerialPort serialPort : provider.getAvailablePorts()) {
                if (portName.equals(serialPort.getDescriptiveName())) {
                    return serialPort;
                }
                if (!portName.equals(serialPort.getSymbolicName())) continue;
                return serialPort;
            }
        }
        return null;
    }

    public void rescan() {
        for (ISerialPortProvider provider : this.portProviderDictionary) {
            provider.rescan();
        }
    }
}

