/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.app.mcd.control.part;

import com.schott.let2.app.mcd.control.dialog.PasswordDialog;
import com.schott.let2.app.mcd.control.util.nls.Z_NLS;
import com.schott.let2.device.mcd.gui.MCDGUI;
import com.schott.let2.device.mcd.service.AMCDService;
import com.schott.let2.device.mcd.service.MCDService;
import com.schott.let2.file.log.ConsoleLogging;
import com.schott.let2.hw.serialport.ISerialPort;
import com.schott.let2.hw.serialport.portmanager.IExtendedPortManager;
import com.schott.let2.ui.swt.controls.dialog.BusyDialog;
import com.schott.let2.ui.swt.controls.dialog.DialogUtil;
import com.schott.let2.ui.swt.controls.dialog.nls.LanguageDialog;
import com.schott.let2.ui.swt.controls.util.GUIUtils;
import com.schott.let2.ui.swt.controls.util.ScreenUtil;
import com.schott.let2.ui.swt.controls.value.StatusLabel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class MainPart {
    public static final int GUI_STATE_EINIT = -1;
    public static final int GUI_STATE_INIT = 0;
    public static final int GUI_STATE_CONNECTING = 1;
    public static final int GUI_STATE_CONNECTED = 2;
    public static final int GUI_STATE_UPDATE = 3;
    private int guiState = -1;
    private IWorkbench workbench;
    private ScrolledComposite compScroll;
    private Composite comp;
    private Composite compConnection;
    private Button btnSearch;
    private StatusLabel lblConnect;
    private MCDGUI deviceGUI;
    private AMCDService service = new MCDService(false, true);
    private IExtendedPortManager portManager = null;
    private static final long BUSY_DELAY_MS = 500L;
    private BusyDialog busyThread = null;
    private String sBusyText;
    private List<Integer> supportedLanguageList = new ArrayList<Integer>();
    private boolean isInitialized = false;
    private IEclipsePreferences instancePrefNode;
    private static final String PREF_ID = MainPart.class.getName();
    private static final int SOFTWARE_MODE_DEFAULT = 0;
    private static final int SOFTWARE_MODE_PRODUCTION = 23130;
    private int iSoftwareMode = 0;

    @Inject
    public MainPart(Composite parent, IWorkbench workbench) {
        this.workbench = workbench;
        IPath plattformPath = Platform.getLocation();
        String rootPath = plattformPath.toFile().getAbsolutePath();
        File dirLogging = new File(String.valueOf(rootPath) + "\\LogFiles");
        ConsoleLogging.sRedirectSystemOut((File)dirLogging, (int)30, (boolean)true, (boolean)true);
        this.loadSettings();
        this.compScroll = new ScrolledComposite(parent, 768);
        this.comp = new Composite((Composite)this.compScroll, 0);
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.compConnection = new Composite(this.comp, 0);
        this.compConnection.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.compConnection.setLayout((Layout)new GridLayout(1, false));
        this.btnSearch = new Button(this.compConnection, 2);
        this.btnSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSearch.setText(Z_NLS.MainPart_btnSearch_Connect);
        this.btnSearch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainPart.this.connectFromGUI(MainPart.this.btnSearch.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblConnect = new StatusLabel(this.compConnection, 0, "");
        this.lblConnect.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_Connect, 3);
        this.deviceGUI = new MCDGUI(this.comp, 0, this.iSoftwareMode == 23130);
        this.deviceGUI.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.deviceGUI.addPropertyChangeListener("FWUpdate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof String && MainPart.this.service != null && MainPart.this.service.updateFirmware((String)evt.getNewValue())) {
                    MainPart.this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_Updating, 0);
                    MainPart.this.updateGUIState(3);
                }
            }
        });
        this.service.addPropertyChangeListener("DeviceSearch", new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                if (MainPart.this.comp != null && MainPart.this.comp.getDisplay() != null) {
                    MainPart.this.comp.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (evt.getNewValue() instanceof Boolean) {
                                if (((Boolean)evt.getNewValue()).booleanValue()) {
                                    MainPart.this.updateGUIState(2);
                                } else {
                                    MainPart.this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_noMCD, 2);
                                    MainPart.this.updateGUIState(0);
                                }
                            } else {
                                MainPart.this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_noMCD, 2);
                                MainPart.this.updateGUIState(0);
                            }
                            if (MainPart.this.busyThread != null) {
                                MainPart.this.busyThread.stopThread();
                                MainPart.this.busyThread = null;
                            }
                        }
                    });
                }
            }
        });
        this.service.addPropertyChangeListener("DeviceConnected", new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Boolean && MainPart.this.comp != null && MainPart.this.comp.getDisplay() != null) {
                    MainPart.this.comp.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!((Boolean)evt.getNewValue()).booleanValue()) {
                                MainPart.this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_Disconnected, 3);
                                MainPart.this.updateGUIState(0);
                            }
                        }
                    });
                }
            }
        });
        this.service.addPropertyChangeListener("RLStatus", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Boolean && MainPart.this.comp != null && MainPart.this.comp.getDisplay() != null) {
                    MainPart.this.comp.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (GUIUtils.isValid((Control)MainPart.this.deviceGUI)) {
                                MainPart.this.deviceGUI.updateRLInfo();
                                MainPart.this.deviceGUI.updateDynamicDeviceControls();
                            }
                        }
                    });
                }
            }
        });
        this.service.addPropertyChangeListener("FWUpdateStatus", new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Integer && MainPart.this.comp != null && MainPart.this.comp.getDisplay() != null) {
                    MainPart.this.comp.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            int iStatus = (Integer)evt.getNewValue();
                            MainPart.this.checkUpdateStatus(iStatus);
                            MainPart.this.connectFromGUI(false);
                            MainPart.this.connectFromGUI(true);
                        }
                    });
                }
            }
        });
        this.compScroll.setContent((Control)this.comp);
        Point pSize = this.comp.computeSize(-1, -1);
        this.compScroll.setMinSize(pSize.x, pSize.y);
        this.compScroll.setExpandHorizontal(true);
        this.compScroll.setExpandVertical(true);
    }

    private void connectFromGUI(boolean isConnect) {
        if (isConnect) {
            this.sBusyText = Z_NLS.MainPart_busy_Connecting;
            this.busyThread = new BusyDialog(ScreenUtil.getSafeMonitor((Control)this.comp), this.sBusyText, this.sBusyText, 500L);
            this.busyThread.start();
            this.updateGUIState(1);
            this.portManager.rescan();
            List portNameList = this.portManager.getPortNames();
            ArrayList<ISerialPort> portList = new ArrayList<ISerialPort>();
            for (String portName : portNameList) {
                ISerialPort port = this.portManager.getPort(portName);
                if (port == null) continue;
                portList.add(port);
            }
            boolean isSearchStarted = false;
            if (portList.isEmpty()) {
                this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_noPort, 2);
                this.updateGUIState(0);
            } else if (!this.service.searchDevices(portList)) {
                this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_noService, 2);
                this.updateGUIState(0);
            } else {
                isSearchStarted = true;
            }
            if (!isSearchStarted && this.busyThread != null) {
                this.busyThread.stopThread();
                this.busyThread = null;
            }
        } else {
            this.service.disconnect();
            this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_Disconnected, 3);
            this.updateGUIState(0);
        }
    }

    private void checkUpdateStatus(int iStatus) {
        boolean isFWOK;
        boolean bl = isFWOK = (iStatus & 0x400) == 1024;
        if (isFWOK) {
            iStatus -= 1024;
        }
        String sMsg = Z_NLS.MainPart_SWUpdate_NOK;
        int iMsgType = 1;
        switch (iStatus) {
            default: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_service;
                break;
            }
            case 1: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_file;
                break;
            }
            case 2: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_connection;
                break;
            }
            case 3: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_parse;
                break;
            }
            case 4: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_port;
                break;
            }
            case 5: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_blStart;
                break;
            }
            case 6: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_blConnection;
                break;
            }
            case 7: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_blActivation;
                break;
            }
            case 8: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_OptRead;
                break;
            }
            case 9: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_OptMod;
                break;
            }
            case 10: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_erase;
                break;
            }
            case 11: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_write;
                break;
            }
            case 12: {
                sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
                sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_OptWrite;
                break;
            }
            case 0: {
                sMsg = Z_NLS.MainPart_SWUpdate_OK;
                iMsgType = 0;
            }
        }
        if (!isFWOK) {
            sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
            sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
            sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_Corrupted_L1;
            sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
            sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_Corrupted_L2;
            sMsg = String.valueOf(sMsg) + GUIUtils.NEWLINE;
            sMsg = String.valueOf(sMsg) + Z_NLS.MainPart_SWUpdate_NOK_Corrupted_L3;
            iMsgType = 2;
        }
        switch (iMsgType) {
            case 0: {
                DialogUtil.showInfoDialog((Monitor)ScreenUtil.getSafeMonitor((Control)this.comp), (Shell)this.comp.getShell(), (String)sMsg);
                break;
            }
            case 1: {
                DialogUtil.showWarningDialog((Monitor)ScreenUtil.getSafeMonitor((Control)this.comp), (Shell)this.comp.getShell(), (String)sMsg);
                break;
            }
            default: {
                DialogUtil.showErrorDialog((Monitor)ScreenUtil.getSafeMonitor((Control)this.comp), (Shell)this.comp.getShell(), (String)sMsg);
            }
        }
    }

    public void updateGUIState(int state) {
        switch (state) {
            case -1: {
                if (GUIUtils.isValid((Control)this.btnSearch)) {
                    this.btnSearch.setEnabled(false);
                    this.btnSearch.setSelection(false);
                    this.btnSearch.setText(Z_NLS.MainPart_btnSearch_Connect);
                }
                if (!GUIUtils.isValid((Control)this.deviceGUI)) break;
                this.deviceGUI.setEnabled(false);
                this.deviceGUI.initDevice(null);
                break;
            }
            case 0: {
                if (GUIUtils.isValid((Control)this.btnSearch)) {
                    this.btnSearch.setEnabled(true);
                    this.btnSearch.setSelection(false);
                    this.btnSearch.setText(Z_NLS.MainPart_btnSearch_Connect);
                }
                if (!GUIUtils.isValid((Control)this.deviceGUI)) break;
                this.deviceGUI.setEnabled(false);
                this.deviceGUI.initDevice(null);
                break;
            }
            case 1: {
                if (GUIUtils.isValid((Control)this.btnSearch)) {
                    this.btnSearch.setEnabled(false);
                    this.btnSearch.setText(Z_NLS.MainPart_btnSearch_Connecting);
                }
                if (GUIUtils.isValid((Control)this.lblConnect)) {
                    this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_Connecting, 0);
                }
                if (!GUIUtils.isValid((Control)this.deviceGUI)) break;
                this.deviceGUI.setEnabled(false);
                this.deviceGUI.initDevice(null);
                break;
            }
            case 2: {
                if (GUIUtils.isValid((Control)this.btnSearch)) {
                    this.btnSearch.setEnabled(true);
                    this.btnSearch.setSelection(true);
                    this.btnSearch.setText(Z_NLS.MainPart_btnSearch_Disonnect);
                }
                if (GUIUtils.isValid((Control)this.lblConnect)) {
                    this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_Connected, 1);
                }
                if (!GUIUtils.isValid((Control)this.deviceGUI)) break;
                this.deviceGUI.setEnabled(true);
                this.deviceGUI.initDevice(this.service.getActiveDevice());
                break;
            }
            case 3: {
                if (GUIUtils.isValid((Control)this.btnSearch)) {
                    this.btnSearch.setEnabled(false);
                }
                if (!GUIUtils.isValid((Control)this.deviceGUI)) break;
                this.deviceGUI.setEnabled(false);
                break;
            }
        }
        this.guiState = state;
    }

    @Focus
    public void onFocus() {
        if (GUIUtils.isValid((Control)this.btnSearch)) {
            this.btnSearch.setFocus();
        }
    }

    public boolean handleSettingsLanguage() {
        if (this.guiState == 0 || this.guiState == -1) {
            LanguageDialog languageDialog = new LanguageDialog(this.comp.getShell());
            languageDialog.setSupportedLocales(this.supportedLanguageList);
            languageDialog.open();
            if (languageDialog.isRestart()) {
                this.restartWorkbench();
            }
        } else {
            DialogUtil.showErrorDialog((Monitor)ScreenUtil.getSafeMonitor((Control)this.comp), (Shell)this.comp.getShell(), (String)Z_NLS.MainPart_handleSettingsLanguage_NOK);
        }
        return false;
    }

    public boolean handleSoftwareMode() {
        block8: {
            block7: {
                if (this.guiState != 0 && this.guiState != -1) break block7;
                ArrayList<String> modeButtons = new ArrayList<String>();
                modeButtons.add(Z_NLS.MainPart_handleSoftwareMode_modeProd);
                modeButtons.add(Z_NLS.MainPart_handleSoftwareMode_modeUser);
                int selectedMode = DialogUtil.showInstructionDialogCustom((Monitor)ScreenUtil.getSafeMonitor((Control)this.comp), (Shell)this.comp.getShell(), modeButtons, (String)Z_NLS.MainPart_handleSoftwareMode_select);
                switch (selectedMode) {
                    case 0: {
                        if (this.iSoftwareMode != 23130) {
                            PasswordDialog pwdDialog = new PasswordDialog(this.comp.getShell());
                            pwdDialog.open();
                            if (pwdDialog.isAccepted()) {
                                this.iSoftwareMode = 23130;
                                this.restartWorkbench();
                                break;
                            }
                        }
                        break block8;
                    }
                    case 1: {
                        if (this.iSoftwareMode != 0) {
                            this.iSoftwareMode = 0;
                            this.restartWorkbench();
                            break;
                        }
                        break block8;
                    }
                }
                break block8;
            }
            DialogUtil.showErrorDialog((Monitor)ScreenUtil.getSafeMonitor((Control)this.comp), (Shell)this.comp.getShell(), (String)Z_NLS.MainPart_handleSoftwareMode_NOK);
        }
        return false;
    }

    @PostConstruct
    @Inject
    public void initialize(IExtendedPortManager epm) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.supportedLanguageList.add(1000);
            this.supportedLanguageList.add(2000);
            this.supportedLanguageList.add(3000);
            this.supportedLanguageList.add(4000);
            this.service.start();
            this.portManager = epm;
            boolean isInitOK = false;
            if (this.portManager == null) {
                this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_portManager, 2);
            } else if (this.portManager.getPortNames().isEmpty()) {
                this.lblConnect.setStatus(Z_NLS.MainPart_lblConnect_ports, 2);
            } else {
                isInitOK = true;
            }
            if (isInitOK) {
                this.updateGUIState(0);
            } else {
                this.updateGUIState(-1);
            }
        }
    }

    @PersistState
    public void persistState() {
        if (this.service != null) {
            this.service.stop();
        }
        if (GUIUtils.isValid((Control)this.deviceGUI)) {
            this.deviceGUI.dispose();
        }
        this.saveSettings();
    }

    public void restartWorkbench() {
        this.persistState();
        if (this.workbench != null) {
            this.workbench.restart();
        }
    }

    public void closeWorkbench() {
        this.persistState();
        if (this.workbench != null) {
            this.workbench.close();
        }
    }

    private void createPreferenceStore() {
        if (this.instancePrefNode == null) {
            this.instancePrefNode = InstanceScope.INSTANCE.getNode(PREF_ID);
        }
    }

    private boolean loadSettings() {
        block3: {
            try {
                this.createPreferenceStore();
                if (this.instancePrefNode != null) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.instancePrefNode.sync();
        this.iSoftwareMode = this.instancePrefNode.getInt("iSoftwareMode", this.iSoftwareMode);
        return true;
    }

    private boolean saveSettings() {
        block3: {
            try {
                this.createPreferenceStore();
                if (this.instancePrefNode != null) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.instancePrefNode.putInt("iSoftwareMode", this.iSoftwareMode);
        this.instancePrefNode.flush();
        return true;
    }
}

