/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.app.mcd.control.handler;

import java.util.List;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class HandlerUtil {
    public static final int PART_TYPE_MAIN = 1000;
    private static HandlerUtil INSTANCE = null;
    private MApplication app = null;
    private EModelService modelService = null;
    private EPartService partService = null;

    public HandlerUtil(MApplication app, EModelService modelService, EPartService partService) {
        this.app = app;
        this.modelService = modelService;
        this.partService = partService;
    }

    public static final boolean createInstance(MApplication app, EModelService modelService, EPartService partService) {
        if (INSTANCE != null) {
            return false;
        }
        if (app == null || modelService == null || partService == null) {
            return false;
        }
        INSTANCE = new HandlerUtil(app, modelService, partService);
        return true;
    }

    public static final HandlerUtil getInstance() {
        return INSTANCE;
    }

    private static final String getPartStackID(int partType) {
        switch (partType) {
            case 1000: {
                return "com.schott.let2.app.mcd.control.partstack.main";
            }
        }
        return null;
    }

    private static final String getPartID(int partType) {
        switch (partType) {
            case 1000: {
                return "com.schott.let2.app.mcd.control.partdescriptor.main";
            }
        }
        return null;
    }

    private MPart getActiveInstance(int partType) {
        MPartStack myPartStack = (MPartStack)this.modelService.find(HandlerUtil.getPartStackID(partType), (MUIElement)this.app);
        if (myPartStack != null) {
            List stackList = myPartStack.getChildren();
            for (MStackElement stack : stackList) {
                MPart mPart;
                if (!(stack instanceof MPart) || (mPart = (MPart)stack) == null || !mPart.getElementId().matches(HandlerUtil.getPartID(partType))) continue;
                return mPart;
            }
        }
        return null;
    }

    public boolean open(int partType) {
        Object part = null;
        MPart myPart = null;
        myPart = this.getActiveInstance(partType);
        if (myPart != null) {
            part = myPart.getObject();
            if (part != null) {
                return true;
            }
            try {
                this.partService.showPart(myPart, EPartService.PartState.ACTIVATE);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            myPart = this.partService.createPart(HandlerUtil.getPartID(partType));
        }
        catch (Exception exception) {
            return false;
        }
        myPart.setContext(EclipseContextFactory.create());
        MPartStack myPartStack = (MPartStack)this.modelService.find(HandlerUtil.getPartStackID(partType), (MUIElement)this.app);
        myPartStack.getChildren().add(myPart);
        try {
            this.partService.showPart(myPart, EPartService.PartState.ACTIVATE);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object getInstance(int partType) {
        Object part = null;
        MPart myPart = null;
        myPart = this.getActiveInstance(partType);
        if (myPart != null) {
            part = myPart.getObject();
        }
        return part;
    }
}

