/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.time;

import com.schott.let2.util.debug.DebugSupport;

public class TimeTracker {
    public static boolean IS_DEBUG = true;
    protected static final String DEBUG_IDENTIFIER = "Time Tracker";
    private static TimeTracker INSTANCE = null;
    private long totalTime = 0L;
    private long stepTime = 0L;

    public static void debug(String msg) {
        if (IS_DEBUG) {
            DebugSupport.printDebugConsole((String)DEBUG_IDENTIFIER, (String)msg);
        }
    }

    public static TimeTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TimeTracker();
        }
        return INSTANCE;
    }

    public void restartTracking() {
        this.stepTime = this.totalTime = System.currentTimeMillis();
    }

    public long trackTotalTime() {
        return System.currentTimeMillis() - this.totalTime;
    }

    public long trackStepTime() {
        long curTime = System.currentTimeMillis();
        long time = curTime - this.stepTime;
        this.stepTime = curTime;
        return time;
    }

    public void printTotalTime() {
        this.printTotalTime(null);
    }

    public void printTotalTime(String trackPoint) {
        TimeTracker.debug("Total Time > " + TimeTracker.getInstance().trackTotalTime() + " ms" + (trackPoint != null ? " (" + trackPoint + ")" : ""));
    }

    public void printStepTime() {
        this.printStepTime(null);
    }

    public void printStepTime(String trackPoint) {
        TimeTracker.debug("Step Time > " + TimeTracker.getInstance().trackStepTime() + " ms" + (trackPoint != null ? " (" + trackPoint + ")" : ""));
    }
}

