/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.util;

import java.io.File;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    private static final String F1 = "/";
    private static final String F2 = "*";
    private static final String F3 = "?";
    private static final String F4 = "|";
    private static final String F5 = "\"";
    private static final String F6 = "<";
    private static final String F7 = ">";
    private static final String F8 = ":";
    private static final String F9 = "!";
    private static final String F10 = "\\";
    private static final String F11 = "\\\\";
    private static final String RP = "";

    public static String getInvalidCharacters() {
        return "/ * ? | \" < > : !";
    }

    public static boolean checkPath(String path) {
        if (path != null) {
            if (path.contains(F1) || path.contains(F2) || path.contains(F3) || path.contains(F4) || path.contains(F5) || path.contains(F6) || path.contains(F7) || path.contains(F9)) {
                return false;
            }
            if (path.length() >= 2) {
                return !path.substring(2, path.length()).contains(F8);
            }
            return true;
        }
        return false;
    }

    public static String correctPath(String path) {
        if (path != null) {
            String ret = path.replace(F1, RP).replace(F2, RP).replace(F3, RP).replace(F4, RP).replace(F5, RP).replace(F6, RP).replace(F7, RP).replace(F9, RP);
            if (ret.contains(F8)) {
                ret = ret.replace(F8, RP);
                return String.valueOf(ret.substring(0, 1)) + F8 + ret.substring(1, ret.length());
            }
            return ret;
        }
        return path;
    }

    public static String escapePathBackslash(String path) {
        if (path != null) {
            return path.replace(F11, F10);
        }
        return path;
    }

    public static boolean isDirectoryExisting(String dirPath) {
        File fDir = null;
        try {
            fDir = new File(dirPath);
            if (fDir.exists() && fDir.isDirectory()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteDirectory(String dirPath, boolean isDeleteAll) {
        if (!FileUtil.isDirectoryExisting(dirPath)) {
            return true;
        }
        File fDir = null;
        try {
            fDir = new File(dirPath);
            if (!fDir.exists()) return false;
            if (!fDir.isDirectory()) return false;
            if (!isDeleteAll) return fDir.delete();
            File[] fileArray = fDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return fDir.delete();
                }
                File fDirFiles = fileArray[n2];
                if (fDirFiles.isDirectory() ? !FileUtil.deleteDirectory(fDirFiles.getAbsolutePath(), isDeleteAll) : !fDirFiles.delete()) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteDirectoryContent(String dirPath) {
        if (!FileUtil.isDirectoryExisting(dirPath)) {
            return true;
        }
        File fDir = null;
        try {
            fDir = new File(dirPath);
            if (!fDir.exists() || !fDir.isDirectory()) return false;
            File[] fileArray = fDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                File fDirFiles = fileArray[n2];
                if (fDirFiles.isDirectory() ? !FileUtil.deleteDirectory(fDirFiles.getAbsolutePath(), true) : !fDirFiles.delete()) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean createDirectory(String dirPath) {
        File fDir;
        block4: {
            fDir = null;
            fDir = new File(dirPath);
            if (!fDir.exists()) break block4;
            if (fDir.isDirectory()) {
                return true;
            }
        }
        try {
            return fDir.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getFileExtension(String fileName) {
        String sExt = null;
        try {
            int idx = fileName.lastIndexOf(".");
            sExt = fileName.substring(idx, fileName.length());
            return sExt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return sExt;
        }
    }

    public static boolean isFileExisting(String filePath) {
        File f = null;
        try {
            f = new File(filePath);
            if (f.exists() && f.isFile()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isFileDirectoryExisting(String filePath) {
        File f = null;
        File fDir = null;
        try {
            f = new File(filePath);
            fDir = new File(f.getParent());
            if (fDir.exists() && fDir.isDirectory()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean createFileDirectory(String filePath) {
        File fDir;
        block4: {
            File f = null;
            fDir = null;
            f = new File(filePath);
            fDir = new File(f.getParent());
            if (!fDir.exists()) break block4;
            if (fDir.isDirectory()) {
                return true;
            }
        }
        try {
            return fDir.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean deleteFile(String filePath) {
        if (!FileUtil.isFileExisting(filePath)) {
            return true;
        }
        File f = null;
        try {
            f = new File(filePath);
            if (f.exists() && f.isFile()) {
                return f.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean copyFile(String srcFilePath, String dstFilePath) {
        if (!FileUtil.isFileExisting(srcFilePath)) {
            return false;
        }
        if (FileUtil.createFileDirectory(dstFilePath)) {
            File fSrc = null;
            File fDst = null;
            try {
                fSrc = new File(srcFilePath);
                fDst = new File(dstFilePath);
                if (fSrc.exists()) {
                    FileUtils.copyFile((File)fSrc, (File)fDst, (boolean)true);
                    return fDst.exists();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

