/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.log;

import com.schott.let2.file.util.FileUtil;
import com.schott.let2.util.time.TimeUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;

public class ConsoleLogging
extends PrintStream {
    private static final String FILEEXT_LOGGING = "_log.txt";
    private PrintStream stdOut;
    private boolean isPrintStdOut;
    private boolean isPrintActive = false;

    public static boolean sRedirectSystemOut(File fLogDir, int logFileRetentionInDays, boolean isPrintStdOut, boolean isPrintStdErr) {
        if (fLogDir == null) {
            return false;
        }
        if (!FileUtil.createDirectory(fLogDir.getAbsolutePath())) {
            return false;
        }
        if (logFileRetentionInDays > 0) {
            File[] fileArray = fLogDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sDate;
                Date date;
                File f = fileArray[n2];
                if (f.isFile() && f.getName().endsWith(FILEEXT_LOGGING) && TimeUtil.isDateOlderThan((int)4, (int)logFileRetentionInDays, (Date)(date = TimeUtil.parseDateFileString((String)(sDate = f.getName().replace(FILEEXT_LOGGING, "")))))) {
                    f.delete();
                }
                ++n2;
            }
        }
        try {
            String sLogFile = String.valueOf(fLogDir.getAbsolutePath()) + "\\" + TimeUtil.getDateFileString((Date)new Date()) + FILEEXT_LOGGING;
            FileOutputStream sLogFileOut = new FileOutputStream(sLogFile);
            PrintStream stdOut = System.out;
            ConsoleLogging newOut = new ConsoleLogging(stdOut, isPrintStdOut, sLogFileOut);
            System.setOut(newOut);
            PrintStream stdErr = System.err;
            ConsoleLogging newErr = new ConsoleLogging(stdErr, isPrintStdErr, sLogFileOut);
            System.setErr(newErr);
            System.out.println("Redirected System.out to : '" + sLogFile + "'");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private ConsoleLogging(PrintStream stdOut, boolean isStdOut, OutputStream out) {
        super(out);
        this.init(stdOut, isStdOut);
    }

    private void init(PrintStream stdOut, boolean isStdOut) {
        this.stdOut = stdOut;
        this.isPrintStdOut = isStdOut && stdOut != null;
    }

    @Override
    public void print(boolean b) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(b);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(b);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void print(char c) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(c);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(c);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void print(char[] s) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(s);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(s);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void print(double d) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(d);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(d);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void print(float f) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(f);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(f);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void print(int i) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(i);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(i);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void print(long l) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(l);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(l);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void print(Object obj) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(obj);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(obj);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void print(String s) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.print(s);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.print(s);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println() {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println();
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println();
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(boolean b) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(b);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(b);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(char c) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(c);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(c);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(char[] s) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(s);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(s);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(double d) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(d);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(d);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(float f) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(f);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(f);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(int i) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(i);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(i);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(long l) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(l);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(l);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(Object obj) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(obj);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(obj);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void println(String s) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.println(s);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.println(s);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void write(int b) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.write(b);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.write(b);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        boolean isMethodPrintActive = false;
        if (this.isPrintStdOut && !this.isPrintActive) {
            this.stdOut.write(buf, off, len);
            isMethodPrintActive = this.isPrintActive = true;
        }
        super.write(buf, off, len);
        if (isMethodPrintActive) {
            this.isPrintActive = false;
        }
    }
}

