/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class FileDialog {
    private org.eclipse.swt.widgets.FileDialog dialog = null;
    private String[] curFilterExt = null;
    private String curFileDir = null;
    private List<String> curFileNames = new ArrayList<String>();

    public FileDialog(Shell parent, int style, String text, String[] filterExt) {
        this.initialize1stLevel(parent, style, text, filterExt);
        this.initialize2ndLevel(null, null);
    }

    public FileDialog(Shell parent, int style, String text, String[] filterExt, String fileDir) {
        this.initialize1stLevel(parent, style, text, filterExt);
        this.initialize2ndLevel(fileDir, null);
    }

    public FileDialog(Shell parent, int style, String text, String[] filterExt, String fileDir, String fileName) {
        this.initialize1stLevel(parent, style, text, filterExt);
        this.initialize2ndLevel(fileDir, fileName);
    }

    public FileDialog(Shell parent, int style, String text, String[] filterExt, File file) {
        this.initialize1stLevel(parent, style, text, filterExt);
        String sFileDir = null;
        String sFileName = null;
        if (file != null) {
            sFileName = file.getName();
            File fileDir = file.getParentFile();
            if (fileDir != null) {
                sFileDir = fileDir.getAbsolutePath();
            }
        }
        this.initialize2ndLevel(sFileDir, sFileName);
    }

    public FileDialog(Shell parent, int style, String text, String[] filterExt, String[] files) {
        this.initialize1stLevel(parent, style, text, filterExt);
        this.initialize2ndLevel(files);
    }

    private void initialize1stLevel(Shell parent, int style, String text, String[] filterExt) {
        this.dialog = new org.eclipse.swt.widgets.FileDialog(parent, style | 2);
        this.dialog.setText(text);
        this.dialog.setFilterExtensions(filterExt);
        this.curFilterExt = filterExt;
    }

    private void initialize2ndLevel(String fileDir, String fileName) {
        this.dialog.setFilterPath(fileDir);
        this.curFileDir = fileDir;
        this.dialog.setFileName(fileName);
        if (fileName != null) {
            this.curFileNames.add(fileName);
        }
    }

    private void initialize2ndLevel(String[] files) {
        String fileDir = null;
        String[] fileNames = null;
        String fileNameString = null;
        if (files != null && files.length > 0) {
            fileNames = new String[files.length];
            int idx = 0;
            while (idx < files.length) {
                File fFile = null;
                if (files[idx] != null && !files[idx].isEmpty()) {
                    fFile = new File(files[idx]);
                }
                if (fFile != null) {
                    fileNames[idx] = fFile.getName();
                    if (fileDir == null) {
                        fileDir = fFile.getParentFile().getAbsolutePath();
                    }
                }
                ++idx;
            }
        }
        this.dialog.setFilterPath(fileDir);
        this.curFileDir = fileDir;
        if (fileNames != null) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (fileName != null && !fileName.isEmpty()) {
                    this.curFileNames.add(fileName);
                }
                ++n2;
            }
            if (this.curFileNames.size() == 1) {
                fileNameString = this.curFileNames.get(0);
            }
        }
        this.dialog.setFileName(fileNameString);
    }

    public String open() {
        String sFileSelection = null;
        if (this.dialog != null) {
            this.curFileNames.clear();
            sFileSelection = this.dialog.open();
            if (sFileSelection != null) {
                String[] sFileNames;
                this.curFileDir = this.dialog.getFilterPath();
                String sFileExtension = null;
                if (this.curFilterExt != null && this.curFilterExt.length > this.dialog.getFilterIndex()) {
                    sFileExtension = this.curFilterExt[this.dialog.getFilterIndex()];
                }
                if ((sFileNames = this.dialog.getFileNames()) != null) {
                    String[] stringArray = sFileNames;
                    int n = sFileNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String sFileName = stringArray[n2];
                        if (sFileName != null && !sFileName.isEmpty()) {
                            this.curFileNames.add(this.checkFileExtension(sFileName, sFileExtension));
                        }
                        ++n2;
                    }
                }
                sFileSelection = this.checkFileExtension(sFileSelection, sFileExtension);
            }
        }
        return sFileSelection;
    }

    private String checkFileExtension(String sFileName, String sFileExtension) {
        if (sFileName == null) {
            return sFileName;
        }
        if (new File(sFileName).getName().indexOf(46) != -1) {
            return sFileName;
        }
        if (sFileExtension == null) {
            return sFileName;
        }
        if (sFileExtension.contains("*.*")) {
            return sFileName;
        }
        sFileName = String.valueOf(sFileName) + sFileExtension.replace("*", "");
        return sFileName;
    }

    public String getFileDirectory() {
        return this.curFileDir;
    }

    public List<String> getFileNames() {
        return this.curFileNames;
    }

    public String getFileName() {
        if (this.curFileNames.size() > 0) {
            return this.curFileNames.get(0);
        }
        return null;
    }

    public String[] getFiles() {
        String[] files = new String[this.curFileNames.size()];
        int idx = 0;
        while (idx < this.curFileNames.size()) {
            files[idx] = String.valueOf(this.curFileDir) + "\\" + this.curFileNames.get(idx);
            ++idx;
        }
        return files;
    }
}

