/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.csv;

import com.schott.let2.file.csv.CSVException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CSVParser {
    private String filePath = null;
    private static final String UTF8_BOM_WR = "\ufeff";
    private static final String UTF8_BOM_R = "?";
    private boolean isWriteUTF8_Preamble = true;

    public CSVParser(String filePath) {
        this.filePath = filePath;
    }

    public boolean isWriteUTF8_Preamble() {
        return this.isWriteUTF8_Preamble;
    }

    public void setWriteUTF8_Preamble(boolean isWriteUTF8_Preamble) {
        this.isWriteUTF8_Preamble = isWriteUTF8_Preamble;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public List<String[]> readFile() throws CSVException {
        ArrayList<String[]> readList;
        block7: {
            readList = new ArrayList<String[]>();
            if (this.filePath != null) {
                try {
                    FileReader file = new FileReader(this.filePath);
                    BufferedReader reader = new BufferedReader(file);
                    if (reader.ready()) {
                        String curLine = reader.readLine();
                        if (curLine != null && curLine.startsWith(UTF8_BOM_R)) {
                            curLine = curLine.substring(1);
                        }
                        while (curLine != null) {
                            readList.add(this.readLine(curLine));
                            curLine = reader.readLine();
                        }
                        reader.close();
                        break block7;
                    }
                    reader.close();
                    throw new CSVException("Stream is not ready!");
                }
                catch (FileNotFoundException e) {
                    throw new CSVException(e.getMessage());
                }
                catch (IOException e) {
                    throw new CSVException(e.getMessage());
                }
            }
            throw new CSVException("File name not available!");
        }
        return readList;
    }

    private String[] readLine(String curLine) {
        StringTokenizer st = new StringTokenizer(curLine, ";");
        String[] args = new String[st.countTokens()];
        int idx = 0;
        while (st.hasMoreTokens()) {
            args[idx] = st.nextToken();
            ++idx;
        }
        return args;
    }

    public void writeCsvFile(List<String[]> fileInput) throws CSVException {
        String[] args = null;
        String curLine = null;
        if (this.filePath != null) {
            this.filePath = this.filePath.replace(".csv", "");
            this.filePath = String.valueOf(this.filePath) + ".csv";
            boolean isFilePathOK = false;
            File f = null;
            try {
                f = new File(this.filePath);
                if (f.exists()) {
                    if (f.isFile()) {
                        isFilePathOK = true;
                    }
                } else if (f.isAbsolute() && (isFilePathOK = !f.getParentFile().exists() ? f.getParentFile().mkdirs() : f.getParentFile().isDirectory())) {
                    isFilePathOK = f.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isFilePathOK) {
                throw new CSVException("File cannot be found and cannot be created!");
            }
            try {
                FileWriter file = new FileWriter(this.filePath);
                BufferedWriter writer = new BufferedWriter(file);
                if (this.isWriteUTF8_Preamble) {
                    writer.write(UTF8_BOM_WR);
                }
                int i = 0;
                while (i < fileInput.size()) {
                    args = fileInput.get(i);
                    if (args.length > 0) {
                        curLine = String.valueOf(args[0]) + ";";
                    }
                    int j = 1;
                    while (j < args.length) {
                        curLine = j == args.length - 1 ? String.valueOf(curLine) + args[j] : String.valueOf(curLine) + args[j] + ";";
                        ++j;
                    }
                    writer.write(curLine);
                    if (i != fileInput.size() - 1) {
                        writer.newLine();
                    }
                    ++i;
                }
                writer.close();
            }
            catch (FileNotFoundException e) {
                throw new CSVException(e.getMessage());
            }
            catch (IOException e) {
                throw new CSVException(e.getMessage());
            }
        }
        throw new CSVException("File name not available!");
    }

    public void appendCsvFile(List<String[]> fileInput) throws CSVException {
        String[] args = null;
        String curLine = null;
        if (this.filePath != null) {
            this.filePath = this.filePath.replace(".csv", "");
            this.filePath = String.valueOf(this.filePath) + ".csv";
            try {
                FileWriter file = new FileWriter(this.filePath, true);
                BufferedWriter writer = new BufferedWriter(file);
                writer.newLine();
                int i = 0;
                while (i < fileInput.size()) {
                    args = fileInput.get(i);
                    if (args.length > 0) {
                        curLine = String.valueOf(args[0]) + ";";
                    }
                    int j = 1;
                    while (j < args.length) {
                        curLine = j == args.length - 1 ? String.valueOf(curLine) + args[j] : String.valueOf(curLine) + args[j] + ";";
                        ++j;
                    }
                    writer.write(curLine);
                    if (i != fileInput.size() - 1) {
                        writer.newLine();
                    }
                    ++i;
                }
                writer.close();
            }
            catch (FileNotFoundException e) {
                throw new CSVException(e.getMessage());
            }
            catch (IOException e) {
                throw new CSVException(e.getMessage());
            }
        } else {
            throw new CSVException("File name not available!");
        }
    }
}

