/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.data.unit;

import com.schott.let2.util.time.TimeUtil;

public abstract class AUnitType {
    public static final int UNITTYPE_UNKNOWN = -1;
    public static final int UNITTYPE_NONE = 0;
    public static final int UNITTYPE_PIECE = 100;
    public static final int UNITTYPE_PERC = 200;
    public static final int UNITTYPE_PIXEL = 300;
    public static final int UNITTYPE_TIME_fs = 1000;
    public static final int UNITTYPE_TIME_ps = 1001;
    public static final int UNITTYPE_TIME_ns = 1002;
    public static final int UNITTYPE_TIME_us = 1003;
    public static final int UNITTYPE_TIME_ms = 1004;
    public static final int UNITTYPE_TIME_s = 1005;
    public static final int UNITTYPE_TIME_MIN = 1006;
    public static final int UNITTYPE_TIME_HOUR = 1007;
    public static final int UNITTYPE_TIME_DAY = 1008;
    public static final int UNITTYPE_TIME_MONTH = 1009;
    public static final int UNITTYPE_TIME_WEEK = 1010;
    public static final int UNITTYPE_TIME_YEAR = 1011;
    public static final int UNITTYPE_TIME_DATE = 1100;
    public static final int UNITTYPE_TEMP_K = 2000;
    public static final int UNITTYPE_TEMP_degC = 2001;
    public static final int UNITTYPE_TEMP_degF = 2002;
    public static final int UNITTYPE_ANGLE_deg = 2100;
    public static final int UNITTYPE_LENGTH_nm = 3000;
    public static final int UNITTYPE_LENGTH_um = 3001;
    public static final int UNITTYPE_LENGTH_mm = 3002;
    public static final int UNITTYPE_LENGTH_cm = 3003;
    public static final int UNITTYPE_LENGTH_m = 3004;
    public static final int UNITTYPE_LENGTH_km = 3005;
    public static final int UNITTYPE_LENGTH_nm2 = 3100;
    public static final int UNITTYPE_LENGTH_um2 = 3101;
    public static final int UNITTYPE_LENGTH_mm2 = 3102;
    public static final int UNITTYPE_LENGTH_cm2 = 3103;
    public static final int UNITTYPE_LENGTH_m2 = 3104;
    public static final int UNITTYPE_LENGTH_km2 = 3105;
    public static final int UNITTYPE_POWER_nW = 4000;
    public static final int UNITTYPE_POWER_uW = 4001;
    public static final int UNITTYPE_POWER_mW = 4002;
    public static final int UNITTYPE_POWER_W = 4003;
    public static final int UNITTYPE_POWER_kW = 4004;
    public static final int UNITTYPE_POWER_MW = 4005;
    public static final int UNITTYPE_POWER_UNITS = 4100;
    public static final int UNITTYPE_INTENSITY_mLx = 4202;
    public static final int UNITTYPE_INTENSITY_Lx = 4203;
    public static final int UNITTYPE_INTENSITY_kLx = 4204;
    public static final int UNITTYPE_VOLUME_nL = 5000;
    public static final int UNITTYPE_VOLUME_uL = 5001;
    public static final int UNITTYPE_VOLUME_mL = 5002;
    public static final int UNITTYPE_VOLUME_cL = 5003;
    public static final int UNITTYPE_VOLUME_L = 5004;
    public static final int UNITTYPE_VOLUME_hL = 5005;
    public static final int UNITTYPE_CURRENT_fA = 6000;
    public static final int UNITTYPE_CURRENT_pA = 6001;
    public static final int UNITTYPE_CURRENT_nA = 6002;
    public static final int UNITTYPE_CURRENT_uA = 6003;
    public static final int UNITTYPE_CURRENT_mA = 6004;
    public static final int UNITTYPE_CURRENT_A = 6005;
    public static final int UNITTYPE_CURRENT_kA = 6006;
    public static final int UNITTYPE_VOLTAGE_fV = 6100;
    public static final int UNITTYPE_VOLTAGE_pV = 6101;
    public static final int UNITTYPE_VOLTAGE_nV = 6102;
    public static final int UNITTYPE_VOLTAGE_uV = 6103;
    public static final int UNITTYPE_VOLTAGE_mV = 6104;
    public static final int UNITTYPE_VOLTAGE_V = 6105;
    public static final int UNITTYPE_VOLTAGE_kV = 6106;
    public static final int UNITTYPE_VOLTAGE_MV = 6107;
    public static final int UNITTYPE_RESISTANCE_fOhm = 6200;
    public static final int UNITTYPE_RESISTANCE_pOhm = 6201;
    public static final int UNITTYPE_RESISTANCE_nOhm = 6202;
    public static final int UNITTYPE_RESISTANCE_uOhm = 6203;
    public static final int UNITTYPE_RESISTANCE_mOhm = 6204;
    public static final int UNITTYPE_RESISTANCE_Ohm = 6205;
    public static final int UNITTYPE_RESISTANCE_kOhm = 6206;
    public static final int UNITTYPE_RESISTANCE_MOhm = 6207;
    public static final int UNITTYPE_CAPACITANCE_fF = 6300;
    public static final int UNITTYPE_CAPACITANCE_pF = 6301;
    public static final int UNITTYPE_CAPACITANCE_nF = 6302;
    public static final int UNITTYPE_CAPACITANCE_uF = 6303;
    public static final int UNITTYPE_CAPACITANCE_mF = 6304;
    public static final int UNITTYPE_CAPACITANCE_F = 6305;
    public static final int UNITTYPE_CAPACITANCE_kF = 6306;
    public static final int UNITTYPE_CAPACITANCE_MF = 6307;
    public static final int UNITTYPE_CONDUCTANCE_fS = 6400;
    public static final int UNITTYPE_CONDUCTANCE_pS = 6401;
    public static final int UNITTYPE_CONDUCTANCE_nS = 6402;
    public static final int UNITTYPE_CONDUCTANCE_uS = 6403;
    public static final int UNITTYPE_CONDUCTANCE_mS = 6404;
    public static final int UNITTYPE_CONDUCTANCE_S = 6405;
    public static final int UNITTYPE_CONDUCTANCE_kS = 6406;
    public static final int UNITTYPE_CONDUCTANCE_MS = 6407;
    public static final int UNITTYPE_POWER_mW_cm = 40023003;
    public static final int UNITTYPE_POWER_mW_UNITS = 40024100;
    public static final int UNITTYPE_SPEED_mm_s = 30021005;
    public static final int UNITTYPE_ACCEL_mm_s2 = 300210052;
    public static final int UNITTYPE_SPEED_deg_s = 21001005;
    public static final int UNITTYPE_ACCEL_deg_s2 = 210010052;

    public static String unitTypeToString(int unitType) {
        switch (unitType) {
            case 100: {
                return "pc.";
            }
            case 200: {
                return "%";
            }
            case 300: {
                return "px";
            }
            case 1000: {
                return "fs";
            }
            case 1001: {
                return "ps";
            }
            case 1002: {
                return "ns";
            }
            case 1003: {
                return "us";
            }
            case 1004: {
                return "ms";
            }
            case 1005: {
                return "s";
            }
            case 1006: {
                return "min";
            }
            case 1007: {
                return "h";
            }
            case 1008: {
                return "day";
            }
            case 1009: {
                return "month";
            }
            case 1010: {
                return "week";
            }
            case 1011: {
                return "year";
            }
            case 1100: {
                return "Date";
            }
            case 2000: {
                return "K";
            }
            case 2001: {
                return "\u00b0C";
            }
            case 2002: {
                return "\u00b0F";
            }
            case 2100: {
                return "\u00b0";
            }
            case 3000: {
                return "nm";
            }
            case 3001: {
                return "um";
            }
            case 3002: {
                return "mm";
            }
            case 3003: {
                return "cm";
            }
            case 3004: {
                return "m";
            }
            case 3005: {
                return "km";
            }
            case 3100: {
                return "nm\u00b2";
            }
            case 3101: {
                return "um\u00b2";
            }
            case 3102: {
                return "mm\u00b2";
            }
            case 3103: {
                return "cm\u00b2";
            }
            case 3104: {
                return "m\u00b2";
            }
            case 3105: {
                return "km\u00b2";
            }
            case 4000: {
                return "nW";
            }
            case 4001: {
                return "uW";
            }
            case 4002: {
                return "mW";
            }
            case 4003: {
                return "W";
            }
            case 4004: {
                return "kW";
            }
            case 4005: {
                return "MW";
            }
            case 4100: {
                return "uNits";
            }
            case 4202: {
                return "mLx";
            }
            case 4203: {
                return "Lx";
            }
            case 4204: {
                return "kLx";
            }
            case 5000: {
                return "nL";
            }
            case 5001: {
                return "uL";
            }
            case 5002: {
                return "mL";
            }
            case 5003: {
                return "cL";
            }
            case 5004: {
                return "L";
            }
            case 5005: {
                return "hL";
            }
            case 6000: {
                return "fA";
            }
            case 6001: {
                return "pA";
            }
            case 6002: {
                return "nA";
            }
            case 6003: {
                return "uA";
            }
            case 6004: {
                return "mA";
            }
            case 6005: {
                return "A";
            }
            case 6006: {
                return "kA";
            }
            case 6100: {
                return "fV";
            }
            case 6101: {
                return "pV";
            }
            case 6102: {
                return "nV";
            }
            case 6103: {
                return "uV";
            }
            case 6104: {
                return "mV";
            }
            case 6105: {
                return "V";
            }
            case 6106: {
                return "kV";
            }
            case 6107: {
                return "MV";
            }
            case 6200: {
                return "fOhm";
            }
            case 6201: {
                return "pOhm";
            }
            case 6202: {
                return "nOhm";
            }
            case 6203: {
                return "uOhm";
            }
            case 6204: {
                return "mOhm";
            }
            case 6205: {
                return "Ohm";
            }
            case 6206: {
                return "kOhm";
            }
            case 6207: {
                return "MOhm";
            }
            case 6300: {
                return "fF";
            }
            case 6301: {
                return "pF";
            }
            case 6302: {
                return "nF";
            }
            case 6303: {
                return "uF";
            }
            case 6304: {
                return "mF";
            }
            case 6305: {
                return "F";
            }
            case 6306: {
                return "kF";
            }
            case 6307: {
                return "MF";
            }
            case 6400: {
                return "fS";
            }
            case 6401: {
                return "pS";
            }
            case 6402: {
                return "nS";
            }
            case 6403: {
                return "uS";
            }
            case 6404: {
                return "mS";
            }
            case 6405: {
                return "S";
            }
            case 6406: {
                return "kS";
            }
            case 6407: {
                return "MS";
            }
            case 40023003: {
                return "mW/cm";
            }
            case 40024100: {
                return "mW/uNits";
            }
            case 30021005: {
                return "mm/s";
            }
            case 300210052: {
                return "mm/s\u00b2";
            }
            case 21001005: {
                return "\u00b0/s";
            }
            case 210010052: {
                return "\u00b0/s\u00b2";
            }
        }
        return "";
    }

    public static double convertTime(double inputTime, int srcUnit, int dstUnit) {
        switch (srcUnit) {
            case 1000: {
                switch (dstUnit) {
                    case 1000: {
                        return inputTime;
                    }
                    case 1001: {
                        return TimeUtil.PS_FROM_FS((double)inputTime);
                    }
                    case 1002: {
                        return TimeUtil.NS_FROM_FS((double)inputTime);
                    }
                    case 1003: {
                        return TimeUtil.US_FROM_FS((double)inputTime);
                    }
                    case 1004: {
                        return TimeUtil.MS_FROM_FS((double)inputTime);
                    }
                    case 1005: {
                        return TimeUtil.SEC_FROM_FS((double)inputTime);
                    }
                    case 1006: {
                        return TimeUtil.MIN_FROM_MS((double)TimeUtil.MS_FROM_FS((double)inputTime));
                    }
                    case 1007: {
                        return TimeUtil.H_FROM_MS((double)TimeUtil.MS_FROM_FS((double)inputTime));
                    }
                    case 1008: {
                        return TimeUtil.D_FROM_MS((double)TimeUtil.MS_FROM_FS((double)inputTime));
                    }
                }
                return inputTime;
            }
            case 1001: {
                switch (dstUnit) {
                    case 1000: {
                        return TimeUtil.PS_TO_FS((double)inputTime);
                    }
                    case 1001: {
                        return inputTime;
                    }
                    case 1002: {
                        return TimeUtil.NS_FROM_PS((double)inputTime);
                    }
                    case 1003: {
                        return TimeUtil.US_FROM_PS((double)inputTime);
                    }
                    case 1004: {
                        return TimeUtil.MS_FROM_PS((double)inputTime);
                    }
                    case 1005: {
                        return TimeUtil.SEC_FROM_PS((double)inputTime);
                    }
                    case 1006: {
                        return TimeUtil.MIN_FROM_MS((double)TimeUtil.MS_FROM_PS((double)inputTime));
                    }
                    case 1007: {
                        return TimeUtil.H_FROM_MS((double)TimeUtil.MS_FROM_PS((double)inputTime));
                    }
                    case 1008: {
                        return TimeUtil.D_FROM_MS((double)TimeUtil.MS_FROM_PS((double)inputTime));
                    }
                }
                return inputTime;
            }
            case 1002: {
                switch (dstUnit) {
                    case 1000: {
                        return TimeUtil.NS_TO_FS((double)inputTime);
                    }
                    case 1001: {
                        return TimeUtil.NS_TO_PS((double)inputTime);
                    }
                    case 1002: {
                        return inputTime;
                    }
                    case 1003: {
                        return TimeUtil.US_FROM_NS((double)inputTime);
                    }
                    case 1004: {
                        return TimeUtil.MS_FROM_NS((double)inputTime);
                    }
                    case 1005: {
                        return TimeUtil.SEC_FROM_NS((double)inputTime);
                    }
                    case 1006: {
                        return TimeUtil.MIN_FROM_MS((double)TimeUtil.MS_FROM_NS((double)inputTime));
                    }
                    case 1007: {
                        return TimeUtil.H_FROM_MS((double)TimeUtil.MS_FROM_NS((double)inputTime));
                    }
                    case 1008: {
                        return TimeUtil.D_FROM_MS((double)TimeUtil.MS_FROM_NS((double)inputTime));
                    }
                }
                return inputTime;
            }
            case 1003: {
                switch (dstUnit) {
                    case 1000: {
                        return TimeUtil.US_TO_FS((double)inputTime);
                    }
                    case 1001: {
                        return TimeUtil.US_TO_PS((double)inputTime);
                    }
                    case 1002: {
                        return TimeUtil.US_TO_NS((double)inputTime);
                    }
                    case 1003: {
                        return inputTime;
                    }
                    case 1004: {
                        return TimeUtil.MS_FROM_US((double)inputTime);
                    }
                    case 1005: {
                        return TimeUtil.SEC_FROM_US((double)inputTime);
                    }
                    case 1006: {
                        return TimeUtil.MIN_FROM_MS((double)TimeUtil.MS_FROM_US((double)inputTime));
                    }
                    case 1007: {
                        return TimeUtil.H_FROM_MS((double)TimeUtil.MS_FROM_US((double)inputTime));
                    }
                    case 1008: {
                        return TimeUtil.D_FROM_MS((double)TimeUtil.MS_FROM_US((double)inputTime));
                    }
                }
                return inputTime;
            }
            case 1004: {
                switch (dstUnit) {
                    case 1000: {
                        return TimeUtil.MS_TO_FS((double)inputTime);
                    }
                    case 1001: {
                        return TimeUtil.MS_TO_PS((double)inputTime);
                    }
                    case 1002: {
                        return TimeUtil.MS_TO_NS((double)inputTime);
                    }
                    case 1003: {
                        return TimeUtil.MS_TO_US((double)inputTime);
                    }
                    case 1004: {
                        return inputTime;
                    }
                    case 1005: {
                        return TimeUtil.SEC_FROM_MS((double)inputTime);
                    }
                    case 1006: {
                        return TimeUtil.MIN_FROM_MS((double)inputTime);
                    }
                    case 1007: {
                        return TimeUtil.H_FROM_MS((double)inputTime);
                    }
                    case 1008: {
                        return TimeUtil.D_FROM_MS((double)inputTime);
                    }
                }
                return inputTime;
            }
            case 1005: {
                switch (dstUnit) {
                    case 1000: {
                        return TimeUtil.SEC_TO_FS((double)inputTime);
                    }
                    case 1001: {
                        return TimeUtil.SEC_TO_PS((double)inputTime);
                    }
                    case 1002: {
                        return TimeUtil.SEC_TO_NS((double)inputTime);
                    }
                    case 1003: {
                        return TimeUtil.SEC_TO_US((double)inputTime);
                    }
                    case 1004: {
                        return TimeUtil.SEC_TO_MS((double)inputTime);
                    }
                    case 1005: {
                        return inputTime;
                    }
                    case 1006: {
                        return TimeUtil.MIN_FROM_SEC((double)inputTime);
                    }
                    case 1007: {
                        return TimeUtil.H_FROM_SEC((double)inputTime);
                    }
                    case 1008: {
                        return TimeUtil.D_FROM_SEC((double)inputTime);
                    }
                }
                return inputTime;
            }
            case 1006: {
                switch (dstUnit) {
                    case 1000: {
                        return TimeUtil.MIN_TO_MS((double)TimeUtil.MS_TO_FS((double)inputTime));
                    }
                    case 1001: {
                        return TimeUtil.MIN_TO_MS((double)TimeUtil.MS_TO_PS((double)inputTime));
                    }
                    case 1002: {
                        return TimeUtil.MIN_TO_MS((double)TimeUtil.MS_TO_NS((double)inputTime));
                    }
                    case 1003: {
                        return TimeUtil.MIN_TO_MS((double)TimeUtil.MS_TO_US((double)inputTime));
                    }
                    case 1004: {
                        return TimeUtil.MIN_TO_MS((double)inputTime);
                    }
                    case 1005: {
                        return TimeUtil.MIN_TO_SEC((double)inputTime);
                    }
                    case 1006: {
                        return inputTime;
                    }
                    case 1007: {
                        return TimeUtil.H_FROM_MIN((double)inputTime);
                    }
                    case 1008: {
                        return TimeUtil.D_FROM_MIN((double)inputTime);
                    }
                }
                return inputTime;
            }
            case 1007: {
                switch (dstUnit) {
                    case 1000: {
                        return TimeUtil.H_TO_MS((double)TimeUtil.MS_TO_FS((double)inputTime));
                    }
                    case 1001: {
                        return TimeUtil.H_TO_MS((double)TimeUtil.MS_TO_PS((double)inputTime));
                    }
                    case 1002: {
                        return TimeUtil.H_TO_MS((double)TimeUtil.MS_TO_NS((double)inputTime));
                    }
                    case 1003: {
                        return TimeUtil.H_TO_MS((double)TimeUtil.MS_TO_US((double)inputTime));
                    }
                    case 1004: {
                        return TimeUtil.H_TO_MS((double)inputTime);
                    }
                    case 1005: {
                        return TimeUtil.H_TO_SEC((double)inputTime);
                    }
                    case 1006: {
                        return TimeUtil.H_TO_MIN((double)inputTime);
                    }
                    case 1007: {
                        return inputTime;
                    }
                    case 1008: {
                        return TimeUtil.D_FROM_H((double)inputTime);
                    }
                }
                return inputTime;
            }
            case 1008: {
                switch (dstUnit) {
                    case 1000: {
                        return TimeUtil.D_TO_MS((double)TimeUtil.MS_TO_FS((double)inputTime));
                    }
                    case 1001: {
                        return TimeUtil.D_TO_MS((double)TimeUtil.MS_TO_PS((double)inputTime));
                    }
                    case 1002: {
                        return TimeUtil.D_TO_MS((double)TimeUtil.MS_TO_NS((double)inputTime));
                    }
                    case 1003: {
                        return TimeUtil.D_TO_MS((double)TimeUtil.MS_TO_US((double)inputTime));
                    }
                    case 1004: {
                        return TimeUtil.D_TO_MS((double)inputTime);
                    }
                    case 1005: {
                        return TimeUtil.D_TO_SEC((double)inputTime);
                    }
                    case 1006: {
                        return TimeUtil.D_TO_MIN((double)inputTime);
                    }
                    case 1007: {
                        return TimeUtil.D_TO_H((double)inputTime);
                    }
                    case 1008: {
                        return inputTime;
                    }
                }
                return inputTime;
            }
        }
        return inputTime;
    }
}

