/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.data.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TypeUtil {
    public static int TYPE_BYTE = 0;
    public static int TYPE_WORD = 1;
    public static int TYPE_DWORD = 2;
    private static final String P_ID_ASEPARATOR = "!";

    public static void disposeArrayList(List<?> arrayList) {
        if (arrayList != null) {
            for (Object obj : arrayList) {
                if (obj == null) continue;
                Object var1_2 = null;
            }
            arrayList.clear();
            arrayList = null;
        }
    }

    public static boolean[] boolArrayCopy(boolean[] inputArray) {
        if (inputArray == null) {
            return new boolean[0];
        }
        boolean[] outputArray = new boolean[inputArray.length];
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray[idx] = inputArray[idx];
            ++idx;
        }
        return outputArray;
    }

    public static boolean boolArrayCopy(boolean[] srcArray, boolean[] dstArray) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        return TypeUtil.boolArrayCopy(srcArray, 0, srcArray.length, dstArray, 0);
    }

    public static boolean boolArrayCopy(boolean[] srcArray, int srcIdx, int srcLength, boolean[] dstArray, int dstIdx) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        if (srcIdx < 0 || srcLength <= 0 || srcIdx + srcLength > srcArray.length) {
            return false;
        }
        if (dstIdx < 0 || dstIdx + srcLength > dstArray.length) {
            return false;
        }
        int idx = 0;
        while (idx < srcLength) {
            dstArray[dstIdx + idx] = srcArray[srcIdx + idx];
            ++idx;
        }
        return true;
    }

    public static boolean[] boolArrayListToArray(List<Boolean> inputArray) {
        if (inputArray == null) {
            return new boolean[0];
        }
        boolean[] outputArray = new boolean[inputArray.size()];
        int idx = 0;
        while (idx < inputArray.size()) {
            outputArray[idx] = inputArray.get(idx);
            ++idx;
        }
        return outputArray;
    }

    public static List<Boolean> boolArrayToArrayList(boolean[] inputArray) {
        if (inputArray == null) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> outputArray = new ArrayList<Boolean>(inputArray.length);
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray.add(inputArray[idx]);
            ++idx;
        }
        return outputArray;
    }

    public static int[] intArrayCopy(int[] inputArray) {
        if (inputArray == null) {
            return new int[0];
        }
        int[] outputArray = new int[inputArray.length];
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray[idx] = inputArray[idx];
            ++idx;
        }
        return outputArray;
    }

    public static boolean intArrayCopy(int[] srcArray, int[] dstArray) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        return TypeUtil.intArrayCopy(srcArray, 0, srcArray.length, dstArray, 0);
    }

    public static boolean intArrayCopy(int[] srcArray, int srcIdx, int srcLength, int[] dstArray, int dstIdx) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        if (srcIdx < 0 || srcLength <= 0 || srcIdx + srcLength > srcArray.length) {
            return false;
        }
        if (dstIdx < 0 || dstIdx + srcLength > dstArray.length) {
            return false;
        }
        int idx = 0;
        while (idx < srcLength) {
            dstArray[dstIdx + idx] = srcArray[srcIdx + idx];
            ++idx;
        }
        return true;
    }

    public static int[] intArrayListToArray(List<Integer> inputArray) {
        if (inputArray == null) {
            return new int[0];
        }
        int[] outputArray = new int[inputArray.size()];
        int idx = 0;
        while (idx < inputArray.size()) {
            outputArray[idx] = inputArray.get(idx);
            ++idx;
        }
        return outputArray;
    }

    public static List<Integer> intArrayToArrayList(int[] inputArray) {
        if (inputArray == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> outputArray = new ArrayList<Integer>(inputArray.length);
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray.add(inputArray[idx]);
            ++idx;
        }
        return outputArray;
    }

    public static long[] longArrayCopy(long[] inputArray) {
        if (inputArray == null) {
            return new long[0];
        }
        long[] outputArray = new long[inputArray.length];
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray[idx] = inputArray[idx];
            ++idx;
        }
        return outputArray;
    }

    public static boolean longArrayCopy(long[] srcArray, long[] dstArray) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        return TypeUtil.longArrayCopy(srcArray, 0, srcArray.length, dstArray, 0);
    }

    public static boolean longArrayCopy(long[] srcArray, int srcIdx, int srcLength, long[] dstArray, int dstIdx) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        if (srcIdx < 0 || srcLength <= 0 || srcIdx + srcLength > srcArray.length) {
            return false;
        }
        if (dstIdx < 0 || dstIdx + srcLength > dstArray.length) {
            return false;
        }
        int idx = 0;
        while (idx < srcLength) {
            dstArray[dstIdx + idx] = srcArray[srcIdx + idx];
            ++idx;
        }
        return true;
    }

    public static long[] longArrayListToArray(List<Long> inputArray) {
        if (inputArray == null) {
            return new long[0];
        }
        long[] outputArray = new long[inputArray.size()];
        int idx = 0;
        while (idx < inputArray.size()) {
            outputArray[idx] = inputArray.get(idx);
            ++idx;
        }
        return outputArray;
    }

    public static List<Long> longArrayToArrayList(long[] inputArray) {
        if (inputArray == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> outputArray = new ArrayList<Long>(inputArray.length);
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray.add(inputArray[idx]);
            ++idx;
        }
        return outputArray;
    }

    public static float[] floatArrayCopy(float[] inputArray) {
        if (inputArray == null) {
            return new float[0];
        }
        float[] outputArray = new float[inputArray.length];
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray[idx] = inputArray[idx];
            ++idx;
        }
        return outputArray;
    }

    public static boolean floatArrayCopy(float[] srcArray, float[] dstArray) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        return TypeUtil.floatArrayCopy(srcArray, 0, srcArray.length, dstArray, 0);
    }

    public static boolean floatArrayCopy(float[] srcArray, int srcIdx, int srcLength, float[] dstArray, int dstIdx) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        if (srcIdx < 0 || srcLength <= 0 || srcIdx + srcLength > srcArray.length) {
            return false;
        }
        if (dstIdx < 0 || dstIdx + srcLength > dstArray.length) {
            return false;
        }
        int idx = 0;
        while (idx < srcLength) {
            dstArray[dstIdx + idx] = srcArray[srcIdx + idx];
            ++idx;
        }
        return true;
    }

    public static float[] floatArrayListToArray(List<Float> inputArray) {
        if (inputArray == null) {
            return new float[0];
        }
        float[] outputArray = new float[inputArray.size()];
        int idx = 0;
        while (idx < inputArray.size()) {
            outputArray[idx] = inputArray.get(idx).floatValue();
            ++idx;
        }
        return outputArray;
    }

    public static List<Float> floatArrayToArrayList(float[] inputArray) {
        if (inputArray == null) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> outputArray = new ArrayList<Float>(inputArray.length);
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray.add(Float.valueOf(inputArray[idx]));
            ++idx;
        }
        return outputArray;
    }

    public static double[] doubleArrayCopy(double[] inputArray) {
        if (inputArray == null) {
            return new double[0];
        }
        double[] outputArray = new double[inputArray.length];
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray[idx] = inputArray[idx];
            ++idx;
        }
        return outputArray;
    }

    public static boolean doubleArrayCopy(double[] srcArray, double[] dstArray) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        return TypeUtil.doubleArrayCopy(srcArray, 0, srcArray.length, dstArray, 0);
    }

    public static boolean doubleArrayCopy(double[] srcArray, int srcIdx, int srcLength, double[] dstArray, int dstIdx) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        if (srcIdx < 0 || srcLength <= 0 || srcIdx + srcLength > srcArray.length) {
            return false;
        }
        if (dstIdx < 0 || dstIdx + srcLength > dstArray.length) {
            return false;
        }
        int idx = 0;
        while (idx < srcLength) {
            dstArray[dstIdx + idx] = srcArray[srcIdx + idx];
            ++idx;
        }
        return true;
    }

    public static double[] doubleArrayListToArray(List<Double> inputArray) {
        if (inputArray == null) {
            return new double[0];
        }
        double[] outputArray = new double[inputArray.size()];
        int idx = 0;
        while (idx < inputArray.size()) {
            outputArray[idx] = inputArray.get(idx);
            ++idx;
        }
        return outputArray;
    }

    public static List<Double> doubleArrayToArrayList(double[] inputArray) {
        if (inputArray == null) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> outputArray = new ArrayList<Double>(inputArray.length);
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray.add(inputArray[idx]);
            ++idx;
        }
        return outputArray;
    }

    public static String[] stringArrayCopy(String[] inputArray) {
        if (inputArray == null) {
            return new String[0];
        }
        String[] outputArray = new String[inputArray.length];
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray[idx] = inputArray[idx];
            ++idx;
        }
        return outputArray;
    }

    public static boolean stringArrayCopy(String[] srcArray, String[] dstArray) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        return TypeUtil.stringArrayCopy(srcArray, 0, srcArray.length, dstArray, 0);
    }

    public static boolean stringArrayCopy(String[] srcArray, int srcIdx, int srcLength, String[] dstArray, int dstIdx) {
        if (srcArray == null || dstArray == null) {
            return false;
        }
        if (srcIdx < 0 || srcLength <= 0 || srcIdx + srcLength > srcArray.length) {
            return false;
        }
        if (dstIdx < 0 || dstIdx + srcLength > dstArray.length) {
            return false;
        }
        int idx = 0;
        while (idx < srcLength) {
            dstArray[dstIdx + idx] = srcArray[srcIdx + idx];
            ++idx;
        }
        return true;
    }

    public static String[] stringArrayListToArray(List<String> inputArray) {
        if (inputArray == null) {
            return new String[0];
        }
        String[] outputArray = new String[inputArray.size()];
        int idx = 0;
        while (idx < inputArray.size()) {
            outputArray[idx] = inputArray.get(idx);
            ++idx;
        }
        return outputArray;
    }

    public static List<String> stringArrayToArrayList(String[] inputArray) {
        if (inputArray == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> outputArray = new ArrayList<String>(inputArray.length);
        int idx = 0;
        while (idx < inputArray.length) {
            outputArray.add(inputArray[idx]);
            ++idx;
        }
        return outputArray;
    }

    public static boolean intToBool(int input) {
        return input > 0;
    }

    public static int boolToInt(boolean input) {
        return input ? 1 : 0;
    }

    public static int[] invertIntArray(int[] input) {
        int[] invArray = new int[input.length];
        int idx = 0;
        while (idx < input.length) {
            invArray[input.length - 1 - idx] = input[idx];
            ++idx;
        }
        return invArray;
    }

    public static byte[] invertByteArray(byte[] input) {
        byte[] invArray = new byte[input.length];
        int idx = 0;
        while (idx < input.length) {
            invArray[input.length - 1 - idx] = input[idx];
            ++idx;
        }
        return invArray;
    }

    public static int[] intArrayToIntArray(int[] input, int start, int end) {
        int[] intArray = new int[]{};
        if (input.length > 0 && input.length >= end && input.length > start) {
            intArray = new int[end - start];
            int i = start;
            int idx = 0;
            while (i < end) {
                intArray[idx] = input[i];
                ++i;
                ++idx;
            }
        }
        return intArray;
    }

    public static byte[] arrayToWord(byte[] input, int startIndex) {
        byte[] word = new byte[]{input[startIndex], input[startIndex + 1]};
        return word;
    }

    public static int byteToInt(byte input) {
        int output = 0;
        output = input >= 0 && input <= 127 ? (int)input : 256 + input;
        return output;
    }

    public static boolean[] byteToBits(byte input) {
        int iInput = TypeUtil.byteToInt(input);
        boolean[] output = new boolean[8];
        int mask = 1;
        int idx = 0;
        while (idx < 8) {
            int shiftMask = mask << idx;
            output[idx] = (shiftMask & iInput) == shiftMask;
            ++idx;
        }
        return output;
    }

    public static byte intToByte(int input) {
        return (byte)input;
    }

    public static int intSignWordToInt(int[] input) {
        return (short)(input[0] + (input[1] << 8));
    }

    public static int[] intSignToIntSignWord(int input) {
        short value = (short)input;
        int[] word = new int[]{value & 0xFF, (value & 0xFF00) >>> 8};
        return word;
    }

    public static int intDWordToInt(int[] input) {
        return input[0] + (input[1] << 8) + (input[2] << 16) + (input[3] << 24);
    }

    public static int[] intToIntDWord(int input) {
        int[] dword = new int[]{input & 0xFF, (input & 0xFF00) >>> 8, (input & 0xFF0000) >>> 16, (input & 0xFF000000) >>> 24};
        return dword;
    }

    public static long intQWordToLong(int[] input) {
        return (long)input[0] + ((long)input[1] << 8) + ((long)input[2] << 16) + ((long)input[3] << 24) + ((long)input[4] << 32) + ((long)input[5] << 40) + ((long)input[6] << 48) + ((long)input[7] << 56);
    }

    public static int[] longToIntQWord(long input) {
        int[] dword = new int[]{(int)(input & 0xFFL), (int)((input & 0xFF00L) >>> 8), (int)((input & 0xFF0000L) >>> 16), (int)((input & 0xFF000000L) >>> 24), (int)((input & 0xFF00000000L) >>> 32), (int)((input & 0xFF0000000000L) >>> 40), (int)((input & 0xFF000000000000L) >>> 48), (int)((input & 0xFF00000000000000L) >>> 56)};
        return dword;
    }

    public static long intDWordToLong(int[] input) {
        return (long)input[0] + ((long)input[1] << 8) + ((long)input[2] << 16) + ((long)input[3] << 24);
    }

    public static int[] longToIntDWord(long input) {
        int[] dword = new int[]{(int)(input & 0xFFL), (int)((input & 0xFF00L) >>> 8), (int)((input & 0xFF0000L) >>> 16), (int)((input & 0xFF000000L) >>> 24)};
        return dword;
    }

    public static int wordToInt(byte[] input) {
        return TypeUtil.byteToInt(input[0]) + (TypeUtil.byteToInt(input[1]) << 8);
    }

    public static byte[] intToWord(int input) {
        byte[] word = new byte[]{(byte)(input & 0xFF), (byte)((input & 0xFF00) >>> 8)};
        return word;
    }

    public static int dwordToInt(byte[] input) {
        return TypeUtil.byteToInt(input[0]) + (TypeUtil.byteToInt(input[1]) << 8) + (TypeUtil.byteToInt(input[2]) << 16) + (TypeUtil.byteToInt(input[3]) << 24);
    }

    public static byte[] intToDWord(int input) {
        byte[] word = new byte[]{(byte)(input & 0xFF), (byte)((input & 0xFF00) >>> 8), (byte)((input & 0xFF0000) >>> 16), (byte)((input & 0xFF000000) >>> 24)};
        return word;
    }

    public static int intWordToInt(int[] input) {
        return input[0] + (input[1] << 8);
    }

    public static int[] intToIntWord(int input) {
        int[] word = new int[]{input & 0xFF, (input & 0xFF00) >>> 8};
        return word;
    }

    public static long intWordToLong(int[] input) {
        return (long)input[0] + ((long)input[1] << 8);
    }

    public static int[] longToIntWord(long input) {
        int[] word = new int[]{(int)(input & 0xFFL), (int)((input & 0xFF00L) >>> 8)};
        return word;
    }

    public static double intDoubleToDouble(int input) {
        return Float.intBitsToFloat(input);
    }

    public static int doubleToIntDouble(double input) {
        return Float.floatToIntBits((float)input);
    }

    public static double longDoubleToDouble(long input) {
        double output = Double.longBitsToDouble(input);
        if (Double.isNaN(output)) {
            output = 0.0;
        }
        return output;
    }

    public static long doubleToLongDouble(double input) {
        return Double.doubleToLongBits(input);
    }

    public static String byteToHexString(byte input) {
        return String.format("%02x", input);
    }

    public static String byteBufferToHexString(ByteBuffer input, int length) {
        return TypeUtil.byteBufferToHexString(input, length, false);
    }

    public static String byteBufferToHexString(ByteBuffer input, int length, boolean isInvert) {
        String s;
        block4: {
            s = "";
            input.compact();
            input.flip();
            if (input.limit() <= 0 || input.limit() < length) break block4;
            if (isInvert) {
                int i = length - 1;
                while (i >= 0) {
                    s = String.valueOf(s) + TypeUtil.byteToHexString(input.get(i));
                    --i;
                }
            } else {
                int i = 0;
                while (i < length) {
                    s = String.valueOf(s) + TypeUtil.byteToHexString(input.get(i));
                    ++i;
                }
            }
        }
        return s;
    }

    public static ByteBuffer hexStringToByteBuffer(String input, int length) {
        if (input == null) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer b = ByteBuffer.allocate(input.length() / 2);
        if (input.length() > 0 && input.length() >= length && length % 2 == 0) {
            int i = 0;
            while (i < length) {
                String sByte = input.substring(i, i + 2);
                b.put(TypeUtil.intToByte(Integer.parseInt(sByte, 16)));
                i += 2;
            }
        }
        b.flip();
        return b;
    }

    public static String byteBufferToIntString(ByteBuffer input, int start, int end) {
        String s = "";
        input.compact();
        input.flip();
        if (input.limit() > 0 && input.limit() >= end && input.limit() > start) {
            int i = start;
            while (i < end) {
                s = String.valueOf(s) + Integer.toString(TypeUtil.byteToInt(input.get(i)) & 0x7F);
                ++i;
            }
        }
        if (s.equals("")) {
            return null;
        }
        return s;
    }

    public static String byteBufferToASCIIString(ByteBuffer input, int start, int end) {
        String s = "";
        input.compact();
        input.flip();
        if (input.limit() > 0 && input.limit() >= end && input.limit() > start) {
            int i = start;
            while (i < end) {
                int iChar = TypeUtil.byteToInt(input.get(i)) & 0x7F;
                if (iChar > 0 && iChar < 127) {
                    s = String.valueOf(s) + (char)iChar;
                } else if (iChar == 0 || 127 == iChar) break;
                ++i;
            }
        }
        if (s.equals("")) {
            return null;
        }
        return s;
    }

    public static byte[] byteBufferToByteArray(ByteBuffer input, int start, int end) {
        byte[] output = new byte[end - start];
        input.compact();
        input.flip();
        if (input.limit() > 0 && input.limit() >= end && input.limit() > start) {
            int i = start;
            int idx = 0;
            while (i < end) {
                output[idx] = input.get(i);
                ++i;
                ++idx;
            }
        }
        return output;
    }

    public static String intArrayToHexString(int[] input, int start, int end) {
        String s = "";
        if (input.length > 0 && input.length >= end && input.length > start) {
            int i = start;
            while (i < end) {
                s = String.valueOf(s) + TypeUtil.intToHexString(input[i], TYPE_BYTE);
                ++i;
            }
        }
        if (s.equals("")) {
            return null;
        }
        return s;
    }

    public static String intArrayToASCIIString(int[] input, int start, int end) {
        String s = "";
        if (input.length > 0 && input.length >= end && input.length > start) {
            int i = start;
            while (i < end) {
                s = String.valueOf(s) + (char)input[i];
                ++i;
            }
        }
        if (s.equals("")) {
            return null;
        }
        return s;
    }

    public static int[] asciiStringToIntArray(String s) {
        if (s == null) {
            return new int[0];
        }
        if (s.isEmpty()) {
            return new int[0];
        }
        byte[] sb = s.getBytes();
        int[] output = new int[sb.length];
        int i = 0;
        while (i < sb.length) {
            output[i] = TypeUtil.byteToInt(sb[i]);
            ++i;
        }
        return output;
    }

    public static String byteToBinaryString(byte input) {
        return String.format("%8s", Integer.toBinaryString(input & 0xFF)).replace(' ', '0');
    }

    public static double intToDouble7B(int input, int type) {
        if (type == TYPE_WORD) {
            return (double)input / 16384.0;
        }
        if (type == TYPE_BYTE) {
            return (double)input / 128.0;
        }
        return 0.0;
    }

    public static int doubleToInt7B(double input, int type) {
        if (type == TYPE_WORD) {
            return (int)(input * 16383.0);
        }
        if (type == TYPE_BYTE) {
            return (int)(input * 127.0);
        }
        return 0;
    }

    public static String intToHexString(int input, int type) {
        if (type == TYPE_WORD) {
            return String.format("%04x", input);
        }
        if (type == TYPE_DWORD) {
            return String.format("%08x", input);
        }
        if (type == TYPE_BYTE) {
            return String.format("%02x", input);
        }
        return "";
    }

    public static String longToHexString(long input, int type) {
        if (type == TYPE_WORD) {
            return String.format("%04x", input);
        }
        if (type == TYPE_DWORD) {
            return String.format("%08x", input);
        }
        if (type == TYPE_BYTE) {
            return String.format("%02x", input);
        }
        return "";
    }

    public static String intToBinaryString(int input, int type) {
        if (type == TYPE_WORD) {
            return String.format("%16s", Integer.toBinaryString(input & 0xFFFF)).replace(' ', '0');
        }
        if (type == TYPE_DWORD) {
            return String.format("%32s", Integer.toBinaryString(input & 0xFFFFFFFF)).replace(' ', '0');
        }
        if (type == TYPE_BYTE) {
            return String.format("%8s", Integer.toBinaryString(input & 0xFF)).replace(' ', '0');
        }
        return "";
    }

    public static String convertIntToDezHexString(int number, int type) {
        return String.valueOf(Integer.toString(number)) + " / 0x" + TypeUtil.intToHexString(number, type);
    }

    public static String convertLongToDezHexString(long number, int type) {
        return String.valueOf(Long.toString(number)) + " / 0x" + TypeUtil.longToHexString(number, type);
    }

    public static ByteBuffer copyBytebuffer(ByteBuffer input) {
        if (input == null) {
            return null;
        }
        input.compact();
        input.flip();
        ByteBuffer output = ByteBuffer.allocate(input.limit());
        int i = 0;
        while (i < input.limit()) {
            output.put(input.get(i));
            ++i;
        }
        output.flip();
        return output;
    }

    public static ByteBuffer concatBytebuffers(ByteBuffer input1, ByteBuffer input2) {
        if (input1 == null || input2 == null) {
            return null;
        }
        input1.compact();
        input1.flip();
        input2.compact();
        input2.flip();
        ByteBuffer output = ByteBuffer.allocate(input1.limit() + input2.limit());
        int i = 0;
        while (i < input1.limit()) {
            output.put(input1.get(i));
            ++i;
        }
        i = 0;
        while (i < input2.limit()) {
            output.put(input2.get(i));
            ++i;
        }
        output.flip();
        return output;
    }

    public static boolean compareIntArrays(int[] i1, int[] i2) {
        if (i1 == null) {
            return i2 == null;
        }
        if (i2 == null) {
            return false;
        }
        if (i1.length != i2.length) {
            return false;
        }
        int i = 0;
        while (i < i1.length) {
            if (i1[i] != i2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] intArrayToByteArray(int[] input) {
        return TypeUtil.intArrayToByteArray(input, 0, input.length);
    }

    public static byte[] intArrayToByteArray(int[] input, int start, int end) {
        if (input == null) {
            return null;
        }
        byte[] output = new byte[end - start];
        if (input.length > 0 && input.length >= end && input.length > start) {
            int i = start;
            int idx = 0;
            while (i < end) {
                output[idx] = TypeUtil.intToByte(input[i]);
                ++i;
                ++idx;
            }
        }
        return output;
    }

    public static int[] byteArrayToIntArray(byte[] input) {
        if (input == null) {
            return null;
        }
        int[] output = new int[input.length];
        int i = 0;
        while (i < output.length) {
            output[i] = TypeUtil.byteToInt(input[i]);
            ++i;
        }
        return output;
    }

    public static double[] intArrayToDoubleArray(int[] input) {
        if (input == null) {
            return null;
        }
        double[] output = new double[input.length];
        int i = 0;
        while (i < output.length) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static double[] boolArrayToDoubleArray(boolean[] input) {
        if (input == null) {
            return null;
        }
        double[] output = new double[input.length];
        int i = 0;
        while (i < output.length) {
            output[i] = input[i] ? 1.0 : 0.0;
            ++i;
        }
        return output;
    }

    public static double[] copyDoubleArray(double[] input) {
        if (input == null) {
            return null;
        }
        double[] output = new double[input.length];
        int i = 0;
        while (i < output.length) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static double[] doubleArrayToDoubleArray(double[] input, int start, int end) {
        double[] doubleArray = new double[]{};
        if (input.length > 0 && input.length >= end && input.length > start) {
            doubleArray = new double[end - start];
            int i = start;
            int idx = 0;
            while (i < end) {
                doubleArray[idx] = input[i];
                ++i;
                ++idx;
            }
        }
        return doubleArray;
    }

    public static boolean compareDoubleArrays(double[] d1, double[] d2) {
        if (d1 == null) {
            return d2 == null;
        }
        if (d2 == null) {
            return false;
        }
        if (d1.length != d2.length) {
            return false;
        }
        int i = 0;
        while (i < d1.length) {
            if (d1[i] != d2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void convertStringToByteBuffer(ByteBuffer output, String input) {
        output.clear();
        byte[] data = input.getBytes();
        try {
            int i = 0;
            while (i < data.length) {
                output.put(data[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        output.flip();
    }

    public static String convertByteBufferToString(ByteBuffer input) {
        String output = "";
        if (input == null) {
            return output;
        }
        byte[] data = new byte[input.limit()];
        int i = 0;
        while (i < input.limit()) {
            data[i] = input.get(i);
            ++i;
        }
        output = new String(data);
        return output;
    }

    public static void convertHexStringToByteBuffer(ByteBuffer output, String input) {
        output.clear();
        try {
            int i = 0;
            while (i < input.length()) {
                String sByte = input.substring(i, i + 2);
                output.put(TypeUtil.intToByte(Integer.parseInt(sByte, 16)));
                i += 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        output.flip();
    }

    public static String convertByteBufferToHexString(ByteBuffer input) {
        String output = "";
        if (input == null) {
            return output;
        }
        try {
            int i = 0;
            while (i < input.limit()) {
                output = String.valueOf(output) + TypeUtil.byteToHexString(input.get(i));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public static boolean[] boolArrayFromString(String data) {
        try {
            String[] splitBA = data.split(P_ID_ASEPARATOR);
            boolean[] bA = new boolean[splitBA.length];
            int idx = 0;
            while (idx < splitBA.length) {
                bA[idx] = Boolean.parseBoolean(splitBA[idx]);
                ++idx;
            }
            return bA;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String boolArrayToString(boolean[] data) {
        String s = "";
        try {
            int idx = 0;
            while (idx < data.length) {
                s = String.valueOf(s) + Boolean.toString(data[idx]);
                if (idx < data.length - 1) {
                    s = String.valueOf(s) + P_ID_ASEPARATOR;
                }
                ++idx;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public static int[] intArrayFromString(String data) {
        try {
            String[] splitIA = data.split(P_ID_ASEPARATOR);
            int[] iA = new int[splitIA.length];
            int idx = 0;
            while (idx < splitIA.length) {
                iA[idx] = Integer.parseInt(splitIA[idx]);
                ++idx;
            }
            return iA;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String intArrayToString(int[] data) {
        String s = "";
        try {
            int idx = 0;
            while (idx < data.length) {
                s = String.valueOf(s) + Integer.toString(data[idx]);
                if (idx < data.length - 1) {
                    s = String.valueOf(s) + P_ID_ASEPARATOR;
                }
                ++idx;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }
}

