/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.nls.support;

import com.schott.let2.util.nls.service.NLS_Support;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public abstract class ExtendedNLS {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    static final Object ASSIGNED;
    private static List<PropertiesFile> propertiesFileList;

    static {
        ASSIGNED = new Object();
        propertiesFileList = new ArrayList<PropertiesFile>();
    }

    protected ExtendedNLS() {
    }

    public static void resetNL() {
        if (nlSuffixes != null) {
            nlSuffixes = null;
            NLS_Support.debug("NL Suffixes reset");
        }
    }

    public static String bind(String message, Object binding) {
        return ExtendedNLS.internalBind(message, null, String.valueOf(binding), null);
    }

    public static String bind(String message, Object binding1, Object binding2) {
        return ExtendedNLS.internalBind(message, null, String.valueOf(binding1), String.valueOf(binding2));
    }

    public static String bind(String message, Object[] bindings) {
        return ExtendedNLS.internalBind(message, bindings, null, null);
    }

    public static void initializeMessages(final String baseName, final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            ExtendedNLS.load(baseName, clazz);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ExtendedNLS.load(baseName, clazz);
                return null;
            }
        });
    }

    private static String internalBind(String message, Object[] args, String argZero, String argOne) {
        if (message == null) {
            return "No message available.";
        }
        if (args == null || args.length == 0) {
            args = EMPTY_ARGS;
        }
        int length = message.length();
        int bufLen = length + args.length * 5;
        if (argZero != null) {
            bufLen += argZero.length() - 3;
        }
        if (argOne != null) {
            bufLen += argOne.length() - 3;
        }
        StringBuffer buffer = new StringBuffer(bufLen < 0 ? 0 : bufLen);
        int i = 0;
        while (i < length) {
            char c = message.charAt(i);
            switch (c) {
                case '{': {
                    int index = message.indexOf(125, i);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    if (++i >= length) {
                        buffer.append(c);
                        break;
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(message.substring(i, index));
                    }
                    catch (NumberFormatException e) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
                    }
                    if (number == 0 && argZero != null) {
                        buffer.append(argZero);
                    } else if (number == 1 && argOne != null) {
                        buffer.append(argOne);
                    } else {
                        if (number >= args.length || number < 0) {
                            buffer.append("<missing argument>");
                            i = index;
                            break;
                        }
                        buffer.append(args[number]);
                    }
                    i = index;
                    break;
                }
                case '\'': {
                    int nextIndex = i + 1;
                    if (nextIndex >= length) {
                        buffer.append(c);
                        break;
                    }
                    char next = message.charAt(nextIndex);
                    if (next == '\'') {
                        ++i;
                        buffer.append(c);
                        break;
                    }
                    int index = message.indexOf(39, nextIndex);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    buffer.append(message.substring(nextIndex, index));
                    i = index;
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
            NLS_Support.debug("NL Suffixes initialized with...");
            int idx = 0;
            while (idx < nlSuffixes.length) {
                NLS_Support.debug("...'" + nlSuffixes[idx] + "'");
                ++idx;
            }
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    private static void computeMissingMessages(String bundleName, Class<?> clazz, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        int numFields = fieldArray.length;
        int i = 0;
        while (i < numFields) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 0x19) == 9 && fieldMap.get(field.getName()) != ASSIGNED) {
                try {
                    String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                    NLS_Support.debug(value);
                    if (!isAccessible) {
                        field.setAccessible(true);
                    }
                    field.set(null, value);
                }
                catch (Exception e) {
                    NLS_Support.debug("Error setting the missing message value for: " + field.getName() + " / " + e.getMessage());
                }
            }
            ++i;
        }
    }

    static void load(String bundleName, Class<?> clazz) {
        long start = System.currentTimeMillis();
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(len * 2);
        int i = 0;
        while (i < len) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
            ++i;
        }
        NLS_Support.debug("Loading '" + bundleName + "'...");
        String[] variants = ExtendedNLS.buildVariants(bundleName);
        int i2 = 0;
        while (i2 < variants.length) {
            block18: {
                InputStream input;
                InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(variants[i2]) : loader.getResourceAsStream(variants[i2]);
                if (input == null) {
                    NLS_Support.debug("...Error loading '" + variants[i2] + "'");
                } else {
                    try {
                        try {
                            MessagesProperties properties = new MessagesProperties(fields, bundleName, isAccessible);
                            properties.load(input);
                            NLS_Support.debug("...Loaded '" + variants[i2] + "'");
                        }
                        catch (IOException e) {
                            NLS_Support.debug("...Error loading '" + variants[i2] + "'" + " / " + e.getMessage());
                            e.printStackTrace();
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++i2;
        }
        ExtendedNLS.computeMissingMessages(bundleName, clazz, fields, fieldArray, isAccessible);
        NLS_Support.debug("Time to load message bundle: " + bundleName + " was " + (System.currentTimeMillis() - start) + "ms.");
    }

    public static String getMessageFor(String baseName, String fieldName, Class<?> clazz, String localeValue) {
        if (System.getSecurityManager() == null) {
            return ExtendedNLS.loadMessageFor(baseName, fieldName, clazz, localeValue);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    static String loadMessageFor(String bundleName, String fieldName, Class<?> clazz, String localeValue) {
        start = System.currentTimeMillis();
        NLS_Support.debug("Loading '" + fieldName + "' from '" + bundleName + "'...");
        sMsg = null;
        loader = clazz.getClassLoader();
        variants = ExtendedNLS.buildVariantsFor(bundleName, localeValue);
        i = 0;
        while (i < variants.length) {
            pFile = ExtendedNLS.getPropertiesFileFor(variants[i]);
            if (pFile != null) ** GOTO lbl43
            v0 = input = loader == null ? ClassLoader.getSystemResourceAsStream(variants[i]) : loader.getResourceAsStream(variants[i]);
            if (input == null) {
                NLS_Support.debug("...Error loading '" + variants[i] + "'");
            } else {
                block19: {
                    try {
                        try {
                            pFile = new PropertiesFile(variants[i]);
                            pFile.load(input);
                            ExtendedNLS.propertiesFileList.add(pFile);
                        }
                        catch (IOException e) {
                            NLS_Support.debug("...Error loading '" + variants[i] + "'" + " / " + e.getMessage());
                            e.printStackTrace();
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException v1) {}
                            }
                            break block19;
                        }
                    }
                    catch (Throwable var13_12) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException v2) {}
                        }
                        throw var13_12;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException v3) {}
                    }
                }
                if (pFile != null && (sMsg = pFile.getProperty(fieldName)) != null) {
                    NLS_Support.debug("...Loaded '" + fieldName + "' from '" + variants[i] + "'");
                    break;
                }
            }
            ++i;
        }
        if (sMsg == null) {
            NLS_Support.debug("...Missed '" + fieldName + "' from '" + bundleName + "'");
        }
        NLS_Support.debug("Time to load '" + fieldName + "' from '" + bundleName + "' was " + (System.currentTimeMillis() - start) + "ms.");
        return sMsg;
    }

    private static String[] buildVariantsFor(String root, String localeValue) {
        String nl = localeValue;
        ArrayList<String> result = new ArrayList<String>(4);
        while (true) {
            result.add(String.valueOf('_') + nl + EXTENSION);
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        result.add(EXTENSION);
        root = root.replace('.', '/');
        String[] variants = new String[result.size()];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + (String)result.get(i);
            ++i;
        }
        return variants;
    }

    private static PropertiesFile getPropertiesFileFor(String fileName) {
        for (PropertiesFile pFile : propertiesFileList) {
            if (pFile == null || !pFile.getFileName().equals(fileName)) continue;
            return pFile;
        }
        return null;
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map<Object, Object> fields;
        private final boolean isAccessible;

        public MessagesProperties(Map<Object, Object> fieldMap, String bundleName, boolean isAccessible) {
            this.fields = fieldMap;
            this.bundleName = bundleName;
            this.isAccessible = isAccessible;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object fieldObject = this.fields.put(key, ASSIGNED);
            if (fieldObject == ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS unused message: " + key + " in: " + this.bundleName;
                NLS_Support.debug(msg);
                return null;
            }
            Field field = (Field)fieldObject;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    field.setAccessible(true);
                }
                field.set(null, new String(((String)value).toCharArray()));
            }
            catch (Exception e) {
                NLS_Support.debug("Exception setting field value.");
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class PropertiesFile
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final String fileName;

        public PropertiesFile(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

