/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.object;

import com.schott.let2.file.object.ObjectException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class ObjectParser {
    private static final int MAX_SIZE = 32768;
    private static final String SPLIT_PREFIX = "UTF_SPLIT";
    private String filePath = null;
    private FileInputStream fileReader = null;
    private ObjectInputStream reader = null;
    private FileOutputStream fileWriter = null;
    private ObjectOutputStream writer = null;

    public ObjectParser() {
    }

    public ObjectParser(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public List<String> readFile() throws ObjectException {
        ArrayList<String> readList = new ArrayList<String>();
        if (this.filePath != null) {
            try {
                boolean isSplitRestore = false;
                int totalSize = -1;
                int index = 0;
                String restored = "";
                this.fileReader = new FileInputStream(this.filePath);
                this.reader = new ObjectInputStream(this.fileReader);
                while (this.reader.available() > 0) {
                    String curLine = this.reader.readUTF();
                    if (curLine == null) continue;
                    if (isSplitRestore) {
                        if (totalSize == -1) {
                            totalSize = Integer.parseInt(curLine);
                            index = 0;
                        } else if (index < totalSize) {
                            restored = String.valueOf(restored) + curLine;
                            index += curLine.length();
                        } else {
                            readList.add(restored);
                            isSplitRestore = false;
                            totalSize = -1;
                            index = 0;
                            restored = "";
                        }
                    }
                    if (!curLine.equals(SPLIT_PREFIX)) {
                        if (isSplitRestore) continue;
                        readList.add(curLine);
                        continue;
                    }
                    isSplitRestore = true;
                }
            }
            catch (FileNotFoundException e) {
                throw new ObjectException(e.getMessage());
            }
            catch (IOException e) {
                throw new ObjectException(e.getMessage());
            }
        } else {
            throw new ObjectException("File name not available!");
        }
        return readList;
    }

    public void writeFile(List<String> fileInput, boolean isAppend) throws ObjectException {
        if (this.filePath != null) {
            boolean isFilePathOK = false;
            File f = null;
            try {
                f = new File(this.filePath);
                if (f.exists()) {
                    if (f.isFile()) {
                        isFilePathOK = true;
                    }
                } else if (f.isAbsolute() && (isFilePathOK = !f.getParentFile().exists() ? f.getParentFile().mkdirs() : f.getParentFile().isDirectory())) {
                    isFilePathOK = f.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isFilePathOK) {
                throw new ObjectException("File cannot be found and cannot be created!");
            }
            try {
                if (isAppend) {
                    if (this.fileWriter == null) {
                        this.fileWriter = new FileOutputStream(f, false);
                        if (this.writer == null) {
                            this.writer = new ObjectOutputStream(this.fileWriter);
                        }
                    }
                } else {
                    this.disposeWriter();
                    this.fileWriter = new FileOutputStream(f, false);
                    this.writer = new ObjectOutputStream(this.fileWriter);
                }
                for (String curLine : fileInput) {
                    if (curLine.length() <= 32768) {
                        this.writer.writeUTF(curLine);
                        continue;
                    }
                    this.writer.writeUTF(SPLIT_PREFIX);
                    this.writer.writeUTF(Integer.toString(curLine.length()));
                    int index = 0;
                    do {
                        String buf = null;
                        if (index + 32768 <= curLine.length()) {
                            buf = curLine.substring(index, index + 32768);
                            index += 32768;
                        } else {
                            buf = curLine.substring(index, curLine.length());
                            index += curLine.length() - index;
                        }
                        this.writer.writeUTF(buf);
                    } while (index < curLine.length());
                }
                this.writer.flush();
            }
            catch (FileNotFoundException e) {
                throw new ObjectException(e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ObjectException(e.getMessage());
            }
        }
        throw new ObjectException("File name not available!");
    }

    public void dispose() {
        this.disposeReader();
        this.disposeWriter();
    }

    private void disposeWriter() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void disposeReader() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

