/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.json.io.write;

import com.schott.let2.file.json.JSONArray;
import com.schott.let2.file.json.JSONObject;
import com.schott.let2.file.json.JSONValue;
import com.schott.let2.file.json.util.JSONUtil;
import com.schott.let2.file.raw.RawParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JSONWriter
extends JSONUtil {
    public static boolean writeJSONObject(JSONObject jsonObject, String filePath) throws IOException {
        ArrayList<String> jsonData = new ArrayList<String>();
        try {
            JSONWriter.writeJSONObject(jsonObject, jsonData);
            RawParser jsonFile = new RawParser(filePath);
            jsonFile.setWriteUTF8_Preamble(false);
            jsonFile.setWriteUTF8(true);
            jsonFile.writeFileRaw(jsonData, ".json");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void writeJSONObject(JSONObject jsonObject, List<String> jsonData) {
        JSONWriter.writeJSONObject(jsonObject, jsonData, null, 0);
        if (jsonData.size() > 0) {
            String sOut = jsonData.get(jsonData.size() - 1);
            if (sOut.lastIndexOf(",") == sOut.length() - 1) {
                sOut = sOut.substring(0, sOut.length() - 1);
            }
            jsonData.set(jsonData.size() - 1, sOut);
        }
    }

    private static void writeJSONObject(JSONObject jsonObject, List<String> jsonData, String sPreOut, int level) {
        if (jsonObject == null) {
            return;
        }
        List<JSONValue> array = jsonObject.getList();
        if (sPreOut != null) {
            jsonData.add(String.valueOf(sPreOut) + "{");
        } else {
            jsonData.add(String.valueOf(JSONWriter.indent(level)) + "{");
        }
        ++level;
        String sOut = null;
        int idx = 0;
        while (idx < array.size()) {
            JSONValue entry = array.get(idx);
            sOut = JSONWriter.indent(level);
            sOut = String.valueOf(sOut) + JSONWriter.addQuotes(JSONWriter.escape(String.valueOf(entry.getToken())));
            sOut = String.valueOf(sOut) + ": ";
            Object value = entry.getValue();
            if (value == null) {
                sOut = String.valueOf(sOut) + JSONWriter.addQuotes("null");
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof String) {
                sOut = String.valueOf(sOut) + JSONWriter.addQuotes(JSONWriter.escape((String)value));
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof Double) {
                sOut = ((Double)value).isInfinite() || ((Double)value).isNaN() ? String.valueOf(sOut) + JSONWriter.addQuotes("null") : String.valueOf(sOut) + value.toString();
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof Float) {
                sOut = ((Float)value).isInfinite() || ((Float)value).isNaN() ? String.valueOf(sOut) + JSONWriter.addQuotes("null") : String.valueOf(sOut) + value.toString();
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof Number) {
                sOut = String.valueOf(sOut) + value.toString();
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof Boolean) {
                sOut = String.valueOf(sOut) + value.toString();
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof JSONObject) {
                JSONWriter.writeJSONObject((JSONObject)value, jsonData, sOut, level);
                sOut = null;
            } else if (value instanceof JSONArray) {
                JSONWriter.writeJSONArray((JSONArray)value, jsonData, sOut, level);
                sOut = null;
            } else {
                sOut = String.valueOf(sOut) + JSONWriter.addQuotes(value.toString());
                sOut = String.valueOf(sOut) + ",";
            }
            if (sOut != null) {
                jsonData.add(sOut);
            }
            ++idx;
        }
        sOut = jsonData.get(jsonData.size() - 1);
        if (sOut.lastIndexOf(",") == sOut.length() - 1) {
            sOut = sOut.substring(0, sOut.length() - 1);
        }
        jsonData.set(jsonData.size() - 1, sOut);
        jsonData.add(String.valueOf(JSONWriter.indent(--level)) + "}" + ",");
    }

    private static void writeJSONArray(JSONArray jsonArray, List<String> jsonData, String sPreOut, int level) {
        if (jsonArray == null) {
            return;
        }
        List<Object> array = jsonArray.getArray();
        if (sPreOut != null) {
            jsonData.add(String.valueOf(sPreOut) + "[");
            sPreOut = null;
        } else {
            jsonData.add(String.valueOf(JSONWriter.indent(level)) + "[");
        }
        ++level;
        String sOut = null;
        int idx = 0;
        while (idx < array.size()) {
            Object value = array.get(idx);
            if (value == null) {
                sOut = String.valueOf(sOut) + JSONWriter.addQuotes("null");
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof String) {
                sOut = String.valueOf(sOut) + JSONWriter.addQuotes(JSONWriter.escape((String)value));
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof Double) {
                sOut = ((Double)value).isInfinite() || ((Double)value).isNaN() ? String.valueOf(sOut) + JSONWriter.addQuotes("null") : String.valueOf(sOut) + value.toString();
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof Float) {
                sOut = ((Float)value).isInfinite() || ((Float)value).isNaN() ? String.valueOf(sOut) + JSONWriter.addQuotes("null") : String.valueOf(sOut) + value.toString();
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof Number) {
                sOut = String.valueOf(sOut) + value.toString();
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof Boolean) {
                sOut = String.valueOf(sOut) + value.toString();
                sOut = String.valueOf(sOut) + ",";
            } else if (value instanceof JSONObject) {
                JSONWriter.writeJSONObject((JSONObject)value, jsonData, sOut, level);
                sOut = null;
            } else if (value instanceof JSONArray) {
                JSONWriter.writeJSONArray((JSONArray)value, jsonData, sOut, level);
                sOut = null;
            } else {
                sOut = String.valueOf(sOut) + JSONWriter.addQuotes(value.toString());
                sOut = String.valueOf(sOut) + ",";
            }
            if (sOut != null) {
                jsonData.add(sOut);
            }
            ++idx;
        }
        sOut = jsonData.get(jsonData.size() - 1);
        if (sOut.lastIndexOf(",") == sOut.length() - 1) {
            sOut = sOut.substring(0, sOut.length() - 1);
        }
        jsonData.set(jsonData.size() - 1, sOut);
        jsonData.add(String.valueOf(JSONWriter.indent(--level)) + "]" + ",");
    }
}

