/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.json;

import com.schott.let2.file.json.JSONValue;
import java.util.ArrayList;
import java.util.List;

public class JSONObject {
    private List<JSONValue> valueList = new ArrayList<JSONValue>();

    public void add(String token, Object value) {
        this.add(new JSONValue(token, value));
    }

    public void add(JSONValue jsonValue) {
        this.valueList.add(jsonValue);
    }

    public List<JSONValue> getList() {
        return this.valueList;
    }

    public String getAsString(String token) throws Exception {
        return (String)this.get(token);
    }

    public int getAsInteger(String token) throws Exception {
        Object obj = this.get(token);
        if (obj instanceof Long) {
            long lValue = (Long)obj;
            return (int)lValue;
        }
        return (Integer)obj;
    }

    public long getAsLong(String token) throws Exception {
        Object obj = this.get(token);
        if (obj instanceof Integer) {
            int iValue = (Integer)obj;
            return iValue;
        }
        return (Long)obj;
    }

    public float getAsFloat(String token) throws Exception {
        Object obj = this.get(token);
        if (obj instanceof Double) {
            double dValue = (Double)obj;
            return (float)dValue;
        }
        return ((Float)obj).floatValue();
    }

    public double getAsDouble(String token) throws Exception {
        Object obj = this.get(token);
        if (obj instanceof Float) {
            float fValue = ((Float)obj).floatValue();
            return fValue;
        }
        return (Double)obj;
    }

    public Object get(String token) {
        for (JSONValue value : this.valueList) {
            if (!value.getToken().equals(token)) continue;
            return value.getValue();
        }
        return null;
    }
}

