/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.ui.swt.serialport.internal;

import com.schott.let2.hw.serialport.ASerialPortConfiguration;
import com.schott.let2.hw.serialport.ISerialPortConfiguration;
import com.schott.let2.ui.swt.controls.dialog.ADialog;
import com.schott.let2.ui.swt.controls.value.Header;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PortConfigurationDialog
extends ADialog {
    public static final int SEL_OK = 0;
    public static final int SEL_CANCEL = 1;
    private int selection = 1;
    private Header lblHeaderConfig;
    private Label lblConfigBaud;
    private Combo comConfigBaud;
    private int[] configBaudList;
    private Label lblConfigData;
    private Combo comConfigData;
    private int[] configDataList;
    private Label lblConfigStop;
    private Combo comConfigStop;
    private float[] configStopList;
    private Label lblConfigParity;
    private Combo comConfigParity;
    private int[] configParityList;
    private ISerialPortConfiguration activeConfig;
    private Button btnOK;
    private Button btnCancel;

    public PortConfigurationDialog(Shell parent, ISerialPortConfiguration inputConfig) {
        super(parent, "Port Configuration Editor", true, false);
        this.activateScrollSupport();
        this.setMaxSize(800, 600);
        this.activeConfig = inputConfig != null ? ASerialPortConfiguration.copyConfiguration((ISerialPortConfiguration)inputConfig) : ASerialPortConfiguration.createConfiguration();
    }

    protected void createScrollGUIChildren(Composite main) {
        main.setLayout((Layout)new GridLayout(2, false));
        this.configBaudList = new int[8];
        this.configBaudList[0] = 9600;
        this.configBaudList[1] = 19200;
        this.configBaudList[2] = 38400;
        this.configBaudList[3] = 57600;
        this.configBaudList[4] = 115200;
        this.configBaudList[5] = 230400;
        this.configBaudList[6] = 460800;
        this.configBaudList[7] = 921600;
        this.configDataList = new int[2];
        this.configDataList[0] = 7;
        this.configDataList[1] = 8;
        this.configStopList = new float[3];
        this.configStopList[0] = 1.0f;
        this.configStopList[1] = 1.5f;
        this.configStopList[2] = 2.0f;
        this.configParityList = new int[5];
        this.configParityList[0] = 0;
        this.configParityList[1] = 1;
        this.configParityList[2] = 2;
        this.configParityList[3] = 3;
        this.configParityList[4] = 4;
        this.lblHeaderConfig = new Header(main, 0, "Port Configuration Editor");
        this.lblHeaderConfig.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        this.lblHeaderConfig.setSize(300);
        this.lblConfigBaud = new Label(main, 0);
        this.lblConfigBaud.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConfigBaud.setText("Baudrate [Bit/s]:");
        this.comConfigBaud = new Combo(main, 12);
        this.comConfigBaud.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        int idxType = -1;
        if (this.configBaudList.length > 0) {
            idxType = 0;
        }
        int i = 0;
        while (i < this.configBaudList.length) {
            this.comConfigBaud.add(Integer.toString(this.configBaudList[i]), i);
            if (this.activeConfig.getBaudRate() == this.configBaudList[i]) {
                idxType = i;
            }
            ++i;
        }
        this.comConfigBaud.select(idxType);
        this.comConfigBaud.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PortConfigurationDialog.this.comConfigBaud.getSelectionIndex() != -1) {
                    PortConfigurationDialog.this.activeConfig.setBaudRate(PortConfigurationDialog.this.configBaudList[PortConfigurationDialog.this.comConfigBaud.getSelectionIndex()]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblConfigData = new Label(main, 0);
        this.lblConfigData.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConfigData.setText("Data Bits:");
        this.comConfigData = new Combo(main, 12);
        this.comConfigData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        idxType = -1;
        if (this.configDataList.length > 0) {
            idxType = 0;
        }
        i = 0;
        while (i < this.configDataList.length) {
            this.comConfigData.add(Integer.toString(this.configDataList[i]), i);
            if (this.activeConfig.getDataBits() == this.configDataList[i]) {
                idxType = i;
            }
            ++i;
        }
        this.comConfigData.select(idxType);
        this.comConfigData.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PortConfigurationDialog.this.comConfigData.getSelectionIndex() != -1) {
                    PortConfigurationDialog.this.activeConfig.setDataBits(PortConfigurationDialog.this.configDataList[PortConfigurationDialog.this.comConfigData.getSelectionIndex()]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblConfigStop = new Label(main, 0);
        this.lblConfigStop.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConfigStop.setText("Stop Bits:");
        this.comConfigStop = new Combo(main, 12);
        this.comConfigStop.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        idxType = -1;
        if (this.configStopList.length > 0) {
            idxType = 0;
        }
        i = 0;
        while (i < this.configStopList.length) {
            this.comConfigStop.add(Float.toString(this.configStopList[i]), i);
            if (this.activeConfig.getStopBits() == this.configStopList[i]) {
                idxType = i;
            }
            ++i;
        }
        this.comConfigStop.select(idxType);
        this.comConfigStop.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PortConfigurationDialog.this.comConfigStop.getSelectionIndex() != -1) {
                    PortConfigurationDialog.this.activeConfig.setStopBits(PortConfigurationDialog.this.configStopList[PortConfigurationDialog.this.comConfigStop.getSelectionIndex()]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblConfigParity = new Label(main, 0);
        this.lblConfigParity.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConfigParity.setText("Parity:");
        this.comConfigParity = new Combo(main, 12);
        this.comConfigParity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        idxType = -1;
        if (this.configParityList.length > 0) {
            idxType = 0;
        }
        i = 0;
        while (i < this.configParityList.length) {
            this.comConfigParity.add(ASerialPortConfiguration.parityToName((int)this.configParityList[i]), i);
            if (this.activeConfig.getParity() == this.configParityList[i]) {
                idxType = i;
            }
            ++i;
        }
        this.comConfigParity.select(idxType);
        this.comConfigParity.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PortConfigurationDialog.this.comConfigParity.getSelectionIndex() != -1) {
                    PortConfigurationDialog.this.activeConfig.setParity(PortConfigurationDialog.this.configParityList[PortConfigurationDialog.this.comConfigParity.getSelectionIndex()]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected int createGUIChildren(Composite main) {
        this.btnOK = new Button(main, 8);
        this.btnOK.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnOK.setText("Apply");
        this.btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PortConfigurationDialog.this.selection = 0;
                PortConfigurationDialog.this.closeHandler();
            }
        });
        this.btnCancel = new Button(main, 8);
        this.btnCancel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PortConfigurationDialog.this.closeHandler();
            }
        });
        this.btnOK.setFocus();
        return 2;
    }

    protected void onEnter() {
        this.selection = 0;
        this.closeHandler();
    }

    private void closeHandler() {
        this.close();
    }

    public int getSelection() {
        return this.selection;
    }

    public ISerialPortConfiguration getActiveConfiguration() {
        return this.activeConfig;
    }
}

