/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.device.general;

import com.schott.let2.device.general.APropertyChangeDevice;
import java.util.ArrayList;
import java.util.List;

public abstract class ALockablePropertyChangeDevice
extends APropertyChangeDevice {
    private static long NO_OWNER = -1L;
    private long currentOwnerID = NO_OWNER;
    private int currentOwnerAccessCnt = 0;
    private List<Long> waitingOwnerIDs = new ArrayList<Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getAccess(long timeoutInMS) {
        long newOwnerID = Thread.currentThread().getId();
        if (newOwnerID == this.currentOwnerID) {
            ++this.currentOwnerAccessCnt;
            return true;
        }
        List<Long> list = this.waitingOwnerIDs;
        synchronized (list) {
            this.waitingOwnerIDs.add(newOwnerID);
        }
        long waitingStartTime = System.currentTimeMillis();
        do {
            if (this.currentOwnerID == NO_OWNER) {
                int waitingOwnerIDsSize = 0;
                List<Long> list2 = this.waitingOwnerIDs;
                synchronized (list2) {
                    waitingOwnerIDsSize = this.waitingOwnerIDs.size();
                }
                if (waitingOwnerIDsSize > 0) {
                    long waitingOwnerID = NO_OWNER;
                    List<Long> list3 = this.waitingOwnerIDs;
                    synchronized (list3) {
                        waitingOwnerID = this.waitingOwnerIDs.get(0);
                    }
                    if (waitingOwnerID == newOwnerID && this.currentOwnerID == NO_OWNER) {
                        this.currentOwnerID = newOwnerID;
                        ++this.currentOwnerAccessCnt;
                        list3 = this.waitingOwnerIDs;
                        synchronized (list3) {
                            this.waitingOwnerIDs.remove(newOwnerID);
                        }
                        return true;
                    }
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        } while (System.currentTimeMillis() - waitingStartTime < timeoutInMS);
        List<Long> list4 = this.waitingOwnerIDs;
        synchronized (list4) {
            this.waitingOwnerIDs.remove(newOwnerID);
        }
        return false;
    }

    protected boolean releaseAccess() {
        long newOwnerID = Thread.currentThread().getId();
        if (newOwnerID == this.currentOwnerID || this.currentOwnerID == NO_OWNER) {
            --this.currentOwnerAccessCnt;
            if (this.currentOwnerAccessCnt <= 0) {
                this.currentOwnerAccessCnt = 0;
                this.currentOwnerID = NO_OWNER;
            }
            return true;
        }
        return false;
    }
}

