/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.time.watch;

import com.schott.let2.util.debug.DebugSupport;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TimeWatch
extends DebugSupport
implements Runnable {
    public static final String PROP_UPDATE = "TimeUpdate";
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final int STATE_STOPPED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_PAUSED = 2;
    private volatile boolean isRunning = true;
    private volatile boolean isWorkerDisposed = false;
    private boolean isStart = false;
    private boolean isPause = false;
    private boolean isCont = false;
    private boolean isStop = false;
    private long time = 0L;
    private long bufTime = 0L;
    private long updateTime = 0L;
    private long updateRate = 250L;
    private int curState = 0;
    private String name = "Time Watch";

    public TimeWatch(String name) {
        this.name = name;
        this.setDebugOutput();
    }

    public TimeWatch() {
        this.setDebugOutput();
    }

    private void setDebugOutput() {
        this.setDebugOutput(false, true, this.name);
    }

    private void dispose() {
        this.isStart = false;
        this.isStop = false;
        this.isPause = false;
        this.isCont = false;
        this.curState = 0;
        this.time = 0L;
        this.updateTime = 0L;
        this.bufTime = 0L;
        this.isWorkerDisposed = true;
    }

    public synchronized void stop() {
        this.isRunning = false;
        while (!this.isWorkerDisposed) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        this.printDebug("Started!");
        this.updateTime = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            switch (this.curState) {
                case 0: {
                    if (!this.isStart) break;
                    this.time = System.currentTimeMillis();
                    this.isStart = false;
                    this.curState = 1;
                    break;
                }
                case 1: {
                    if (this.isPause) {
                        this.bufTime = System.currentTimeMillis() - this.time;
                        this.isPause = false;
                        this.isCont = false;
                        this.curState = 2;
                    } else if (this.isStop) {
                        this.isStop = false;
                        this.curState = 0;
                    }
                    if (System.currentTimeMillis() - this.updateTime < this.updateRate) break;
                    long curDiff = System.currentTimeMillis() - this.time;
                    this.firePropertyChange(PROP_UPDATE, null, curDiff);
                    this.updateTime = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    if (this.isCont) {
                        this.time = System.currentTimeMillis() - this.bufTime;
                        this.bufTime = 0L;
                        this.isCont = false;
                        this.isPause = false;
                        this.curState = 1;
                        break;
                    }
                    if (!this.isStop) break;
                    this.isStop = false;
                    this.curState = 0;
                    break;
                }
            }
        } while (this.isRunning);
        this.dispose();
        this.printDebug("Stopped!");
    }

    public void startWatch() {
        this.isStart = true;
    }

    public void pauseWatch() {
        this.isPause = true;
    }

    public void continueWatch() {
        this.isCont = true;
    }

    public void stopWatch() {
        this.isStop = true;
    }

    public boolean setUpdateRate(long milliseconds) {
        if (milliseconds >= 10L) {
            this.updateRate = milliseconds;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

