/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TimeUtil {
    public static final int MILLIS = 0;
    public static final int SECONDS = 1;
    public static final int MINUTES = 2;
    public static final int HOURS = 3;
    public static final int DAYS = 4;
    public static final int MONTHS = 5;
    private static final long D_TO_H_L = 24L;
    private static final long H_TO_MIN_L = 60L;
    private static final long MIN_TO_SEC_L = 60L;
    private static final long SEC_TO_MS_L = 1000L;
    private static final double D_TO_H_D = 24.0;
    private static final double H_TO_MIN_D = 60.0;
    private static final double MIN_TO_SEC_D = 60.0;
    private static final double SEC_TO_MS_D = 1000.0;
    private static final double MS_TO_US_D = 1000.0;
    private static final double US_TO_NS_D = 1000.0;
    private static final double NS_TO_PS_D = 1000.0;
    private static final double PS_TO_FS_D = 1000.0;
    private static final double D_FROM_H = 0.041666666666666664;
    private static final double H_FROM_MIN = 0.016666666666666666;
    private static final double MIN_FROM_SEC = 0.016666666666666666;
    private static final double SEC_FROM_MS = 0.001;
    private static final double MS_FROM_US = 0.001;
    private static final double US_FROM_NS = 0.001;
    private static final double NS_FROM_PS = 0.001;
    private static final double PS_FROM_FS = 0.001;

    public static boolean isDateTimeInSEqualOrAfterBase(Date dateBase, Date date) {
        long tDateBase;
        if (dateBase == null || date == null) {
            return false;
        }
        long tDate = date.getTime() / 1000L;
        return tDate >= (tDateBase = dateBase.getTime() / 1000L);
    }

    public static boolean isDateEqualOrAfterBase(Date dateBase, Date date) {
        if (dateBase == null || date == null) {
            return false;
        }
        return date.compareTo(dateBase) >= 0;
    }

    public static boolean isDateOnAnotherDayThanBase(Date dateBase, Date date) {
        if (dateBase == null || date == null) {
            return true;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
            return !df.format(dateBase).equals(df.format(date));
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static String getDateString(Date d) {
        if (d == null) {
            return "null";
        }
        Calendar c = Calendar.getInstance(Locale.GERMAN);
        c.setTime(d);
        String date = "";
        int buf = c.get(5);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ".";
        buf = c.get(2) + 1;
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ".";
        date = String.valueOf(date) + c.get(1) + " ";
        buf = c.get(11);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ":";
        buf = c.get(12);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ":";
        buf = c.get(13);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        return date;
    }

    public static String getDateString(Date d, String dateFormat) {
        String sDate = null;
        if (d == null) {
            return sDate;
        }
        if (dateFormat == null) {
            return sDate;
        }
        if (dateFormat.isEmpty()) {
            return sDate;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, Locale.GERMAN);
            sDate = df.format(d);
        }
        catch (Exception exception) {}
        return sDate;
    }

    public static Date getDate(String sDate, String dateFormat) {
        Date d = null;
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, Locale.GERMAN);
        try {
            d = df.parse(sDate);
        }
        catch (Exception exception) {}
        return d;
    }

    public static String getDateStringNoSeconds(Date d) {
        if (d == null) {
            return "null";
        }
        Calendar c = Calendar.getInstance(Locale.GERMAN);
        c.setTime(d);
        String date = "";
        int buf = c.get(5);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ".";
        buf = c.get(2) + 1;
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ".";
        date = String.valueOf(date) + c.get(1) + " ";
        buf = c.get(11);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ":";
        buf = c.get(12);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        return date;
    }

    public static String getDateStringYYYYMMDDHHmmss(Date d) {
        if (d == null) {
            return "null";
        }
        Calendar c = Calendar.getInstance(Locale.GERMAN);
        c.setTime(d);
        String date = "";
        date = String.valueOf(date) + c.get(1) + "-";
        int buf = c.get(2) + 1;
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + "-";
        buf = c.get(5);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + " ";
        buf = c.get(11);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ":";
        buf = c.get(12);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ":";
        buf = c.get(13);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        return date;
    }

    public static String getDateStringDDxMMxYY(Date d, String x) {
        if (d == null) {
            return "null";
        }
        Calendar c = Calendar.getInstance(Locale.GERMAN);
        c.setTime(d);
        String date = "";
        int buf = c.get(5);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + x;
        buf = c.get(2) + 1;
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + x;
        date = String.valueOf(date) + (c.get(1) - 2000);
        return date;
    }

    public static String getDateFileString() {
        return TimeUtil.getDateFileString(new Date(System.currentTimeMillis()));
    }

    public static String getDateFileString(Date d) {
        if (d == null) {
            return "null";
        }
        Calendar c = Calendar.getInstance(Locale.GERMAN);
        c.setTime(d);
        String date = "";
        date = String.valueOf(date) + c.get(1) + "-";
        int buf = c.get(2) + 1;
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + "-";
        buf = c.get(5);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + "_";
        buf = c.get(11);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + "-";
        buf = c.get(12);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + "-";
        buf = c.get(13);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        return date;
    }

    public static Date parseDateFileString(String sDate) {
        Date d = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.GERMAN);
        try {
            d = df.parse(sDate);
        }
        catch (Exception exception) {}
        return d;
    }

    public static Date parseDateVersionString(String sVersionDate) {
        Date d = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd", Locale.GERMAN);
        try {
            d = df.parse(sVersionDate.replace("v", ""));
        }
        catch (Exception exception) {}
        return d;
    }

    public static Date getModifiedDate(int type, int amount, boolean isAdd, Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance(Locale.GERMAN);
        c.setTime(date);
        if (!isAdd) {
            amount *= -1;
        }
        switch (type) {
            case 0: {
                c.add(14, amount);
                break;
            }
            case 1: {
                c.add(13, amount);
                break;
            }
            case 2: {
                c.add(12, amount);
                break;
            }
            case 3: {
                c.add(10, amount);
                break;
            }
            case 4: {
                c.add(5, amount);
                break;
            }
            case 5: {
                c.add(2, amount);
            }
        }
        return c.getTime();
    }

    public static boolean isDateOlderThan(int type, int amount, Date date) {
        Calendar c = Calendar.getInstance(Locale.GERMAN);
        switch (type) {
            case 0: {
                c.add(14, -amount);
                break;
            }
            case 1: {
                c.add(13, -amount);
                break;
            }
            case 2: {
                c.add(12, -amount);
                break;
            }
            case 3: {
                c.add(10, -amount);
                break;
            }
            case 4: {
                c.add(5, -amount);
                break;
            }
            case 5: {
                c.add(2, -amount);
            }
        }
        return c.getTime().after(date);
    }

    public static String getDurationString(Date startDate, Date endDate) {
        long startMS = 0L;
        long endMS = 0L;
        Calendar c = Calendar.getInstance(Locale.GERMAN);
        if (startDate != null && endDate != null) {
            c.setTime(startDate);
            startMS = c.getTimeInMillis();
            c.setTime(endDate);
            endMS = c.getTimeInMillis();
        }
        return TimeUtil.getDurationString(endMS - startMS);
    }

    public static String getDurationString(long milliseconds) {
        long day = 0L;
        day = (milliseconds /= 1000L) / 86400L;
        long hour = (milliseconds -= 86400L * day) / 3600L;
        long min = (milliseconds -= 3600L * hour) / 60L;
        long sec = milliseconds -= 60L * min;
        String sTime = "";
        if (day > 0L) {
            sTime = String.valueOf(sTime) + day + "d ";
        }
        if (hour > 0L || day > 0L) {
            sTime = String.valueOf(sTime) + hour + "h ";
        }
        if (min > 0L || hour > 0L || day > 0L) {
            if (min <= 9L) {
                sTime = String.valueOf(sTime) + "0";
            }
            sTime = String.valueOf(sTime) + min + "m ";
        }
        if (sec <= 9L) {
            sTime = String.valueOf(sTime) + "0";
        }
        sTime = String.valueOf(sTime) + sec + "s";
        return sTime;
    }

    public static String getDurationStringWithMS(long milliseconds) {
        long day = 0L;
        day = milliseconds / 86400000L;
        long hour = (milliseconds -= 86400000L * day) / 3600000L;
        long min = (milliseconds -= 3600000L * hour) / 60000L;
        long sec = (milliseconds -= 60000L * min) / 1000L;
        long ms = milliseconds - 1000L * sec;
        String sTime = "";
        if (day > 0L) {
            sTime = String.valueOf(sTime) + day + "d ";
        }
        if (hour > 0L || day > 0L) {
            sTime = String.valueOf(sTime) + hour + "h ";
        }
        if (min > 0L || hour > 0L || day > 0L) {
            if (min <= 9L) {
                sTime = String.valueOf(sTime) + "0";
            }
            sTime = String.valueOf(sTime) + min + "m ";
        }
        if (sec > 0L || min > 0L || hour > 0L || day > 0L) {
            if (sec <= 9L) {
                sTime = String.valueOf(sTime) + "0";
            }
            sTime = String.valueOf(sTime) + sec + "s ";
        }
        if (ms <= 9L) {
            sTime = String.valueOf(sTime) + "00";
        } else if (ms <= 99L) {
            sTime = String.valueOf(sTime) + "0";
        }
        sTime = String.valueOf(sTime) + ms + "ms";
        return sTime;
    }

    public static long D_TO_H(long days) {
        return days * 24L;
    }

    public static long D_TO_MIN(long days) {
        return TimeUtil.H_TO_MIN(TimeUtil.D_TO_H(days));
    }

    public static long D_TO_SEC(long days) {
        return TimeUtil.MIN_TO_SEC(TimeUtil.H_TO_MIN(TimeUtil.D_TO_H(days)));
    }

    public static long D_TO_MS(long days) {
        return TimeUtil.SEC_TO_MS(TimeUtil.MIN_TO_SEC(TimeUtil.H_TO_MIN(TimeUtil.D_TO_H(days))));
    }

    public static long H_TO_MIN(long hours) {
        return hours * 60L;
    }

    public static long H_TO_SEC(long hours) {
        return TimeUtil.MIN_TO_SEC(TimeUtil.H_TO_MIN(hours));
    }

    public static long H_TO_MS(long hours) {
        return TimeUtil.SEC_TO_MS(TimeUtil.MIN_TO_SEC(TimeUtil.H_TO_MIN(hours)));
    }

    public static long MIN_TO_SEC(long minutes) {
        return minutes * 60L;
    }

    public static long MIN_TO_MS(long minutes) {
        return TimeUtil.SEC_TO_MS(TimeUtil.MIN_TO_SEC(minutes));
    }

    public static long SEC_TO_MS(long seconds) {
        return seconds * 1000L;
    }

    public static double D_TO_H(double days) {
        return days * 24.0;
    }

    public static double D_TO_MIN(double days) {
        return TimeUtil.H_TO_MIN(TimeUtil.D_TO_H(days));
    }

    public static double D_TO_SEC(double days) {
        return TimeUtil.MIN_TO_SEC(TimeUtil.H_TO_MIN(TimeUtil.D_TO_H(days)));
    }

    public static double D_TO_MS(double days) {
        return TimeUtil.SEC_TO_MS(TimeUtil.MIN_TO_SEC(TimeUtil.H_TO_MIN(TimeUtil.D_TO_H(days))));
    }

    public static double H_TO_MIN(double hours) {
        return hours * 60.0;
    }

    public static double H_TO_SEC(double hours) {
        return TimeUtil.MIN_TO_SEC(TimeUtil.H_TO_MIN(hours));
    }

    public static double H_TO_MS(double hours) {
        return TimeUtil.SEC_TO_MS(TimeUtil.MIN_TO_SEC(TimeUtil.H_TO_MIN(hours)));
    }

    public static double MIN_TO_SEC(double minutes) {
        return minutes * 60.0;
    }

    public static double MIN_TO_MS(double minutes) {
        return TimeUtil.SEC_TO_MS(TimeUtil.MIN_TO_SEC(minutes));
    }

    public static double SEC_TO_MS(double seconds) {
        return seconds * 1000.0;
    }

    public static double SEC_TO_US(double seconds) {
        return TimeUtil.MS_TO_US(TimeUtil.SEC_TO_MS(seconds));
    }

    public static double SEC_TO_NS(double seconds) {
        return TimeUtil.US_TO_NS(TimeUtil.MS_TO_US(TimeUtil.SEC_TO_MS(seconds)));
    }

    public static double SEC_TO_PS(double seconds) {
        return TimeUtil.NS_TO_PS(TimeUtil.US_TO_NS(TimeUtil.MS_TO_US(TimeUtil.SEC_TO_MS(seconds))));
    }

    public static double SEC_TO_FS(double seconds) {
        return TimeUtil.PS_TO_FS(TimeUtil.NS_TO_PS(TimeUtil.US_TO_NS(TimeUtil.MS_TO_US(TimeUtil.SEC_TO_MS(seconds)))));
    }

    public static double MS_TO_US(double ms) {
        return ms * 1000.0;
    }

    public static double MS_TO_NS(double ms) {
        return TimeUtil.US_TO_NS(TimeUtil.MS_TO_US(ms));
    }

    public static double MS_TO_PS(double ms) {
        return TimeUtil.NS_TO_PS(TimeUtil.US_TO_NS(TimeUtil.MS_TO_US(ms)));
    }

    public static double MS_TO_FS(double ms) {
        return TimeUtil.PS_TO_FS(TimeUtil.NS_TO_PS(TimeUtil.US_TO_NS(TimeUtil.MS_TO_US(ms))));
    }

    public static double US_TO_NS(double us) {
        return us * 1000.0;
    }

    public static double US_TO_PS(double us) {
        return TimeUtil.NS_TO_PS(TimeUtil.US_TO_NS(us));
    }

    public static double US_TO_FS(double us) {
        return TimeUtil.PS_TO_FS(TimeUtil.NS_TO_PS(TimeUtil.US_TO_NS(us)));
    }

    public static double NS_TO_PS(double ns) {
        return ns * 1000.0;
    }

    public static double NS_TO_FS(double ns) {
        return TimeUtil.PS_TO_FS(TimeUtil.NS_TO_PS(ns));
    }

    public static double PS_TO_FS(double ps) {
        return ps * 1000.0;
    }

    public static double D_FROM_H(double hours) {
        return hours * 0.041666666666666664;
    }

    public static double D_FROM_MIN(double minutes) {
        return TimeUtil.D_FROM_H(TimeUtil.H_FROM_MIN(minutes));
    }

    public static double D_FROM_SEC(double seconds) {
        return TimeUtil.D_FROM_H(TimeUtil.H_FROM_MIN(TimeUtil.MIN_FROM_SEC(seconds)));
    }

    public static double D_FROM_MS(double millis) {
        return TimeUtil.D_FROM_H(TimeUtil.H_FROM_MIN(TimeUtil.MIN_FROM_SEC(TimeUtil.SEC_FROM_MS(millis))));
    }

    public static double H_FROM_MIN(double minutes) {
        return minutes * 0.016666666666666666;
    }

    public static double H_FROM_SEC(double seconds) {
        return TimeUtil.H_FROM_MIN(TimeUtil.MIN_FROM_SEC(seconds));
    }

    public static double H_FROM_MS(double millis) {
        return TimeUtil.H_FROM_MIN(TimeUtil.MIN_FROM_SEC(TimeUtil.SEC_FROM_MS(millis)));
    }

    public static double MIN_FROM_SEC(double seconds) {
        return seconds * 0.016666666666666666;
    }

    public static double MIN_FROM_MS(double millis) {
        return TimeUtil.MIN_FROM_SEC(TimeUtil.SEC_FROM_MS(millis));
    }

    public static double SEC_FROM_MS(double millis) {
        return millis * 0.001;
    }

    public static double SEC_FROM_US(double us) {
        return TimeUtil.SEC_FROM_MS(TimeUtil.MS_FROM_US(us));
    }

    public static double SEC_FROM_NS(double ns) {
        return TimeUtil.SEC_FROM_MS(TimeUtil.MS_FROM_US(TimeUtil.US_FROM_NS(ns)));
    }

    public static double SEC_FROM_PS(double ps) {
        return TimeUtil.SEC_FROM_MS(TimeUtil.MS_FROM_US(TimeUtil.US_FROM_NS(TimeUtil.NS_FROM_PS(ps))));
    }

    public static double SEC_FROM_FS(double fs) {
        return TimeUtil.SEC_FROM_MS(TimeUtil.MS_FROM_US(TimeUtil.US_FROM_NS(TimeUtil.NS_FROM_PS(TimeUtil.PS_FROM_FS(fs)))));
    }

    public static double MS_FROM_US(double us) {
        return us * 0.001;
    }

    public static double MS_FROM_NS(double ns) {
        return TimeUtil.MS_FROM_US(TimeUtil.US_FROM_NS(ns));
    }

    public static double MS_FROM_PS(double ps) {
        return TimeUtil.MS_FROM_US(TimeUtil.US_FROM_NS(TimeUtil.NS_FROM_PS(ps)));
    }

    public static double MS_FROM_FS(double fs) {
        return TimeUtil.MS_FROM_US(TimeUtil.US_FROM_NS(TimeUtil.NS_FROM_PS(TimeUtil.PS_FROM_FS(fs))));
    }

    public static double US_FROM_NS(double ns) {
        return ns * 0.001;
    }

    public static double US_FROM_PS(double ps) {
        return TimeUtil.US_FROM_NS(TimeUtil.NS_FROM_PS(ps));
    }

    public static double US_FROM_FS(double fs) {
        return TimeUtil.US_FROM_NS(TimeUtil.NS_FROM_PS(TimeUtil.PS_FROM_FS(fs)));
    }

    public static double NS_FROM_PS(double ps) {
        return ps * 0.001;
    }

    public static double NS_FROM_FS(double fs) {
        return TimeUtil.NS_FROM_PS(TimeUtil.PS_FROM_FS(fs));
    }

    public static double PS_FROM_FS(double fs) {
        return fs * 0.001;
    }
}

