/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.sound.runnable;

import com.schott.let2.file.util.FileUtil;
import com.schott.let2.util.data.value.ValueUtil;
import com.schott.let2.util.debug.DebugSupport;
import com.schott.let2.util.sound.impl.MyJavaSoundAudioDevice;
import com.schott.let2.util.sound.impl.MyJavaSoundAudioDeviceFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.AudioDeviceFactory;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.JavaSoundAudioDeviceFactory;

public class SoundRunnable
implements Runnable {
    public static boolean IS_DEBUG = true;
    protected static final String DEBUG_IDENTIFIER = "Sound Support";
    public static final int PLAY_MODE_SINGLE = 0;
    public static final int PLAY_MODE_MULTI = 1;
    public static final int PLAY_MODE_UNLIM = 2;
    private boolean isRunning = false;
    private boolean isFinished = true;
    private String path = null;
    private boolean isStartPlaying = false;
    private boolean isPlayingActive = false;
    private boolean isPlayingFinished = true;
    private boolean isPlaying = false;
    private int mode = 0;
    private boolean isUnlimited = false;
    private int curLoopCnt = 0;
    private int loopCount = 0;
    private long loopDelayInMS = 0L;
    private double gain = 20.0;
    private FactoryRegistry factoryRegistry;
    private Bitstream bitstream;
    private Decoder decoder;
    private AudioDevice audio;

    public static void debug(String msg) {
        if (IS_DEBUG) {
            DebugSupport.printDebugConsole((String)DEBUG_IDENTIFIER, (String)msg);
        }
    }

    public SoundRunnable() {
        try {
            this.factoryRegistry = FactoryRegistry.systemRegistry();
            this.factoryRegistry.removeFactoryType(JavaSoundAudioDeviceFactory.class);
            this.factoryRegistry.addFactory((AudioDeviceFactory)new MyJavaSoundAudioDeviceFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setPath(String path) {
        if (path == null) {
            return false;
        }
        if (!FileUtil.isFileExisting((String)path)) {
            return false;
        }
        this.path = path;
        return true;
    }

    public boolean setMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                this.mode = mode;
                return true;
            }
        }
        return false;
    }

    public void setGain(double gain) {
        this.gain = ValueUtil.checkValue((double)0.0, (double)150.0, (double)gain);
    }

    public void setLoopCnt(int loopCount) {
        this.loopCount = ValueUtil.checkValue((int)0, (int)1000, (int)loopCount);
    }

    public void setLoopDelay(long loopDelayInMS) {
        this.loopDelayInMS = ValueUtil.checkValue((long)10L, (long)3600000L, (long)loopDelayInMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.isFinished = false;
        this.isRunning = true;
        do {
            block19: {
                block18: {
                    if (this.isStartPlaying) {
                        this.isPlayingFinished = false;
                        this.isPlayingActive = true;
                        try {
                            this.curLoopCnt = 0;
                            switch (this.mode) {
                                case 1: 
                                case 2: {
                                    this.isUnlimited = true;
                                    ** break;
                                }
                            }
                            this.isUnlimited = false;
                            break block18;
                        }
                        catch (Exception v0) {
                            SoundRunnable.debug("No sound support by system!");
                            break block19;
                        }
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                do {
                    this.isPlaying = true;
                    is = new FileInputStream(this.path);
                    this.bitstream = new Bitstream((InputStream)is);
                    this.decoder = new Decoder();
                    this.audio = this.factoryRegistry.createAudioDevice();
                    this.audio.open(this.decoder);
                    if (this.audio instanceof MyJavaSoundAudioDevice) {
                        ((MyJavaSoundAudioDevice)this.audio).setLineGain(this.gain);
                    }
                    while (this.isPlaying) {
                        this.isPlaying = this.decodeFrame();
                        if (this.isPlayingActive) continue;
                        this.isPlaying = false;
                        break;
                    }
                    this.audio.flush();
                    var2_3 = this;
                    synchronized (var2_3) {
                        this.close();
                    }
                    ++this.curLoopCnt;
                    if (this.mode == 0 || this.mode == 1 && this.curLoopCnt >= this.loopCount) break;
                    if (this.loopDelayInMS == 0L || !this.isUnlimited) continue;
                    delayStartTime = System.currentTimeMillis();
                    do {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } while (System.currentTimeMillis() - delayStartTime < this.loopDelayInMS && this.isPlayingActive);
                } while (this.isPlayingActive && this.isUnlimited);
            }
            this.isPlayingActive = false;
            this.isPlayingFinished = true;
            this.isStartPlaying = false;
        } while (this.isRunning);
        this.isFinished = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPlayingActive() {
        return this.isPlayingActive;
    }

    public void startPlay() {
        this.isStartPlaying = true;
    }

    public boolean stopPlay() {
        this.isPlayingActive = false;
        while (!this.isPlayingFinished) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void stop() {
        this.stopPlay();
        this.isRunning = false;
        while (!this.isFinished) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.factoryRegistry != null) {
            this.factoryRegistry = null;
        }
    }

    private synchronized void close() {
        if (this.audio != null) {
            this.audio.close();
            try {
                this.bitstream.close();
                this.bitstream = null;
            }
            catch (BitstreamException bitstreamException) {}
            this.audio = null;
        }
        if (this.decoder != null) {
            this.decoder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decodeFrame() throws JavaLayerException {
        Header h;
        AudioDevice out;
        block9: {
            block8: {
                try {
                    out = this.audio;
                    if (out != null) break block8;
                    return false;
                }
                catch (RuntimeException ex) {
                    throw new JavaLayerException("Exception decoding audio frame", (Throwable)ex);
                }
            }
            h = this.bitstream.readFrame();
            if (h != null) break block9;
            return false;
        }
        SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
        SoundRunnable soundRunnable = this;
        synchronized (soundRunnable) {
            out = this.audio;
            if (out != null) {
                out.write(output.getBuffer(), 0, output.getBufferLength());
            }
        }
        this.bitstream.closeFrame();
        return true;
    }
}

