/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.hw.serialport;

import com.schott.let2.hw.serialport.ISerialPortConfiguration;
import com.schott.let2.hw.serialport.internal.SerialPortConfiguration;
import java.util.Comparator;

public abstract class ASerialPortConfiguration
implements ISerialPortConfiguration {
    protected String configName;
    protected int baudRate = 57600;
    protected int dataBits = 8;
    protected float stopBits = 1.0f;
    protected int parity = 0;
    protected int flowControl = 0;
    public static Comparator<ISerialPortConfiguration> SORTBY_BAUDRATE = new Comparator<ISerialPortConfiguration>(){

        @Override
        public int compare(ISerialPortConfiguration config1, ISerialPortConfiguration config2) {
            if (config1.getBaudRate() > config2.getBaudRate()) {
                return 1;
            }
            if (config1.getBaudRate() < config2.getBaudRate()) {
                return -1;
            }
            return 0;
        }
    };

    public ASerialPortConfiguration() {
        this.updateConfigName();
    }

    @Override
    public int getBitsPerByte() {
        int numBitsPerByte = 0;
        ++numBitsPerByte;
        switch (this.dataBits) {
            case 7: {
                numBitsPerByte += 7;
                break;
            }
            case 8: {
                numBitsPerByte += 8;
                break;
            }
        }
        switch (this.parity) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                ++numBitsPerByte;
                break;
            }
        }
        numBitsPerByte = this.stopBits == 1.0f ? ++numBitsPerByte : (numBitsPerByte += 2);
        return numBitsPerByte;
    }

    private void updateConfigName() {
        this.configName = "";
        this.configName = String.valueOf(this.configName) + Integer.toString(this.baudRate) + "bd ";
        this.configName = String.valueOf(this.configName) + Integer.toString(this.dataBits);
        switch (this.parity) {
            case 0: {
                this.configName = String.valueOf(this.configName) + "n";
                break;
            }
            case 1: {
                this.configName = String.valueOf(this.configName) + "o";
                break;
            }
            case 2: {
                this.configName = String.valueOf(this.configName) + "e";
                break;
            }
            case 3: {
                this.configName = String.valueOf(this.configName) + "m";
                break;
            }
            case 4: {
                this.configName = String.valueOf(this.configName) + "s";
                break;
            }
        }
        this.configName = this.stopBits == 1.0f ? String.valueOf(this.configName) + "1" : (this.stopBits == 1.5f ? String.valueOf(this.configName) + "1.5" : String.valueOf(this.configName) + "2");
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public boolean setBaudRate(int baudRate) {
        if (baudRate <= 0) {
            return false;
        }
        this.baudRate = baudRate;
        this.updateConfigName();
        return true;
    }

    @Override
    public int getBaudRate() {
        return this.baudRate;
    }

    @Override
    public boolean setDataBits(int bits) {
        switch (bits) {
            case 7: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        this.dataBits = bits;
        this.updateConfigName();
        return true;
    }

    @Override
    public int getDataBits() {
        return this.dataBits;
    }

    @Override
    public boolean setParity(int parity) {
        switch (parity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        this.parity = parity;
        this.updateConfigName();
        return true;
    }

    @Override
    public int getParity() {
        return this.parity;
    }

    @Override
    public boolean setStopBits(float stopBits) {
        if (stopBits != 1.0f && stopBits != 1.5f && stopBits != 2.0f) {
            return false;
        }
        this.stopBits = stopBits;
        this.updateConfigName();
        return true;
    }

    @Override
    public float getStopBits() {
        return this.stopBits;
    }

    @Override
    public boolean setFlowControl(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        this.flowControl = type;
        this.updateConfigName();
        return true;
    }

    @Override
    public int getFlowControl() {
        return this.flowControl;
    }

    public static ISerialPortConfiguration createConfiguration() {
        return new SerialPortConfiguration();
    }

    public static ISerialPortConfiguration copyConfiguration(ISerialPortConfiguration original) {
        if (original == null) {
            return null;
        }
        ISerialPortConfiguration copy = ASerialPortConfiguration.createConfigurationFromName(original.getConfigName());
        copy.setFlowControl(original.getFlowControl());
        return copy;
    }

    public static ISerialPortConfiguration createConfigurationFromName(String configName) {
        if (configName == null) {
            return null;
        }
        if (configName.isEmpty()) {
            return null;
        }
        if (configName.equals("N/A")) {
            return null;
        }
        try {
            double baudrate = 0.0;
            int idx = configName.indexOf("bd ");
            String buf = configName.substring(0, idx);
            baudrate = Double.parseDouble(buf);
            buf = configName.substring(idx + 3, idx + 4);
            int databits = Integer.parseInt(buf);
            int parity = 0;
            buf = configName.substring(idx + 4, idx + 5);
            if (buf.equals("n")) {
                parity = 0;
            } else if (buf.equals("o")) {
                parity = 1;
            } else if (buf.equals("e")) {
                parity = 2;
            } else if (buf.equals("m")) {
                parity = 3;
            } else if (buf.equals("s")) {
                parity = 4;
            }
            float stopbits = 0.0f;
            buf = configName.substring(idx + 5, configName.length());
            stopbits = Float.parseFloat(buf);
            SerialPortConfiguration config = new SerialPortConfiguration();
            config.setBaudRate((int)baudrate);
            config.setDataBits(databits);
            config.setStopBits(stopbits);
            config.setParity(parity);
            config.setFlowControl(0);
            return config;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String createConfigurationName(ISerialPortConfiguration config) {
        if (config == null) {
            return "N/A";
        }
        return config.getConfigName();
    }

    public static int parseParityName(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals(S_PARITY_NONE)) {
            return 0;
        }
        if (name.equals(S_PARITY_ODD)) {
            return 1;
        }
        if (name.equals(S_PARITY_EVEN)) {
            return 2;
        }
        if (name.equals(S_PARITY_MARK)) {
            return 3;
        }
        if (name.equals(S_PARITY_SPACE)) {
            return 4;
        }
        return -1;
    }

    public static String parityToName(int parity) {
        switch (parity) {
            case 0: {
                return S_PARITY_NONE;
            }
            case 1: {
                return S_PARITY_ODD;
            }
            case 2: {
                return S_PARITY_EVEN;
            }
            case 3: {
                return S_PARITY_MARK;
            }
            case 4: {
                return S_PARITY_SPACE;
            }
        }
        return "N/A";
    }

    public static boolean isSettingEqual(ISerialPortConfiguration config1, ISerialPortConfiguration config2) {
        if (config1 != null && config2 != null) {
            if (!config1.getConfigName().equals(config2.getConfigName())) {
                return false;
            }
            return config1.getFlowControl() == config2.getFlowControl();
        }
        return false;
    }
}

