/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.hw.serialport;

import com.schott.let2.hw.serialport.ASerialPortConfiguration;
import com.schott.let2.hw.serialport.ISerialPort;
import com.schott.let2.hw.serialport.ISerialPortConfiguration;
import com.schott.let2.util.data.type.TypeUtil;
import com.schott.let2.util.debug.DebugSupport;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class ASerialPort
extends DebugSupport
implements ISerialPort {
    private static final String UNKNOWN_PORTSOURCE = "UnknownSource";
    private static final String UNKNOWN_DEVICESN = "UnknownName";
    private static final long DELAY_BEFOREREAD_MIN = 2L;
    private String portSourceName = null;
    private String portDeviceSerialNumber = null;
    private String portDeviceDescription = null;
    private String DEBUG_IDENTIFIER = null;
    private Object currentOwner = null;
    private boolean isLocked = false;
    private boolean isPortOpen = false;
    private ISerialPortConfiguration portConfiguration = null;
    private boolean isConfigApplied = false;
    private boolean isLoopBack = false;
    private boolean isTransmitTimeCorrection = false;

    public ASerialPort(String portSourceName, String portDeviceSerialNumber, String portDeviceDescription) {
        this.portSourceName = portSourceName;
        this.portDeviceSerialNumber = portDeviceSerialNumber;
        this.portDeviceDescription = portDeviceDescription;
        this.DEBUG_IDENTIFIER = this.portSourceName == null ? UNKNOWN_PORTSOURCE : this.portSourceName;
    }

    @Override
    public String getSourceName() {
        if (this.portSourceName == null) {
            this.portSourceName = UNKNOWN_PORTSOURCE;
        }
        return this.portSourceName;
    }

    @Override
    public String getSymbolicName() {
        if (this.portDeviceSerialNumber == null) {
            this.portDeviceSerialNumber = UNKNOWN_DEVICESN;
        }
        return this.portDeviceSerialNumber;
    }

    @Override
    public String getDescriptionName() {
        if (this.portDeviceDescription == null) {
            return "";
        }
        return this.portDeviceDescription;
    }

    @Override
    public String getDescriptiveName() {
        if (this.portDeviceSerialNumber == null) {
            this.portDeviceSerialNumber = UNKNOWN_DEVICESN;
        }
        if (this.portDeviceDescription != null) {
            return String.valueOf(this.portDeviceSerialNumber) + " (" + this.portDeviceDescription + ")";
        }
        return this.portDeviceSerialNumber;
    }

    @Override
    public String getAbsoluteSymbolicName() {
        if (this.portDeviceSerialNumber == null) {
            this.portDeviceSerialNumber = UNKNOWN_DEVICESN;
        }
        if (this.portSourceName == null) {
            this.portSourceName = UNKNOWN_PORTSOURCE;
        }
        return String.valueOf(this.portSourceName) + ":" + this.portDeviceSerialNumber;
    }

    @Override
    public String getAbsoluteDescriptiveName() {
        if (this.portDeviceSerialNumber == null) {
            this.portDeviceSerialNumber = UNKNOWN_DEVICESN;
        }
        if (this.portSourceName == null) {
            this.portSourceName = UNKNOWN_PORTSOURCE;
        }
        if (this.portDeviceDescription != null) {
            return String.valueOf(this.portSourceName) + ":" + this.portDeviceSerialNumber + " (" + this.portDeviceDescription + ")";
        }
        return String.valueOf(this.portSourceName) + ":" + this.portDeviceSerialNumber;
    }

    @Override
    public synchronized boolean lock(Object owner) {
        if (this.isLocked) {
            return false;
        }
        this.isLocked = true;
        this.currentOwner = owner;
        return this.isLocked;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public synchronized boolean unlock(Object owner) {
        if (owner != this.currentOwner) {
            return false;
        }
        this.currentOwner = null;
        this.isLocked = false;
        return true;
    }

    protected boolean isOwnerValid(Object owner) {
        if (owner == null) {
            return false;
        }
        return owner == this.currentOwner;
    }

    @Override
    public boolean isOpen() {
        return this.isPortOpen;
    }

    protected void setOpen() {
        this.isPortOpen = true;
    }

    @Override
    public boolean open(Object owner) {
        if (!this.isOwnerValid(owner)) {
            return false;
        }
        if (this.isOpen()) {
            return true;
        }
        this.isPortOpen = this.open();
        return this.isPortOpen;
    }

    protected abstract boolean open();

    @Override
    public boolean reset(Object owner) {
        if (!this.isOwnerValid(owner)) {
            return false;
        }
        if (!this.isOpen()) {
            return false;
        }
        return this.reset();
    }

    protected abstract boolean reset();

    @Override
    public boolean close(Object owner) {
        if (!this.isOwnerValid(owner)) {
            return false;
        }
        this.isPortOpen = !this.close();
        this.portConfiguration = null;
        this.isConfigApplied = false;
        return !this.isPortOpen;
    }

    protected abstract boolean close();

    @Override
    public ISerialPortConfiguration getConfiguration(Object owner) {
        return this.portConfiguration;
    }

    @Override
    public boolean isConfigurationApplied() {
        return this.isConfigApplied;
    }

    @Override
    public boolean applyConfiguration(Object owner, ISerialPortConfiguration input) {
        if (!this.isOwnerValid(owner)) {
            return false;
        }
        if (!this.isOpen()) {
            return false;
        }
        if (input == null) {
            return false;
        }
        if (ASerialPortConfiguration.isSettingEqual(input, this.portConfiguration)) {
            return true;
        }
        this.portConfiguration = ASerialPortConfiguration.copyConfiguration(input);
        this.isConfigApplied = this.applyConfiguration(this.portConfiguration);
        if (!this.isConfigApplied) {
            this.portConfiguration = null;
        }
        return this.isConfigApplied;
    }

    protected abstract boolean applyConfiguration(ISerialPortConfiguration var1);

    private boolean checkIOConditions(Object owner) {
        if (!this.isOwnerValid(owner)) {
            return false;
        }
        if (!this.isOpen()) {
            return false;
        }
        return this.isConfigurationApplied();
    }

    private boolean checkIOConditions(Object owner, ByteBuffer buffer) {
        if (buffer == null) {
            return false;
        }
        return this.checkIOConditions(owner);
    }

    @Override
    public synchronized int write(Object owner, ByteBuffer buffer) {
        int bytesTransmitted = -1;
        int bytesReceived = -1;
        bytesTransmitted = this.writeInternal(owner, buffer);
        if (bytesTransmitted > 0 && this.isLoopBack()) {
            try {
                ByteBuffer rxData = ByteBuffer.allocate(bytesTransmitted);
                bytesReceived = this.read(owner, rxData, bytesTransmitted, 100L);
                if (bytesTransmitted != bytesReceived) {
                    this.printDebug("Loopback not successfully received!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bytesTransmitted;
    }

    public synchronized int writeInternal(Object owner, ByteBuffer buffer) {
        int bytesTransmitted = -1;
        if (!this.checkIOConditions(owner, buffer)) {
            return bytesTransmitted;
        }
        buffer.compact();
        buffer.flip();
        bytesTransmitted = this.write(buffer);
        if (bytesTransmitted > 0) {
            buffer.position(bytesTransmitted);
            buffer.compact();
            if (this.isTransmitTimeCorrection()) {
                this.waitForCompletedTransmission(bytesTransmitted);
            }
            this.printDebug("Out >> " + TypeUtil.byteBufferToHexString((ByteBuffer)buffer, (int)bytesTransmitted));
        }
        return bytesTransmitted;
    }

    protected abstract int write(ByteBuffer var1);

    private void waitForCompletedTransmission(int numBytes) {
        long durationInNS = ASerialPort.getTransmissionTimeInNS(numBytes, this.portConfiguration);
        long timeInNS = System.nanoTime();
        while (System.nanoTime() - timeInNS < durationInNS) {
        }
    }

    public static long getTransmissionTimeInNS(int numBytes, ISerialPortConfiguration portConfiguration) {
        long numBits = numBytes * portConfiguration.getBitsPerByte();
        long durationInNS = numBits * 1000000000L / (long)portConfiguration.getBaudRate();
        return durationInNS;
    }

    public static long getTransmissionTimeInUS(int numBytes, ISerialPortConfiguration portConfiguration) {
        return ASerialPort.getTransmissionTimeInNS(numBytes, portConfiguration) / 1000L;
    }

    public static long getTransmissionTimeInMS(int numBytes, ISerialPortConfiguration portConfiguration) {
        return ASerialPort.getTransmissionTimeInUS(numBytes, portConfiguration) / 1000L;
    }

    @Override
    public synchronized int read(Object owner, ByteBuffer buffer) {
        int bytesReceived = -1;
        if (!this.checkIOConditions(owner, buffer)) {
            return bytesReceived;
        }
        buffer.clear();
        bytesReceived = this.read(buffer);
        if (bytesReceived > 0) {
            buffer.flip();
            this.printDebug("In << " + TypeUtil.byteBufferToHexString((ByteBuffer)buffer, (int)bytesReceived));
        }
        return bytesReceived;
    }

    protected abstract int read(ByteBuffer var1);

    @Override
    public synchronized int read(Object owner, ByteBuffer buffer, long timeout) {
        int bytesReceived = -1;
        if (!this.checkIOConditions(owner, buffer)) {
            return bytesReceived;
        }
        buffer.clear();
        bytesReceived = this.read(buffer, timeout);
        if (bytesReceived > 0) {
            buffer.flip();
            this.printDebug("In << " + TypeUtil.byteBufferToHexString((ByteBuffer)buffer, (int)bytesReceived));
        }
        return bytesReceived;
    }

    protected abstract int read(ByteBuffer var1, long var2);

    @Override
    public synchronized int read(Object owner, ByteBuffer buffer, int numBytesToReceive, long timeout) {
        int bytesReceived = -1;
        if (!this.checkIOConditions(owner, buffer)) {
            return bytesReceived;
        }
        buffer.clear();
        bytesReceived = this.read(buffer, numBytesToReceive, timeout);
        if (bytesReceived > 0) {
            buffer.flip();
            this.printDebug("In << " + TypeUtil.byteBufferToHexString((ByteBuffer)buffer, (int)bytesReceived));
        }
        return bytesReceived;
    }

    protected abstract int read(ByteBuffer var1, int var2, long var3);

    @Override
    public synchronized int read(Object owner, ByteBuffer buffer, byte terminator, long timeout) {
        int bytesReceived = -1;
        if (!this.checkIOConditions(owner, buffer)) {
            return bytesReceived;
        }
        buffer.clear();
        bytesReceived = this.read(buffer, terminator, timeout);
        if (bytesReceived > 0) {
            buffer.flip();
            this.printDebug("In << " + TypeUtil.byteBufferToHexString((ByteBuffer)buffer, (int)bytesReceived));
        }
        return bytesReceived;
    }

    protected abstract int read(ByteBuffer var1, byte var2, long var3);

    @Override
    public synchronized int[] writeAndRead(Object owner, ByteBuffer txBuffer, ByteBuffer rxBuffer, long delayBeforeRead) {
        int[] bytesTransmittedAndReceived = new int[]{-1, -1};
        bytesTransmittedAndReceived[0] = this.write(owner, txBuffer);
        if (bytesTransmittedAndReceived[0] >= 0) {
            if (delayBeforeRead < 2L) {
                delayBeforeRead = 2L;
            }
            try {
                Thread.sleep(delayBeforeRead);
            }
            catch (InterruptedException interruptedException) {}
            bytesTransmittedAndReceived[1] = this.read(owner, rxBuffer);
        }
        return bytesTransmittedAndReceived;
    }

    @Override
    public synchronized int[] writeAndRead(Object owner, ByteBuffer txBuffer, ByteBuffer rxBuffer, long timeout, long delayBeforeRead) {
        int[] bytesTransmittedAndReceived = new int[]{-1, -1};
        bytesTransmittedAndReceived[0] = this.write(owner, txBuffer);
        if (bytesTransmittedAndReceived[0] >= 0) {
            if (delayBeforeRead < 2L) {
                delayBeforeRead = 2L;
            }
            try {
                Thread.sleep(delayBeforeRead);
            }
            catch (InterruptedException interruptedException) {}
            bytesTransmittedAndReceived[1] = this.read(owner, rxBuffer, timeout);
        }
        return bytesTransmittedAndReceived;
    }

    @Override
    public synchronized int[] writeAndRead(Object owner, ByteBuffer txBuffer, ByteBuffer rxBuffer, int numBytesToReceive, long timeout, long delayBeforeRead) {
        int[] bytesTransmittedAndReceived = new int[]{-1, -1};
        bytesTransmittedAndReceived[0] = this.write(owner, txBuffer);
        if (bytesTransmittedAndReceived[0] >= 0) {
            if (delayBeforeRead < 2L) {
                delayBeforeRead = 2L;
            }
            try {
                Thread.sleep(delayBeforeRead);
            }
            catch (InterruptedException interruptedException) {}
            bytesTransmittedAndReceived[1] = this.read(owner, rxBuffer, numBytesToReceive, timeout);
        }
        return bytesTransmittedAndReceived;
    }

    @Override
    public synchronized int[] writeAndRead(Object owner, ByteBuffer txBuffer, ByteBuffer rxBuffer, byte terminator, long timeout, long delayBeforeRead) {
        int[] bytesTransmittedAndReceived = new int[]{-1, -1};
        bytesTransmittedAndReceived[0] = this.write(owner, txBuffer);
        if (bytesTransmittedAndReceived[0] >= 0) {
            if (delayBeforeRead < 2L) {
                delayBeforeRead = 2L;
            }
            try {
                Thread.sleep(delayBeforeRead);
            }
            catch (InterruptedException interruptedException) {}
            bytesTransmittedAndReceived[1] = this.read(owner, rxBuffer, terminator, timeout);
        }
        return bytesTransmittedAndReceived;
    }

    @Override
    public boolean setRTS(Object owner, boolean isHigh) {
        if (!this.checkIOConditions(owner)) {
            return false;
        }
        return this.setRTS(isHigh);
    }

    protected abstract boolean setRTS(boolean var1);

    @Override
    public boolean setDTR(Object owner, boolean isHigh) {
        if (!this.checkIOConditions(owner)) {
            return false;
        }
        return this.setDTR(isHigh);
    }

    protected abstract boolean setDTR(boolean var1);

    @Override
    public boolean isCTS(Object owner) throws IOException {
        if (!this.checkIOConditions(owner)) {
            throw new IOException("I/O Error");
        }
        try {
            return this.isCTS();
        }
        catch (Exception exception) {
            throw new IOException("I/O Error");
        }
    }

    protected abstract boolean isCTS() throws Exception;

    @Override
    public boolean isDSR(Object owner) throws IOException {
        if (!this.checkIOConditions(owner)) {
            throw new IOException("I/O Error");
        }
        try {
            return this.isDSR();
        }
        catch (Exception exception) {
            throw new IOException("I/O Error");
        }
    }

    protected abstract boolean isDSR() throws Exception;

    @Override
    public boolean isRI(Object owner) throws IOException {
        if (!this.checkIOConditions(owner)) {
            throw new IOException("I/O Error");
        }
        try {
            return this.isRI();
        }
        catch (Exception exception) {
            throw new IOException("I/O Error");
        }
    }

    protected abstract boolean isRI() throws Exception;

    @Override
    public boolean isDCD(Object owner) throws IOException {
        if (!this.checkIOConditions(owner)) {
            throw new IOException("I/O Error");
        }
        try {
            return this.isDCD();
        }
        catch (Exception exception) {
            throw new IOException("I/O Error");
        }
    }

    protected abstract boolean isDCD() throws Exception;

    @Override
    public boolean isLoopBack() {
        return this.isLoopBack;
    }

    @Override
    public void setLoopBack(boolean isLoopBack) {
        this.isLoopBack = isLoopBack;
    }

    @Override
    public boolean isFrameOutput() {
        return this.isDebug();
    }

    @Override
    public void setFrameOutput(boolean isFrameOutput) {
        this.setDebugOutput(false, isFrameOutput, this.DEBUG_IDENTIFIER);
    }

    @Override
    public boolean isTransmitTimeCorrection() {
        return this.isTransmitTimeCorrection;
    }

    @Override
    public void setTransmitTimeCorrection(boolean isTransmitTimeCorrection) {
        this.isTransmitTimeCorrection = isTransmitTimeCorrection;
    }
}

