/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.ExceptionConst;
import com.sun.org.apache.bcel.internal.generic.AllocationInstruction;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.ExceptionThrower;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.StackProducer;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private byte type;

    NEWARRAY() {
    }

    public NEWARRAY(byte type) {
        super((short)188, (short)2);
        this.type = type;
    }

    public NEWARRAY(BasicType type) {
        this(type.getType());
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(super.getOpcode());
        out.writeByte(this.type);
    }

    public final byte getTypecode() {
        return this.type;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    @Override
    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + Const.getTypeName(this.type);
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.type = bytes.readByte();
        super.setLength(2);
    }

    @Override
    public Class<?>[] getExceptions() {
        return new Class[]{ExceptionConst.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    @Override
    public void accept(Visitor v) {
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitStackProducer(this);
        v.visitNEWARRAY(this);
    }
}

