/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.CPInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.LoadClass;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.Type;

public abstract class FieldOrMethod
extends CPInstruction
implements LoadClass {
    FieldOrMethod() {
    }

    protected FieldOrMethod(short opcode, int index) {
        super(opcode, index);
    }

    public String getSignature(ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
    }

    public String getName(ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return ((ConstantUtf8)cp.getConstant(cnat.getNameIndex())).getBytes();
    }

    @Deprecated
    public String getClassName(ConstantPoolGen cpg) {
        ConstantCP cmr;
        ConstantPool cp = cpg.getConstantPool();
        String className = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(super.getIndex())).getClassIndex(), (byte)7);
        if (className.startsWith("[")) {
            return "java.lang.Object";
        }
        return className.replace('/', '.');
    }

    @Deprecated
    public ObjectType getClassType(ConstantPoolGen cpg) {
        return ObjectType.getInstance(this.getClassName(cpg));
    }

    public ReferenceType getReferenceType(ConstantPoolGen cpg) {
        ConstantCP cmr;
        ConstantPool cp = cpg.getConstantPool();
        String className = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(super.getIndex())).getClassIndex(), (byte)7);
        if (className.startsWith("[")) {
            return (ArrayType)Type.getType(className);
        }
        className = className.replace('/', '.');
        return ObjectType.getInstance(className);
    }

    @Override
    public ObjectType getLoadClassType(ConstantPoolGen cpg) {
        ReferenceType rt = this.getReferenceType(cpg);
        if (rt instanceof ObjectType) {
            return (ObjectType)rt;
        }
        throw new ClassGenException(rt.getClass().getCanonicalName() + " " + rt.getSignature() + " does not represent an ObjectType");
    }
}

