/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.nls.service;

import com.schott.let2.util.debug.DebugSupport;
import com.schott.let2.util.nls.locale.LocaleEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class NLS_Support {
    public static boolean IS_DEBUG = true;
    protected static final String DEBUG_IDENTIFIER = "NLS Support";
    private static NLS_Support INSTANCE = null;
    public static final int NONE = -1;
    public static final int LOCALE_EN = 1000;
    private static final String SLOCALE_EN = "en";
    public static final int LOCALE_DE = 2000;
    private static final String SLOCALE_DE = "de";
    public static final int LOCALE_CS = 3000;
    private static final String SLOCALE_CS = "cs";
    public static final int LOCALE_ES = 4000;
    private static final String SLOCALE_ES = "es";
    private int activeLocalCode = -1;
    private List<LocaleEntry> localeLibrary = new ArrayList<LocaleEntry>();
    public static final String PREF_ID = NLS_Support.class.getName();
    private static IEclipsePreferences instancePrefNode;
    private static final String PREF_LOCALE = "Locale";
    public static final int DEF_LOCALE = 1000;

    public static void debug(String msg) {
        if (IS_DEBUG) {
            DebugSupport.printDebugConsole((String)DEBUG_IDENTIFIER, (String)msg);
        }
    }

    private static void createInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NLS_Support();
        }
    }

    public static NLS_Support getInstance() {
        NLS_Support.createInstance();
        return INSTANCE;
    }

    public static void disposeInstance() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    public static boolean isLocaleSupported(int localeCode) {
        switch (localeCode) {
            case 1000: 
            case 2000: 
            case 3000: 
            case 4000: {
                return true;
            }
        }
        return false;
    }

    public static String localeTypeToSpecifier(int localeCode) {
        switch (localeCode) {
            default: {
                return SLOCALE_EN;
            }
            case 2000: {
                return SLOCALE_DE;
            }
            case 3000: {
                return SLOCALE_CS;
            }
            case 4000: 
        }
        return SLOCALE_ES;
    }

    private NLS_Support() {
        this.loadSettings();
        Locale lEN = new Locale(NLS_Support.localeTypeToSpecifier(this.activeLocalCode));
        Locale.setDefault(lEN);
        System.setProperty("osgi.nl", NLS_Support.localeTypeToSpecifier(this.activeLocalCode));
        this.localeLibrary.add(new LocaleEntry(1000, SLOCALE_EN));
        this.localeLibrary.add(new LocaleEntry(2000, SLOCALE_DE));
        this.localeLibrary.add(new LocaleEntry(3000, SLOCALE_CS));
        this.localeLibrary.add(new LocaleEntry(4000, SLOCALE_ES));
    }

    public LocaleEntry getActiveLocale() {
        for (LocaleEntry entry : this.localeLibrary) {
            if (entry.getLocaleCode() != this.activeLocalCode) continue;
            return entry;
        }
        return null;
    }

    public LocaleEntry getLocale(int localCode) {
        for (LocaleEntry entry : this.localeLibrary) {
            if (entry.getLocaleCode() != localCode) continue;
            return entry;
        }
        return null;
    }

    public boolean setActiveLocale(int localCode) {
        for (LocaleEntry entry : this.localeLibrary) {
            if (entry.getLocaleCode() != localCode) continue;
            if (this.activeLocalCode != localCode) {
                LocaleEntry oldLocale = this.getActiveLocale();
                this.activeLocalCode = localCode;
                LocaleEntry newLocale = this.getActiveLocale();
                NLS_Support.debug("Locale change from '" + oldLocale.getLocaleSpecifier() + "' to '" + newLocale.getLocaleSpecifier() + "'...");
                if (this.saveSettings()) {
                    NLS_Support.debug("...successful!");
                    return true;
                }
                NLS_Support.debug("...failed!");
                continue;
            }
            LocaleEntry activeLocale = this.getActiveLocale();
            NLS_Support.debug("Locale is already configured to '" + activeLocale.getLocaleSpecifier() + "!");
        }
        return false;
    }

    private void dispose() {
        for (LocaleEntry entry : this.localeLibrary) {
            entry.dispose();
            Object var1_2 = null;
        }
        this.localeLibrary.clear();
        this.localeLibrary = null;
    }

    private boolean loadSettings() {
        if (instancePrefNode == null) {
            instancePrefNode = InstanceScope.INSTANCE.getNode(PREF_ID);
        }
        if (instancePrefNode == null) {
            return false;
        }
        try {
            instancePrefNode.sync();
            this.activeLocalCode = instancePrefNode.getInt(PREF_LOCALE, 1000);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean saveSettings() {
        if (instancePrefNode == null) {
            instancePrefNode = InstanceScope.INSTANCE.getNode(PREF_ID);
        }
        if (instancePrefNode == null) {
            return false;
        }
        try {
            instancePrefNode.putInt(PREF_LOCALE, this.activeLocalCode);
            instancePrefNode.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

