/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.json.util;

public class JSONUtil {
    public static final String NONE = "null";
    public static final String OBJ_START = "{";
    public static final String OBJ_END = "}";
    public static final String ARRAY_START = "[";
    public static final String ARRAY_END = "]";
    public static final String VALUE_START = ": ";
    public static final String VALUE_END = ",";
    public static final String VALUE_ESCAPE = "\"";
    public static String INDENTIATION = "    ";

    public static String indent(int level) {
        String s = "";
        int idx = 0;
        while (idx < level) {
            s = String.valueOf(s) + INDENTIATION;
            ++idx;
        }
        return s;
    }

    public static String addQuotes(String s) {
        return VALUE_ESCAPE + s + VALUE_ESCAPE;
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        JSONUtil.escape(s, sb);
        return sb.toString();
    }

    private static void escape(String s, StringBuffer sb) {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        int k = 0;
                        while (k < 4 - ss.length()) {
                            sb.append('0');
                            ++k;
                        }
                        sb.append(ss.toUpperCase());
                        break;
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
    }
}

