/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.ui.swt.serialport.setting;

import com.schott.let2.hw.serialport.ISerialPortConfiguration;
import com.schott.let2.ui.swt.controls.basic.PropertyComp;
import com.schott.let2.ui.swt.controls.value.Header;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConnectionSettingGUI
extends PropertyComp {
    public static final int PROP_ID_PORT = 0;
    public static final int PROP_ID_PORT_CONFIG = 1;
    public static final String PROP_CHANGE = "ConfigChanged";
    private Header lblHeader;
    private Label lblPort;
    private Combo comPort;
    private List<String> iPortList;
    private Label lblConfigBaud;
    private Combo comConfigBaud;
    private int[] configBaudList;
    private Label lblConfigData;
    private Combo comConfigData;
    private int[] configDataList;
    private Label lblConfigStop;
    private Combo comConfigStop;
    private float[] configStopList;
    private Label lblConfigParity;
    private Combo comConfigParity;
    private int[] configParityList;
    private String activePort;
    private ISerialPortConfiguration activeConfig;

    public ConnectionSettingGUI(Composite parent, int style, String header, String oldPort, List<String> portList, ISerialPortConfiguration oldPortConfig) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.activePort = oldPort;
        this.activeConfig = oldPortConfig;
        this.configBaudList = new int[8];
        this.configBaudList[0] = 9600;
        this.configBaudList[1] = 19200;
        this.configBaudList[2] = 38400;
        this.configBaudList[3] = 57600;
        this.configBaudList[4] = 115200;
        this.configBaudList[5] = 230400;
        this.configBaudList[6] = 460800;
        this.configBaudList[7] = 921600;
        this.configDataList = new int[2];
        this.configDataList[0] = 7;
        this.configDataList[1] = 8;
        this.configStopList = new float[3];
        this.configStopList[0] = 1.0f;
        this.configStopList[1] = 1.5f;
        this.configStopList[2] = 2.0f;
        this.configParityList = new int[5];
        this.configParityList[0] = 0;
        this.configParityList[1] = 1;
        this.configParityList[2] = 2;
        this.configParityList[3] = 3;
        this.configParityList[4] = 4;
        this.lblHeader = new Header((Composite)this, 0, header);
        this.lblHeader.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.lblHeader.setSize(200);
        this.lblPort = new Label((Composite)this, 0);
        this.lblPort.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblPort.setText("Serial Port:");
        this.comPort = new Combo((Composite)this, 12);
        this.comPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.iPortList = portList;
        int idxType = -1;
        int i = 0;
        while (i < this.iPortList.size()) {
            this.comPort.add(this.iPortList.get(i), i);
            if (this.activePort.matches(this.iPortList.get(i))) {
                idxType = i;
            }
            ++i;
        }
        this.comPort.select(idxType);
        this.comPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionSettingGUI.this.comPort.getSelectionIndex() != -1) {
                    ConnectionSettingGUI.this.activePort = (String)ConnectionSettingGUI.this.iPortList.get(ConnectionSettingGUI.this.comPort.getSelectionIndex());
                    ConnectionSettingGUI.this.firePropertyChange(ConnectionSettingGUI.PROP_CHANGE, 0, ConnectionSettingGUI.this.activePort);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblConfigBaud = new Label((Composite)this, 0);
        this.lblConfigBaud.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConfigBaud.setText("Baudrate [Bit/s]:");
        this.comConfigBaud = new Combo((Composite)this, 12);
        this.comConfigBaud.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        idxType = -1;
        i = 0;
        while (i < this.configBaudList.length) {
            this.comConfigBaud.add(Integer.toString(this.configBaudList[i]), i);
            if (this.activeConfig.getBaudRate() == this.configBaudList[i]) {
                idxType = i;
            }
            ++i;
        }
        this.comConfigBaud.select(idxType);
        this.comConfigBaud.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionSettingGUI.this.comConfigBaud.getSelectionIndex() != -1) {
                    ConnectionSettingGUI.this.activeConfig.setBaudRate(ConnectionSettingGUI.this.configBaudList[ConnectionSettingGUI.this.comConfigBaud.getSelectionIndex()]);
                    ConnectionSettingGUI.this.firePropertyChange(ConnectionSettingGUI.PROP_CHANGE, 1, ConnectionSettingGUI.this.activeConfig);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblConfigData = new Label((Composite)this, 0);
        this.lblConfigData.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConfigData.setText("Data Bits:");
        this.comConfigData = new Combo((Composite)this, 12);
        this.comConfigData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        idxType = -1;
        i = 0;
        while (i < this.configDataList.length) {
            this.comConfigData.add(Integer.toString(this.configDataList[i]), i);
            if (this.activeConfig.getDataBits() == this.configDataList[i]) {
                idxType = i;
            }
            ++i;
        }
        this.comConfigData.select(idxType);
        this.comConfigData.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionSettingGUI.this.comConfigData.getSelectionIndex() != -1) {
                    ConnectionSettingGUI.this.activeConfig.setDataBits(ConnectionSettingGUI.this.configDataList[ConnectionSettingGUI.this.comConfigData.getSelectionIndex()]);
                    ConnectionSettingGUI.this.firePropertyChange(ConnectionSettingGUI.PROP_CHANGE, 1, ConnectionSettingGUI.this.activeConfig);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblConfigStop = new Label((Composite)this, 0);
        this.lblConfigStop.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConfigStop.setText("Stop Bits:");
        this.comConfigStop = new Combo((Composite)this, 12);
        this.comConfigStop.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        idxType = -1;
        i = 0;
        while (i < this.configStopList.length) {
            this.comConfigStop.add(Float.toString(this.configStopList[i]), i);
            if (this.activeConfig.getStopBits() == this.configStopList[i]) {
                idxType = i;
            }
            ++i;
        }
        this.comConfigStop.select(idxType);
        this.comConfigStop.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionSettingGUI.this.comConfigStop.getSelectionIndex() != -1) {
                    ConnectionSettingGUI.this.activeConfig.setStopBits(ConnectionSettingGUI.this.configStopList[ConnectionSettingGUI.this.comConfigStop.getSelectionIndex()]);
                    ConnectionSettingGUI.this.firePropertyChange(ConnectionSettingGUI.PROP_CHANGE, 1, ConnectionSettingGUI.this.activeConfig);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblConfigParity = new Label((Composite)this, 0);
        this.lblConfigParity.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConfigParity.setText("Parity:");
        this.comConfigParity = new Combo((Composite)this, 12);
        this.comConfigParity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comConfigParity.add(ISerialPortConfiguration.S_PARITY_NONE, 0);
        this.comConfigParity.add(ISerialPortConfiguration.S_PARITY_ODD, 1);
        this.comConfigParity.add(ISerialPortConfiguration.S_PARITY_EVEN, 2);
        this.comConfigParity.add(ISerialPortConfiguration.S_PARITY_MARK, 3);
        this.comConfigParity.add(ISerialPortConfiguration.S_PARITY_SPACE, 4);
        idxType = -1;
        i = 0;
        while (i < this.configParityList.length) {
            if (this.activeConfig.getParity() == this.configParityList[i]) {
                idxType = i;
            }
            ++i;
        }
        this.comConfigParity.select(idxType);
        this.comConfigParity.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionSettingGUI.this.comConfigParity.getSelectionIndex() != -1) {
                    ConnectionSettingGUI.this.activeConfig.setParity(ConnectionSettingGUI.this.configParityList[ConnectionSettingGUI.this.comConfigParity.getSelectionIndex()]);
                    ConnectionSettingGUI.this.firePropertyChange(ConnectionSettingGUI.PROP_CHANGE, 1, ConnectionSettingGUI.this.activeConfig);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

