/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.debug;

import com.schott.let2.util.debug.IDebugSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Calendar;
import java.util.Date;

public abstract class DebugSupport
implements IDebugSupport {
    private PropertyChangeSupport debugChangeSupport = new PropertyChangeSupport(this);
    protected PropertyChangeListener debugForwardEventHandler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DebugSupport.this.forwardDebugEvent(evt);
        }
    };
    public static PropertyChangeListener debugConsoleEventHandler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof String) {
                System.out.println((String)evt.getNewValue());
            }
        }
    };
    private static final String POST_TIME = " / ";
    private static final String POST_IDENTIFIER = " >>> ";
    private boolean isDebug = false;
    private boolean isDebugEvent = false;
    private boolean isDebugConsole = false;
    private String sDebugIdentifier = null;

    @Override
    public void addDebugListener(PropertyChangeListener listener) {
        this.debugChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removeDebugListener(PropertyChangeListener listener) {
        this.debugChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addDebugListener(String propertyName, PropertyChangeListener listener) {
        this.debugChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removeDebugListener(String propertyName, PropertyChangeListener listener) {
        this.debugChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void fireDebugEvent(String debugMsgContent) {
        this.debugChangeSupport.firePropertyChange("DbgMsg", null, debugMsgContent);
    }

    private void forwardDebugEvent(PropertyChangeEvent evt) {
        this.debugChangeSupport.firePropertyChange(evt);
    }

    protected void setDebugOutput(boolean isDebugEvent, boolean isDebugConsole, String debugIdentifier) {
        this.isDebugEvent = isDebugEvent;
        this.isDebugConsole = isDebugConsole;
        this.sDebugIdentifier = debugIdentifier;
        this.isDebug = this.isDebugEvent || this.isDebugConsole;
        this.printDebug("Debug Output Activated");
    }

    protected void printDebug(String debugMsgContent) {
        if (this.isDebug) {
            String debugMsg = String.valueOf(DebugSupport.getDateString()) + POST_TIME;
            if (this.sDebugIdentifier != null && !this.sDebugIdentifier.isEmpty()) {
                debugMsg = String.valueOf(debugMsg) + this.sDebugIdentifier + POST_IDENTIFIER;
            }
            debugMsg = String.valueOf(debugMsg) + debugMsgContent;
            if (this.isDebugEvent) {
                this.fireDebugEvent(debugMsg);
            }
            if (this.isDebugConsole) {
                System.out.println(debugMsg);
            }
            Object var2_2 = null;
        }
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isDebugEvent() {
        return this.isDebugEvent;
    }

    public boolean isDebugConsole() {
        return this.isDebugConsole;
    }

    public static void printDebugConsole(String debugIdentifier, String debugMsgContent) {
        String debugMsg = String.valueOf(DebugSupport.getDateString()) + POST_TIME;
        if (debugIdentifier != null && !debugIdentifier.isEmpty()) {
            debugMsg = String.valueOf(debugMsg) + debugIdentifier + POST_IDENTIFIER;
        }
        debugMsg = String.valueOf(debugMsg) + debugMsgContent;
        System.out.println(debugMsg);
        debugMsg = null;
    }

    private static String getDateString() {
        Date d = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        String date = "";
        int buf = c.get(5);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ".";
        buf = c.get(2) + 1;
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ".";
        date = String.valueOf(date) + c.get(1) + " ";
        buf = c.get(11);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ":";
        buf = c.get(12);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        date = String.valueOf(date) + ":";
        buf = c.get(13);
        date = buf <= 9 ? String.valueOf(date) + "0" + buf : String.valueOf(date) + buf;
        d = null;
        return date;
    }
}

