/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.nls.support;

import com.schott.let2.util.nls.service.NLS_Support;
import com.schott.let2.util.nls.util.NLS_Util;

public abstract class AStringNLS {
    private transient String localeActive = NLS_Support.getInstance().getActiveLocale().getLocaleSpecifier();
    private transient String localeDefault = NLS_Support.localeTypeToSpecifier(1000);

    public AStringNLS(String defaultLocale) {
        this.localeDefault = defaultLocale;
    }

    public void setLocale(String locale, String defaultLocale) {
        this.localeActive = locale;
        this.localeDefault = defaultLocale;
        this.updateNLS();
    }

    public void setLocaleDefault(String defaultLocale) {
        this.localeDefault = defaultLocale;
        this.updateNLS();
    }

    public String getLocale() {
        return this.localeActive;
    }

    public String getLocaleDefault() {
        return this.localeDefault;
    }

    protected abstract void updateNLS();

    protected String fromStringNLS(String nlsString) {
        return this.fromStringNLS(nlsString, this.localeActive, true);
    }

    protected String fromStringNLS(String nlsString, String localeSpecifier) {
        return this.fromStringNLS(nlsString, localeSpecifier, true);
    }

    protected String fromStringNLS(String nlsString, String localeSpecifier, boolean isUseDefaultForNothing) {
        return NLS_Util.extractFromString(nlsString, localeSpecifier, isUseDefaultForNothing ? this.localeDefault : null);
    }

    protected String toStringNLS(String nlsString, String value) {
        return NLS_Util.addToString(nlsString, this.localeActive, value);
    }

    protected String toStringNLS(String nlsString, String value, String localeSpecifier) {
        return NLS_Util.addToString(nlsString, localeSpecifier, value);
    }
}

