/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.nls.locale;

import com.schott.let2.util.nls.locale.Z_NLS;
import java.util.Comparator;

public class LocaleEntry {
    private static final String SLOCALE_NONE = "N/A";
    private static final String SLOCALE_EN = Z_NLS.LocaleEntry_SLOCALE_EN;
    private static final String SLOCALE_DE = Z_NLS.LocaleEntry_SLOCALE_DE;
    private static final String SLOCALE_CS = Z_NLS.LocaleEntry_SLOCALE_CS;
    private static final String SLOCALE_ES = Z_NLS.LocaleEntry_SLOCALE_ES;
    private int localeCode = -1;
    private String localeName = null;
    private String localeSpecifier = null;
    public static Comparator<LocaleEntry> SORT_BY_NAME = new Comparator<LocaleEntry>(){

        @Override
        public int compare(LocaleEntry locale1, LocaleEntry locale2) {
            return locale1.getLocaleName().compareTo(locale2.getLocaleName());
        }
    };
    public static Comparator<LocaleEntry> SORT_BY_SPECIFIER = new Comparator<LocaleEntry>(){

        @Override
        public int compare(LocaleEntry locale1, LocaleEntry locale2) {
            return locale1.getLocaleSpecifier().compareTo(locale2.getLocaleSpecifier());
        }
    };

    public LocaleEntry(int localeCode, String localeSpecifier) {
        this.localeCode = localeCode;
        this.localeSpecifier = localeSpecifier;
        this.updateLocaleName();
    }

    private void updateLocaleName() {
        switch (this.localeCode) {
            case 1000: {
                this.localeName = SLOCALE_EN;
                break;
            }
            case 2000: {
                this.localeName = SLOCALE_DE;
                break;
            }
            case 3000: {
                this.localeName = SLOCALE_CS;
                break;
            }
            case 4000: {
                this.localeName = SLOCALE_ES;
                break;
            }
            default: {
                this.localeName = SLOCALE_NONE;
            }
        }
    }

    public void dispose() {
        if (this.localeName != null) {
            this.localeName = null;
        }
        if (this.localeSpecifier != null) {
            this.localeSpecifier = null;
        }
    }

    public int getLocaleCode() {
        return this.localeCode;
    }

    public String getLocaleName() {
        return this.localeName;
    }

    public String getLocaleSpecifier() {
        return this.localeSpecifier;
    }
}

