/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.file.raw;

import com.schott.let2.file.raw.RawException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class RawParser {
    private String filePath = null;
    private static final String UTF8_BOM_WR = "\ufeff";
    private static final String UTF8_BOM_R = "?";
    private boolean isWriteUTF8_Preamble = true;
    private boolean isWriteUTF8 = false;
    private String separator = ";";

    public RawParser() {
    }

    public RawParser(String filePath) {
        this.filePath = filePath;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isWriteUTF8_Preamble() {
        return this.isWriteUTF8_Preamble;
    }

    public void setWriteUTF8_Preamble(boolean isWriteUTF8_Preamble) {
        this.isWriteUTF8_Preamble = isWriteUTF8_Preamble;
    }

    public boolean isWriteUTF8() {
        return this.isWriteUTF8;
    }

    public void setWriteUTF8(boolean isWriteUTF8) {
        this.isWriteUTF8 = isWriteUTF8;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public List<String[]> readFile() throws RawException {
        ArrayList<String[]> readList;
        block7: {
            readList = new ArrayList<String[]>();
            if (this.filePath != null) {
                try {
                    FileReader file = new FileReader(this.filePath);
                    BufferedReader reader = new BufferedReader(file);
                    if (reader.ready()) {
                        String curLine = reader.readLine();
                        if (curLine != null && curLine.startsWith(UTF8_BOM_R)) {
                            curLine = curLine.substring(1);
                        }
                        while (curLine != null) {
                            readList.add(RawParser.fromLine(curLine, this.separator));
                            curLine = reader.readLine();
                        }
                        reader.close();
                        break block7;
                    }
                    reader.close();
                    throw new RawException("Stream is not ready!");
                }
                catch (FileNotFoundException e) {
                    throw new RawException(e.getMessage());
                }
                catch (IOException e) {
                    throw new RawException(e.getMessage());
                }
            }
            throw new RawException("File name not available!");
        }
        return readList;
    }

    public List<String> readFileRaw() throws RawException {
        ArrayList<String> readList;
        block7: {
            readList = new ArrayList<String>();
            if (this.filePath != null) {
                try {
                    FileReader file = new FileReader(this.filePath);
                    BufferedReader reader = new BufferedReader(file);
                    if (reader.ready()) {
                        String curLine = reader.readLine();
                        if (curLine != null && curLine.startsWith(UTF8_BOM_R)) {
                            curLine = curLine.substring(1);
                        }
                        while (curLine != null) {
                            readList.add(curLine);
                            curLine = reader.readLine();
                        }
                        reader.close();
                        break block7;
                    }
                    reader.close();
                    throw new RawException("Stream is not ready!");
                }
                catch (FileNotFoundException e) {
                    throw new RawException(e.getMessage());
                }
                catch (IOException e) {
                    throw new RawException(e.getMessage());
                }
            }
            throw new RawException("File name not available!");
        }
        return readList;
    }

    private static String[] fromLine(String curLine, String separator) {
        StringTokenizer st = new StringTokenizer(curLine, separator);
        String[] args = new String[st.countTokens()];
        int idx = 0;
        while (st.hasMoreTokens()) {
            args[idx] = st.nextToken();
            ++idx;
        }
        return args;
    }

    public void writeFile(List<String[]> fileInput, String fileExtension) throws RawException {
        String curLine = null;
        if (this.filePath != null) {
            this.filePath = this.filePath.replace(fileExtension, "");
            this.filePath = String.valueOf(this.filePath) + fileExtension;
            boolean isFilePathOK = false;
            File f = null;
            try {
                f = new File(this.filePath);
                if (f.exists()) {
                    if (f.isFile()) {
                        isFilePathOK = true;
                    }
                } else if (f.isAbsolute() && (isFilePathOK = !f.getParentFile().exists() ? f.getParentFile().mkdirs() : f.getParentFile().isDirectory())) {
                    isFilePathOK = f.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isFilePathOK) {
                throw new RawException("File cannot be found and cannot be created!");
            }
            try {
                OutputStreamWriter file;
                BufferedWriter writer = null;
                if (this.isWriteUTF8) {
                    file = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
                    writer = new BufferedWriter(file);
                } else {
                    file = new FileWriter(f);
                    writer = new BufferedWriter(file);
                }
                if (this.isWriteUTF8_Preamble) {
                    writer.write(UTF8_BOM_WR);
                }
                int i = 0;
                while (i < fileInput.size()) {
                    String[] args = fileInput.get(i);
                    curLine = RawParser.toLine(args, this.separator);
                    writer.write(curLine);
                    if (i != fileInput.size() - 1) {
                        writer.newLine();
                    }
                    ++i;
                }
                writer.close();
            }
            catch (FileNotFoundException e) {
                throw new RawException(e.getMessage());
            }
            catch (IOException e) {
                throw new RawException(e.getMessage());
            }
        }
        throw new RawException("File name not available!");
    }

    public void appendFile(List<String[]> fileInput) throws RawException {
        String curLine = null;
        if (this.filePath != null) {
            boolean isFilePathOK = false;
            File f = null;
            try {
                f = new File(this.filePath);
                if (f.exists()) {
                    if (f.isFile()) {
                        isFilePathOK = true;
                    }
                } else if (f.isAbsolute() && (isFilePathOK = !f.getParentFile().exists() ? f.getParentFile().mkdirs() : f.getParentFile().isDirectory())) {
                    isFilePathOK = f.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isFilePathOK) {
                throw new RawException("File cannot be found and cannot be created!");
            }
            try {
                OutputStreamWriter file;
                BufferedWriter writer = null;
                if (this.isWriteUTF8) {
                    file = new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), StandardCharsets.UTF_8);
                    writer = new BufferedWriter(file);
                } else {
                    file = new FileWriter(f, true);
                    writer = new BufferedWriter(file);
                }
                writer.newLine();
                int i = 0;
                while (i < fileInput.size()) {
                    String[] args = fileInput.get(i);
                    curLine = RawParser.toLine(args, this.separator);
                    writer.write(curLine);
                    if (i != fileInput.size() - 1) {
                        writer.newLine();
                    }
                    ++i;
                }
                writer.close();
            }
            catch (FileNotFoundException e) {
                throw new RawException(e.getMessage());
            }
            catch (IOException e) {
                throw new RawException(e.getMessage());
            }
        }
        throw new RawException("File name not available!");
    }

    public void writeFileRaw(List<String> fileInput, String fileExtension) throws RawException {
        String curLine = null;
        if (this.filePath != null) {
            this.filePath = this.filePath.replace(fileExtension, "");
            this.filePath = String.valueOf(this.filePath) + fileExtension;
            boolean isFilePathOK = false;
            File f = null;
            try {
                f = new File(this.filePath);
                if (f.exists()) {
                    if (f.isFile()) {
                        isFilePathOK = true;
                    }
                } else if (f.isAbsolute() && (isFilePathOK = !f.getParentFile().exists() ? f.getParentFile().mkdirs() : f.getParentFile().isDirectory())) {
                    isFilePathOK = f.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isFilePathOK) {
                throw new RawException("File cannot be found and cannot be created!");
            }
            try {
                OutputStreamWriter file;
                BufferedWriter writer = null;
                if (this.isWriteUTF8) {
                    file = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
                    writer = new BufferedWriter(file);
                } else {
                    file = new FileWriter(f);
                    writer = new BufferedWriter(file);
                }
                if (this.isWriteUTF8_Preamble) {
                    writer.write(UTF8_BOM_WR);
                }
                int i = 0;
                while (i < fileInput.size()) {
                    curLine = fileInput.get(i);
                    writer.write(curLine);
                    if (i != fileInput.size() - 1) {
                        writer.newLine();
                    }
                    ++i;
                }
                writer.close();
            }
            catch (FileNotFoundException e) {
                throw new RawException(e.getMessage());
            }
            catch (IOException e) {
                throw new RawException(e.getMessage());
            }
        }
        throw new RawException("File name not available!");
    }

    public void appendFileRaw(List<String> fileInput) throws RawException {
        String curLine = null;
        if (this.filePath != null) {
            boolean isFilePathOK = false;
            File f = null;
            try {
                f = new File(this.filePath);
                if (f.exists()) {
                    if (f.isFile()) {
                        isFilePathOK = true;
                    }
                } else if (f.isAbsolute() && (isFilePathOK = !f.getParentFile().exists() ? f.getParentFile().mkdirs() : f.getParentFile().isDirectory())) {
                    isFilePathOK = f.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isFilePathOK) {
                throw new RawException("File cannot be found and cannot be created!");
            }
            try {
                OutputStreamWriter file;
                BufferedWriter writer = null;
                if (this.isWriteUTF8) {
                    file = new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), StandardCharsets.UTF_8);
                    writer = new BufferedWriter(file);
                } else {
                    file = new FileWriter(f, true);
                    writer = new BufferedWriter(file);
                }
                writer.newLine();
                int i = 0;
                while (i < fileInput.size()) {
                    curLine = fileInput.get(i);
                    writer.write(curLine);
                    if (i != fileInput.size() - 1) {
                        writer.newLine();
                    }
                    ++i;
                }
                writer.close();
            }
            catch (FileNotFoundException e) {
                throw new RawException(e.getMessage());
            }
            catch (IOException e) {
                throw new RawException(e.getMessage());
            }
        }
        throw new RawException("File name not available!");
    }

    private static String toLine(String[] args, String separator) {
        String curLine = "";
        if (args.length > 0) {
            curLine = String.valueOf(args[0]) + separator;
        }
        int j = 1;
        while (j < args.length) {
            curLine = j == args.length - 1 ? String.valueOf(curLine) + args[j] : String.valueOf(curLine) + args[j] + separator;
            ++j;
        }
        return curLine;
    }
}

