/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.data.value;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Random;

public class ValueUtil {
    private static Random valueGenerator = new Random(System.currentTimeMillis());

    public static boolean isInTolerance(double min, double max, double value) {
        return !(value > max) && !(value < min);
    }

    public static boolean isInTolerance(int min, int max, int value) {
        return value <= max && value >= min;
    }

    public static boolean isInTolerance(long min, long max, long value) {
        return value <= max && value >= min;
    }

    public static boolean isInTolerance(boolean soll, boolean value) {
        return soll == value;
    }

    public static double generateValue(double min, double max) {
        return valueGenerator.nextDouble() * (max - min) + min;
    }

    public static float generateValue(float min, float max) {
        return (float)(valueGenerator.nextDouble() * (double)(max - min)) + min;
    }

    public static int generateValue(int min, int max) {
        return (int)(valueGenerator.nextDouble() * (double)(max - min)) + min;
    }

    public static long generateValue(long min, long max) {
        return (long)(valueGenerator.nextDouble() * (double)(max - min)) + min;
    }

    public static double getLinearInterpolatedX(double x1, double y1, double x2, double y2, double y) throws Exception {
        if (x1 == x2) {
            throw new Exception("x1==x2");
        }
        double m = (y2 - y1) / (x2 - x1);
        double n = y2 - m * x2;
        return (y - n) / m;
    }

    public static double getLinearInterpolatedY(double x1, double y1, double x2, double y2, double x) throws Exception {
        if (x1 == x2) {
            throw new Exception("x1==x2");
        }
        double m = (y2 - y1) / (x2 - x1);
        double n = y2 - m * x2;
        return m * x + n;
    }

    public static boolean roundDoubles(List<Double> values, int digits) {
        if (values == null) {
            return false;
        }
        int idx = 0;
        while (idx < values.size()) {
            double value = ValueUtil.roundDouble(values.get(idx), digits);
            values.set(idx, value);
            ++idx;
        }
        return true;
    }

    public static double roundDouble(double value, int digits) {
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(digits, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static String doubleToString(double value, int digits) {
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        try {
            DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            df.setMinimumFractionDigits(digits);
            df.setMaximumFractionDigits(digits);
            return df.format(value);
        }
        catch (Exception exception) {
            return Double.toString(value);
        }
    }

    public static int getFirstSignificantDigit(double value) {
        block8: {
            String[] sValueSplit;
            block9: {
                if (Double.isNaN(value)) {
                    value = 0.0;
                }
                DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                df.setMaximumFractionDigits(340);
                String sValue = df.format(value);
                if (sValue.startsWith("-")) {
                    sValue = sValue.replaceFirst("-", "");
                }
                if ((sValueSplit = sValue.split("\\."))[0].length() > 1) {
                    return sValueSplit[0].length();
                }
                if (!sValueSplit[0].startsWith("0")) break block8;
                if (!sValueSplit[1].startsWith("0") || sValueSplit[1].length() != 1) break block9;
                return 0;
            }
            try {
                int fIdx = -1;
                int iStart = 0;
                do {
                    if (!sValueSplit[1].substring(iStart, iStart + 1).equals("0")) {
                        return fIdx;
                    }
                    --fIdx;
                } while (++iStart + 1 <= sValueSplit[1].length());
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 1;
    }

    public static int getPrecision(double value) {
        String[] sValueSplit;
        block5: {
            if (Double.isNaN(value)) {
                value = 0.0;
            }
            try {
                DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                df.setMaximumFractionDigits(340);
                String sValue = df.format(value);
                if (sValue.startsWith("-")) {
                    sValue = sValue.replaceFirst("-", "");
                }
                if (!(sValueSplit = sValue.split("\\."))[1].startsWith("0") || sValueSplit[1].length() != 1) break block5;
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return sValueSplit[1].length();
    }

    public static int getFirstSignificantDecadeFactor(int firstSignificantDigit) {
        block9: {
            try {
                if (firstSignificantDigit != 0) break block9;
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        boolean isNeg = false;
        if (firstSignificantDigit < 0) {
            firstSignificantDigit *= -1;
            isNeg = true;
        }
        int iFactor = firstSignificantDigit / 3;
        if (isNeg) {
            if (firstSignificantDigit % 3 > 0) {
                ++iFactor;
            }
        } else if (firstSignificantDigit % 3 == 0) {
            --iFactor;
        }
        if (!isNeg) {
            iFactor *= -1;
        }
        return iFactor;
    }

    public static double getSignificantDecadeValue(double dValue, int firstSignificantDecadeFactor) {
        try {
            return dValue * Math.pow(10.0, firstSignificantDecadeFactor * 3);
        }
        catch (Exception exception) {
            return dValue;
        }
    }

    public static double checkValue(double min, double max, double value) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static float checkValue(float min, float max, float value) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int checkValue(int min, int max, int value) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static long checkValue(long min, long max, long value) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static boolean onlyCapitalLetters(String input) {
        if (input == null) {
            return false;
        }
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c < 'A' || c > 'Z') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

