/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.data.type;

import com.schott.let2.util.data.parse.ParsingUtil;
import com.schott.let2.util.data.value.ValueUtil;
import com.schott.let2.util.time.TimeUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class ADataType {
    public static final String CONTENT_NONE = "";
    public static final String CONTENT_NA = "N/A";
    public static final int DATATYPE_UNKNOWN = -1;
    public static final int DATATYPE_NONE = 0;
    public static final int DATATYPE_BOOL_SINGLE = 100;
    public static final int DATATYPE_BOOL_ARRAY = 110;
    public static final int DATATYPE_BOOL_ARRAYLIST = 120;
    public static final int DATATYPE_INT_SINGLE = 200;
    public static final int DATATYPE_INT_ARRAY = 210;
    public static final int DATATYPE_INT_ARRAYLIST = 220;
    public static final int DATATYPE_LONG_SINGLE = 300;
    public static final int DATATYPE_LONG_ARRAY = 310;
    public static final int DATATYPE_LONG_ARRAYLIST = 320;
    public static final int DATATYPE_FLOAT_SINGLE = 401;
    public static final int DATATYPE_FLOAT_ARRAY = 411;
    public static final int DATATYPE_FLOAT_ARRAYLIST = 421;
    public static final int DATATYPE_DOUBLE_SINGLE = 400;
    public static final int DATATYPE_DOUBLE_ARRAY = 410;
    public static final int DATATYPE_DOUBLE_ARRAYLIST = 420;
    public static final int DATATYPE_STRING_SINGLE = 500;
    public static final int DATATYPE_STRING_ARRAY = 510;
    public static final int DATATYPE_STRING_ARRAYLIST = 520;
    public static final int DATATYPE_DATE_SINGLE = 600;
    public static final int DATATYPE_BYTEBUF = 1000;

    public static boolean isDataTypeValid(int dataType) {
        switch (dataType) {
            case 100: 
            case 110: 
            case 120: 
            case 200: 
            case 210: 
            case 220: 
            case 300: 
            case 310: 
            case 320: 
            case 400: 
            case 401: 
            case 410: 
            case 411: 
            case 420: 
            case 421: 
            case 500: 
            case 510: 
            case 520: 
            case 600: 
            case 1000: {
                return true;
            }
        }
        return false;
    }

    public static String dataToString(Object data) {
        if (data instanceof Boolean) {
            return Boolean.toString((Boolean)data);
        }
        if (data instanceof boolean[]) {
            String s = CONTENT_NONE;
            boolean[] bA = (boolean[])data;
            int idx = 0;
            while (idx < bA.length) {
                s = String.valueOf(s) + Boolean.toString(bA[idx]);
                if (idx < bA.length - 1) {
                    s = String.valueOf(s) + "!";
                }
                ++idx;
            }
            return s;
        }
        if (data instanceof Integer) {
            return Integer.toString((Integer)data);
        }
        if (data instanceof int[]) {
            String s = CONTENT_NONE;
            int[] iA = (int[])data;
            int idx = 0;
            while (idx < iA.length) {
                s = String.valueOf(s) + Integer.toString(iA[idx]);
                if (idx < iA.length - 1) {
                    s = String.valueOf(s) + "!";
                }
                ++idx;
            }
            return s;
        }
        if (data instanceof Long) {
            return Long.toString((Long)data);
        }
        if (data instanceof long[]) {
            String s = CONTENT_NONE;
            long[] lA = (long[])data;
            int idx = 0;
            while (idx < lA.length) {
                s = String.valueOf(s) + Long.toString(lA[idx]);
                if (idx < lA.length - 1) {
                    s = String.valueOf(s) + "!";
                }
                ++idx;
            }
            return s;
        }
        if (data instanceof Float) {
            return Float.toString(((Float)data).floatValue());
        }
        if (data instanceof float[]) {
            String s = CONTENT_NONE;
            float[] fA = (float[])data;
            int idx = 0;
            while (idx < fA.length) {
                s = String.valueOf(s) + Float.toString(fA[idx]);
                if (idx < fA.length - 1) {
                    s = String.valueOf(s) + "!";
                }
                ++idx;
            }
            return s;
        }
        if (data instanceof Double) {
            return Double.toString((Double)data);
        }
        if (data instanceof double[]) {
            String s = CONTENT_NONE;
            double[] dA = (double[])data;
            int idx = 0;
            while (idx < dA.length) {
                s = String.valueOf(s) + Double.toString(dA[idx]);
                if (idx < dA.length - 1) {
                    s = String.valueOf(s) + "!";
                }
                ++idx;
            }
            return s;
        }
        if (data instanceof String) {
            return ParsingUtil.replaceNewLinesSpecial(ParsingUtil.replaceSpecialCharacters((String)data));
        }
        if (data instanceof String[]) {
            String s = CONTENT_NONE;
            String[] sA = (String[])data;
            int idx = 0;
            while (idx < sA.length) {
                s = String.valueOf(s) + ParsingUtil.replaceNewLinesSpecial(ParsingUtil.replaceSpecialCharacters(sA[idx]));
                if (idx < sA.length - 1) {
                    s = String.valueOf(s) + "!";
                }
                ++idx;
            }
            return s;
        }
        if (data instanceof Date) {
            return TimeUtil.getDateFileString((Date)((Date)data));
        }
        if (data instanceof ByteBuffer) {
            return new String(((ByteBuffer)data).array());
        }
        if (data instanceof List && !((List)data).isEmpty()) {
            if (((List)data).get(0) instanceof Boolean) {
                String s = CONTENT_NONE;
                List bList = (List)data;
                int idx = 0;
                while (idx < bList.size()) {
                    s = String.valueOf(s) + Boolean.toString((Boolean)bList.get(idx));
                    if (idx < bList.size() - 1) {
                        s = String.valueOf(s) + "!";
                    }
                    ++idx;
                }
                return s;
            }
            if (((List)data).get(0) instanceof Integer) {
                String s = CONTENT_NONE;
                List iList = (List)data;
                int idx = 0;
                while (idx < iList.size()) {
                    s = String.valueOf(s) + Integer.toString((Integer)iList.get(idx));
                    if (idx < iList.size() - 1) {
                        s = String.valueOf(s) + "!";
                    }
                    ++idx;
                }
                return s;
            }
            if (((List)data).get(0) instanceof Long) {
                String s = CONTENT_NONE;
                List lList = (List)data;
                int idx = 0;
                while (idx < lList.size()) {
                    s = String.valueOf(s) + Long.toString((Long)lList.get(idx));
                    if (idx < lList.size() - 1) {
                        s = String.valueOf(s) + "!";
                    }
                    ++idx;
                }
                return s;
            }
            if (((List)data).get(0) instanceof Float) {
                String s = CONTENT_NONE;
                List fList = (List)data;
                int idx = 0;
                while (idx < fList.size()) {
                    s = String.valueOf(s) + Float.toString(((Float)fList.get(idx)).floatValue());
                    if (idx < fList.size() - 1) {
                        s = String.valueOf(s) + "!";
                    }
                    ++idx;
                }
                return s;
            }
            if (((List)data).get(0) instanceof Double) {
                String s = CONTENT_NONE;
                List dList = (List)data;
                int idx = 0;
                while (idx < dList.size()) {
                    s = String.valueOf(s) + Double.toString((Double)dList.get(idx));
                    if (idx < dList.size() - 1) {
                        s = String.valueOf(s) + "!";
                    }
                    ++idx;
                }
                return s;
            }
            if (((List)data).get(0) instanceof String) {
                String s = CONTENT_NONE;
                List sList = (List)data;
                int idx = 0;
                while (idx < sList.size()) {
                    s = String.valueOf(s) + ParsingUtil.replaceNewLinesSpecial(ParsingUtil.replaceSpecialCharacters((String)sList.get(idx)));
                    if (idx < sList.size() - 1) {
                        s = String.valueOf(s) + "!";
                    }
                    ++idx;
                }
                return s;
            }
        }
        return CONTENT_NONE;
    }

    public static Object dataFromString(String data, int dataType) {
        try {
            switch (dataType) {
                case 100: {
                    return Boolean.parseBoolean(data);
                }
                case 110: {
                    String[] splitBA = data.split("!");
                    boolean[] bA = new boolean[splitBA.length];
                    int idx = 0;
                    while (idx < splitBA.length) {
                        bA[idx] = Boolean.parseBoolean(splitBA[idx]);
                        ++idx;
                    }
                    return bA;
                }
                case 120: {
                    String[] splitBAL = data.split("!");
                    ArrayList<Boolean> bList = new ArrayList<Boolean>(0);
                    String[] stringArray = splitBAL;
                    int n = splitBAL.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        bList.add(Boolean.parseBoolean(s));
                        ++n2;
                    }
                    return bList;
                }
                case 200: {
                    return Integer.parseInt(data);
                }
                case 210: {
                    String[] splitIA = data.split("!");
                    int[] iA = new int[splitIA.length];
                    int idx = 0;
                    while (idx < splitIA.length) {
                        iA[idx] = Integer.parseInt(splitIA[idx]);
                        ++idx;
                    }
                    return iA;
                }
                case 220: {
                    String[] splitIAL = data.split("!");
                    ArrayList<Integer> iList = new ArrayList<Integer>(0);
                    String[] stringArray = splitIAL;
                    int n = splitIAL.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String s = stringArray[n3];
                        iList.add(Integer.parseInt(s));
                        ++n3;
                    }
                    return iList;
                }
                case 300: {
                    return Long.parseLong(data);
                }
                case 310: {
                    String[] splitLA = data.split("!");
                    long[] lA = new long[splitLA.length];
                    int idx = 0;
                    while (idx < splitLA.length) {
                        lA[idx] = Long.parseLong(splitLA[idx]);
                        ++idx;
                    }
                    return lA;
                }
                case 320: {
                    String[] splitLAL = data.split("!");
                    ArrayList<Long> lList = new ArrayList<Long>(0);
                    String[] stringArray = splitLAL;
                    int n = splitLAL.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String s = stringArray[n4];
                        lList.add(Long.parseLong(s));
                        ++n4;
                    }
                    return lList;
                }
                case 401: {
                    return Float.valueOf(Float.parseFloat(ADataType.getSafeFloatingPointString(data)));
                }
                case 411: {
                    String[] splitFA = data.split("!");
                    float[] fA = new float[splitFA.length];
                    int idx = 0;
                    while (idx < splitFA.length) {
                        fA[idx] = Float.parseFloat(ADataType.getSafeFloatingPointString(splitFA[idx]));
                        ++idx;
                    }
                    return fA;
                }
                case 421: {
                    String[] splitFAL = data.split("!");
                    ArrayList<Float> fList = new ArrayList<Float>(0);
                    String[] stringArray = splitFAL;
                    int n = splitFAL.length;
                    int n5 = 0;
                    while (n5 < n) {
                        String s = stringArray[n5];
                        fList.add(Float.valueOf(Float.parseFloat(ADataType.getSafeFloatingPointString(s))));
                        ++n5;
                    }
                    return fList;
                }
                case 400: {
                    return Double.parseDouble(ADataType.getSafeFloatingPointString(data));
                }
                case 410: {
                    String[] splitDA = data.split("!");
                    double[] dA = new double[splitDA.length];
                    int idx = 0;
                    while (idx < splitDA.length) {
                        dA[idx] = Double.parseDouble(ADataType.getSafeFloatingPointString(splitDA[idx]));
                        ++idx;
                    }
                    return dA;
                }
                case 420: {
                    String[] splitDAL = data.split("!");
                    ArrayList<Double> dList = new ArrayList<Double>(0);
                    String[] stringArray = splitDAL;
                    int n = splitDAL.length;
                    int n6 = 0;
                    while (n6 < n) {
                        String s = stringArray[n6];
                        dList.add(Double.parseDouble(ADataType.getSafeFloatingPointString(s)));
                        ++n6;
                    }
                    return dList;
                }
                case 500: {
                    return ParsingUtil.restoreNewLinesSpecial(ParsingUtil.restoreSpecialCharacters(data));
                }
                case 510: {
                    String[] splitSA = data.split("!");
                    String[] sA = new String[splitSA.length];
                    int idx = 0;
                    while (idx < splitSA.length) {
                        sA[idx] = ParsingUtil.restoreNewLinesSpecial(ParsingUtil.restoreSpecialCharacters(splitSA[idx]));
                        ++idx;
                    }
                    return sA;
                }
                case 520: {
                    String[] splitSAL = data.split("!");
                    ArrayList<String> sList = new ArrayList<String>(0);
                    String[] stringArray = splitSAL;
                    int n = splitSAL.length;
                    int n7 = 0;
                    while (n7 < n) {
                        String s = stringArray[n7];
                        sList.add(ParsingUtil.restoreNewLinesSpecial(ParsingUtil.restoreSpecialCharacters(s)));
                        ++n7;
                    }
                    return sList;
                }
                case 600: {
                    return TimeUtil.parseDateFileString((String)data);
                }
                case 1000: {
                    return ByteBuffer.wrap(data.getBytes());
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Double> dataFromStringAsDoubleArrayList(String data, int dataType) {
        ArrayList<Double> dValueList = new ArrayList<Double>();
        Object oData = ADataType.dataFromString(data, dataType);
        if (oData instanceof Boolean) {
            dValueList.add((Boolean)oData != false ? 1.0 : 0.0);
        } else if (oData instanceof boolean[]) {
            boolean[] bA = (boolean[])oData;
            int idx = 0;
            while (idx < bA.length) {
                dValueList.add(bA[idx] ? 1.0 : 0.0);
                ++idx;
            }
        } else if (oData instanceof Integer) {
            dValueList.add((double)((Integer)oData));
        } else if (oData instanceof int[]) {
            int[] iA = (int[])oData;
            int idx = 0;
            while (idx < iA.length) {
                dValueList.add(Double.valueOf(iA[idx]));
                ++idx;
            }
        } else if (oData instanceof Long) {
            dValueList.add((double)((Long)oData));
        } else if (oData instanceof long[]) {
            long[] lA = (long[])oData;
            int idx = 0;
            while (idx < lA.length) {
                dValueList.add(Double.valueOf(lA[idx]));
                ++idx;
            }
        } else if (oData instanceof Float) {
            dValueList.add(Double.valueOf(((Float)oData).floatValue()));
        } else if (oData instanceof float[]) {
            float[] fA = (float[])oData;
            int idx = 0;
            while (idx < fA.length) {
                dValueList.add(Double.valueOf(fA[idx]));
                ++idx;
            }
        } else if (oData instanceof Double) {
            dValueList.add((Double)oData);
        } else if (oData instanceof double[]) {
            double[] dA = (double[])oData;
            int idx = 0;
            while (idx < dA.length) {
                dValueList.add(dA[idx]);
                ++idx;
            }
        } else if (!(oData instanceof String || oData instanceof String[] || oData instanceof Date || oData instanceof ByteBuffer || !(oData instanceof List) || ((List)oData).isEmpty())) {
            if (((List)oData).get(0) instanceof Boolean) {
                List bList = (List)oData;
                int idx = 0;
                while (idx < bList.size()) {
                    dValueList.add((Boolean)bList.get(idx) != false ? 1.0 : 0.0);
                    ++idx;
                }
            } else if (((List)oData).get(0) instanceof Integer) {
                List iList = (List)oData;
                int idx = 0;
                while (idx < iList.size()) {
                    dValueList.add((double)((Integer)iList.get(idx)));
                    ++idx;
                }
            } else if (((List)oData).get(0) instanceof Long) {
                List lList = (List)oData;
                int idx = 0;
                while (idx < lList.size()) {
                    dValueList.add((double)((Long)lList.get(idx)));
                    ++idx;
                }
            } else if (((List)oData).get(0) instanceof Float) {
                List fList = (List)oData;
                int idx = 0;
                while (idx < fList.size()) {
                    dValueList.add(Double.valueOf(((Float)fList.get(idx)).floatValue()));
                    ++idx;
                }
            } else if (((List)oData).get(0) instanceof Double) {
                List dList = (List)oData;
                dValueList.addAll(dList);
            } else {
                boolean cfr_ignored_0 = ((List)oData).get(0) instanceof String;
            }
        }
        return dValueList;
    }

    public static double dataFromStringAsDouble(String data, int dataType) {
        Object oData = ADataType.dataFromString(data, dataType);
        if (oData instanceof Boolean) {
            return (Boolean)oData != false ? 1.0 : 0.0;
        }
        if (!(oData instanceof boolean[])) {
            if (oData instanceof Integer) {
                return ((Integer)oData).intValue();
            }
            if (!(oData instanceof int[])) {
                if (oData instanceof Long) {
                    return ((Long)oData).longValue();
                }
                if (!(oData instanceof long[])) {
                    if (oData instanceof Float) {
                        return ((Float)oData).floatValue();
                    }
                    if (!(oData instanceof float[])) {
                        if (oData instanceof Double) {
                            return (Double)oData;
                        }
                        if (!(oData instanceof double[] || oData instanceof String || oData instanceof String[] || oData instanceof Date || oData instanceof ByteBuffer || !(oData instanceof List) || ((List)oData).isEmpty() || ((List)oData).get(0) instanceof Boolean || ((List)oData).get(0) instanceof Integer || ((List)oData).get(0) instanceof Long || ((List)oData).get(0) instanceof Float || ((List)oData).get(0) instanceof Double)) {
                            boolean cfr_ignored_0 = ((List)oData).get(0) instanceof String;
                        }
                    }
                }
            }
        }
        return Double.NaN;
    }

    public static int dataArraySizeFromString(String data) {
        block5: {
            block4: {
                try {
                    if (data != null) break block4;
                    return 0;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            if (!data.isEmpty()) break block5;
            return 0;
        }
        return data.split("!").length;
    }

    public static Object dataCopy(Object data) {
        if (data instanceof Boolean) {
            return new Boolean((Boolean)data);
        }
        if (data instanceof boolean[]) {
            boolean[] bA = (boolean[])data;
            boolean[] bACopy = new boolean[bA.length];
            int idx = 0;
            while (idx < bA.length) {
                bACopy[idx] = new Boolean(bA[idx]);
                ++idx;
            }
            return bACopy;
        }
        if (data instanceof Integer) {
            return new Integer((Integer)data);
        }
        if (data instanceof int[]) {
            int[] iA = (int[])data;
            int[] iACopy = new int[iA.length];
            int idx = 0;
            while (idx < iA.length) {
                iACopy[idx] = new Integer(iA[idx]);
                ++idx;
            }
            return iACopy;
        }
        if (data instanceof Long) {
            return new Long((Long)data);
        }
        if (data instanceof long[]) {
            long[] lA = (long[])data;
            long[] lACopy = new long[lA.length];
            int idx = 0;
            while (idx < lA.length) {
                lACopy[idx] = new Long(lA[idx]);
                ++idx;
            }
            return lACopy;
        }
        if (data instanceof Float) {
            return new Float(((Float)data).floatValue());
        }
        if (data instanceof float[]) {
            float[] fA = (float[])data;
            float[] fACopy = new float[fA.length];
            int idx = 0;
            while (idx < fA.length) {
                fACopy[idx] = new Float(fA[idx]).floatValue();
                ++idx;
            }
            return fACopy;
        }
        if (data instanceof Double) {
            return new Double((Double)data);
        }
        if (data instanceof double[]) {
            double[] dA = (double[])data;
            double[] dACopy = new double[dA.length];
            int idx = 0;
            while (idx < dA.length) {
                dACopy[idx] = new Double(dA[idx]);
                ++idx;
            }
            return dACopy;
        }
        if (data instanceof String) {
            return new String((String)data);
        }
        if (data instanceof String[]) {
            String[] sA = (String[])data;
            String[] sACopy = new String[sA.length];
            int idx = 0;
            while (idx < sA.length) {
                sACopy[idx] = new String(sA[idx]);
                ++idx;
            }
            return sACopy;
        }
        if (data instanceof Date) {
            return new Date(((Date)data).getTime());
        }
        if (data instanceof ByteBuffer) {
            return ByteBuffer.wrap(((ByteBuffer)data).array());
        }
        if (data instanceof List && !((List)data).isEmpty()) {
            if (((List)data).get(0) instanceof Boolean) {
                List bList = (List)data;
                ArrayList<Boolean> bListCopy = new ArrayList<Boolean>();
                int idx = 0;
                while (idx < bList.size()) {
                    bListCopy.add(new Boolean((Boolean)bList.get(idx)));
                    ++idx;
                }
                return bListCopy;
            }
            if (((List)data).get(0) instanceof Integer) {
                List iList = (List)data;
                ArrayList<Integer> iListCopy = new ArrayList<Integer>();
                int idx = 0;
                while (idx < iList.size()) {
                    iListCopy.add(new Integer((Integer)iList.get(idx)));
                    ++idx;
                }
                return iListCopy;
            }
            if (((List)data).get(0) instanceof Long) {
                List lList = (List)data;
                ArrayList<Long> lListCopy = new ArrayList<Long>();
                int idx = 0;
                while (idx < lList.size()) {
                    lListCopy.add(new Long((Long)lList.get(idx)));
                    ++idx;
                }
                return lListCopy;
            }
            if (((List)data).get(0) instanceof Float) {
                List fList = (List)data;
                ArrayList<Float> fListCopy = new ArrayList<Float>();
                int idx = 0;
                while (idx < fList.size()) {
                    fListCopy.add(new Float(((Float)fList.get(idx)).floatValue()));
                    ++idx;
                }
                return fListCopy;
            }
            if (((List)data).get(0) instanceof Double) {
                List dList = (List)data;
                ArrayList<Double> dListCopy = new ArrayList<Double>();
                int idx = 0;
                while (idx < dList.size()) {
                    dListCopy.add(new Double((Double)dList.get(idx)));
                    ++idx;
                }
                return dListCopy;
            }
            if (((List)data).get(0) instanceof String) {
                List sList = (List)data;
                ArrayList<String> sListCopy = new ArrayList<String>();
                int idx = 0;
                while (idx < sList.size()) {
                    sListCopy.add(new String((String)sList.get(idx)));
                    ++idx;
                }
                return sListCopy;
            }
        }
        return null;
    }

    public static boolean isDataInTolerance(int dataType, String pValue, String pValueMin, String pValueMax) {
        return ADataType.isDataInTolerance(dataType, ADataType.dataFromString(pValue, dataType), ADataType.dataFromString(pValueMin, dataType), ADataType.dataFromString(pValueMax, dataType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDataInTolerance(int dataType, Object pValue, Object pValueMin, Object pValueMax) {
        try {
            switch (dataType) {
                case 100: {
                    return ValueUtil.isInTolerance((Boolean)pValueMin, (Boolean)pValue);
                }
                case 110: {
                    return false;
                }
                case 120: {
                    return false;
                }
                case 200: {
                    return ValueUtil.isInTolerance((Integer)pValueMin, (Integer)pValueMax, (Integer)pValue);
                }
                case 210: {
                    return false;
                }
                case 220: {
                    return false;
                }
                case 300: {
                    return ValueUtil.isInTolerance((Long)pValueMin, (Long)pValueMax, (Long)pValue);
                }
                case 310: {
                    return false;
                }
                case 320: {
                    return false;
                }
                case 401: {
                    return ValueUtil.isInTolerance(((Float)pValueMin).floatValue(), ((Float)pValueMax).floatValue(), ((Float)pValue).floatValue());
                }
                case 411: {
                    return false;
                }
                case 421: {
                    return false;
                }
                case 400: {
                    return ValueUtil.isInTolerance((Double)pValueMin, (Double)pValueMax, (Double)pValue);
                }
                case 410: {
                    return false;
                }
                case 420: {
                    return false;
                }
                case 500: {
                    return false;
                }
                case 510: {
                    return false;
                }
                case 520: {
                    return false;
                }
                case 600: {
                    return false;
                }
                case 1000: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getValueToleranceString(double min, double max, double value, int precision, boolean isValueValid, String sUnit) {
        String sString = CONTENT_NONE;
        sString = String.valueOf(sString) + ValueUtil.doubleToString(min, precision);
        sString = String.valueOf(sString) + " <= ";
        sString = isValueValid ? String.valueOf(sString) + ValueUtil.doubleToString(value, precision) : String.valueOf(sString) + CONTENT_NA;
        sString = String.valueOf(sString) + " <= ";
        sString = String.valueOf(sString) + ValueUtil.doubleToString(max, precision);
        if (sUnit != null) {
            sString = String.valueOf(sString) + sUnit;
        }
        return sString;
    }

    public static String getSafeFloatingPointString(String sInput) {
        if (sInput.contains(",")) {
            return sInput.replace(",", ".");
        }
        return sInput;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double[] getMinMeanMaxFromList(int dataType, List<Object> oValueList) {
        try {
            double[] dMinMeanMax = new double[4];
            boolean isMinInit = true;
            boolean isMaxInit = true;
            double dSum = 0.0;
            switch (dataType) {
                case 100: 
                case 110: 
                case 120: {
                    return null;
                }
                case 200: {
                    int idx = 0;
                    while (true) {
                        if (idx >= oValueList.size()) {
                            dMinMeanMax[1] = dSum / (double)oValueList.size();
                            dMinMeanMax[3] = 0.0;
                            return dMinMeanMax;
                        }
                        int iValue = (Integer)oValueList.get(idx);
                        if (isMinInit) {
                            dMinMeanMax[0] = iValue;
                            isMinInit = false;
                        } else if (iValue < (int)dMinMeanMax[0]) {
                            dMinMeanMax[0] = iValue;
                        }
                        if (isMaxInit) {
                            dMinMeanMax[2] = iValue;
                            isMaxInit = false;
                        } else if (iValue > (int)dMinMeanMax[2]) {
                            dMinMeanMax[2] = iValue;
                        }
                        dSum += (double)iValue;
                        ++idx;
                    }
                }
                case 210: 
                case 220: {
                    return null;
                }
                case 300: {
                    int idx = 0;
                    while (true) {
                        if (idx >= oValueList.size()) {
                            dMinMeanMax[1] = dSum / (double)oValueList.size();
                            dMinMeanMax[3] = 0.0;
                            return dMinMeanMax;
                        }
                        long lValue = (Long)oValueList.get(idx);
                        if (isMinInit) {
                            dMinMeanMax[0] = lValue;
                            isMinInit = false;
                        } else if (lValue < (long)dMinMeanMax[0]) {
                            dMinMeanMax[0] = lValue;
                        }
                        if (isMaxInit) {
                            dMinMeanMax[2] = lValue;
                            isMaxInit = false;
                        } else if (lValue > (long)dMinMeanMax[2]) {
                            dMinMeanMax[2] = lValue;
                        }
                        dSum += (double)lValue;
                        ++idx;
                    }
                }
                case 310: 
                case 320: {
                    return null;
                }
                case 401: {
                    dMinMeanMax[3] = 0.0;
                    int idx = 0;
                    while (true) {
                        if (idx >= oValueList.size()) {
                            dMinMeanMax[1] = dSum / (double)oValueList.size();
                            return dMinMeanMax;
                        }
                        float fValue = ((Float)oValueList.get(idx)).floatValue();
                        try {
                            String sValue = Float.toString(fValue);
                            String[] sValueS = sValue.split("\\.");
                            int digits = sValueS[sValueS.length - 1].length();
                            if ((double)digits > dMinMeanMax[3]) {
                                dMinMeanMax[3] = digits;
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        if (isMinInit) {
                            dMinMeanMax[0] = fValue;
                            isMinInit = false;
                        } else if (fValue < (float)dMinMeanMax[0]) {
                            dMinMeanMax[0] = fValue;
                        }
                        if (isMaxInit) {
                            dMinMeanMax[2] = fValue;
                            isMaxInit = false;
                        } else if (fValue > (float)dMinMeanMax[2]) {
                            dMinMeanMax[2] = fValue;
                        }
                        dSum += (double)fValue;
                        ++idx;
                    }
                }
                case 411: 
                case 421: {
                    return null;
                }
                case 400: {
                    int idx = 0;
                    while (true) {
                        if (idx >= oValueList.size()) {
                            dMinMeanMax[1] = dSum / (double)oValueList.size();
                            return dMinMeanMax;
                        }
                        double dValue = (Double)oValueList.get(idx);
                        try {
                            String sValue = Double.toString(dValue);
                            String[] sValueS = sValue.split("\\.");
                            int digits = sValueS[sValueS.length - 1].length();
                            if ((double)digits > dMinMeanMax[3]) {
                                dMinMeanMax[3] = digits;
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        if (isMinInit) {
                            dMinMeanMax[0] = dValue;
                            isMinInit = false;
                        } else if (dValue < dMinMeanMax[0]) {
                            dMinMeanMax[0] = dValue;
                        }
                        if (isMaxInit) {
                            dMinMeanMax[2] = dValue;
                            isMaxInit = false;
                        } else if (dValue > dMinMeanMax[2]) {
                            dMinMeanMax[2] = dValue;
                        }
                        dSum += dValue;
                        ++idx;
                    }
                }
                case 410: 
                case 420: {
                    return null;
                }
                case 500: 
                case 510: 
                case 520: {
                    return null;
                }
                case 600: {
                    return null;
                }
                case 1000: {
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

