/*
 * Decompiled with CFR 0.152.
 */
package com.schott.let2.util.sound;

import com.schott.let2.util.sound.runnable.SoundRunnable;

public class MySoundPlayer {
    private static int instanceCnt = 0;
    private SoundRunnable player = new SoundRunnable();
    private Thread soundThread = new Thread((Runnable)this.player, "MySoundPlayer #" + ++instanceCnt);

    public MySoundPlayer() {
        this.soundThread.start();
    }

    public boolean playSingle(String path, double gain) {
        return this.play(path, 0, gain, 0, 0L);
    }

    public boolean playMulti(String path, double gain, int loopCount, long loopDelayInMS) {
        return this.play(path, 1, gain, loopCount, loopDelayInMS);
    }

    public boolean playUnlimited(String path, double gain, long loopDelayInMS) {
        return this.play(path, 2, gain, 0, loopDelayInMS);
    }

    private boolean play(String path, int mode, double gain, int loopCount, long loopDelayInMS) {
        if (this.player == null) {
            return false;
        }
        if (this.soundThread == null) {
            return false;
        }
        if (this.player.isPlayingActive() && !this.player.stopPlay()) {
            return false;
        }
        if (!this.player.setPath(path)) {
            return false;
        }
        if (!this.player.setMode(mode)) {
            return false;
        }
        this.player.setGain(gain);
        this.player.setLoopCnt(loopCount);
        this.player.setLoopDelay(loopDelayInMS);
        this.player.startPlay();
        return true;
    }

    public void stop() {
        if (this.player != null && this.soundThread != null && this.player.isPlayingActive()) {
            this.player.stopPlay();
        }
    }

    public void dispose() {
        if (this.player != null) {
            if (this.soundThread != null) {
                this.player.stop();
                this.soundThread = null;
            }
            this.player = null;
        }
    }
}

